procedure DeadEndAnalysis;

var 
  len, maxlen : integer;
  distrib     : array [1..8] of integer;
  s           : sector;
  fname       : string;
  f           : text;
  distances   : distanceArray;

procedure CheckBackDoor( var f : text; base : sector );
{ verify no back doors into path }
var
  previous, current, NextUp : sector;
begin
  write(f, 'Tunnel starting at ', base, ' : ');
  previous := base;
  write( f, base );
  if AppearanceCount( base ) = space.sectors[base].number then
    write(f, ' ok ')
  else
    write(f, ' back door ');
  current := space.sectors[base].data[1];
  while (space.sectors[current].number = 2) do
    begin
      write( f, current );
      if AppearanceCount( current ) = space.sectors[current].number then
        write(f, ' ok ')
      else
        write(f, ' back door ');
      NextUp := space.sectors[current].data[1];
      if NextUp = previous then
        NextUp := space.sectors[current].data[2];
      previous := current;
      current := nextUp;
    end; {while}
end; {Check Back Door}

begin
  for len := 1 to 8 do
    distrib[ len ] := 0;
  maxlen := 0;
  for s := 1 to MaxSector do
    if space.sectors[s].number = 1 then
      begin
        len := howfar( s );
        if len > maxlen then
          maxlen := len;
        distrib[ len ] := distrib[ len ] + 1;
      end; {for if}
  writeln('Distributions of tunnel lengths:');
  for len := 1 to 8 do
    write( len : 2, ': ', distrib[len] : 3, '.  ');
  writeln;
  writeln;
  writeln('Maximum length of any tunnel is ', maxlen);
  writeln;
  TwoWayDistances( 1, distances, false, true );
  writeln;
  write('File for storage of results?  (hit return for screen)  ');
  readln( fname );
  assign( f, fname );
  rewrite( f );
  repeat
    write('Which lengths do you want to check for 1-way entrances? (0 to exit) ');
    readln( len );
    if len > 0 then
      for s := 1 to MaxSector do
        if space.sectors[s].number = 1 then
          if howfar(s) = len then
            begin
              checkBackDoor( f, s );
              writeln( f, ' at distance ', distances[s].d, ' from terra.' );
            end;
  until len = 0;
  close(f);
end; {dead end stuff}