procedure TwoWayDistances( sec : sector; var D : distanceArray;
                           inward, outward : boolean );
{ inward = accept TOWARD sec; outward = accept LEAVING sec }
{ D[j].d = distance from sec;
  D[j].s = one node close }
var
  si : sectorIndex;
  wi : warpIndex;
  breadth : queue;
  s,
  daddy, sonny : sector;
  i : warpindex;
  entered : array [ sector ] of boolean;
begin
  if inward then
    write('(This may take a while.)  ');
  writeln('Computing distances...');
  for s := 1 to maxSector do
    begin
      D[s].d := -1;
      entered[ s ] := false;
    end; {for}
  breadth.front := 0;
  enqueue( breadth, sec, sec );
  entered[sec] := true;
  while breadth.front > 0 do
    begin
      serve( breadth, daddy, sonny );
      if D[ sonny ].d = -1 then {haven't hit him before:}
        begin
          D[ sonny ].d := D[ daddy ].d + 1;
          D[ sonny ].s := daddy;
          if outward then
            with space.sectors[ sonny ] do if number > 0 then
              if (space.sectors[sonny].etc and avoid) = Nothing then
                for wi := 1 to number do
                  if not entered[ data[wi] ] then
                    begin
                      enqueue( breadth, sonny, data[ wi ] );
                      entered[ data[wi] ] := true;
                    end; {if with for if}
          if inward then
            for s := 1 to maxSector do
              if not entered[ s ] then
                if IsWarp( s, sonny ) then
                  begin
                    enqueue( breadth, sonny, s );
                    entered[ s ] := true;
                  end; {if for if if}
        end; {if}
    end; {while}
  for s := 1 to maxSector do if D[s].d = -1 then D[s].d := maxint;
end; {FixDistances}

function CountDist(var D : distancearray; howfar : integer ):integer;
var
  c : integer;
  s : sector;
begin
  c := 0;
  for s := 1 to maxSector do
    if D[ s ].d <= howfar then
      c := c + 1;
  countDist := c;
end; {CountDist}

procedure SortDistances( var D : distancearray; largest : sector );
{ sort, based upon "d" field.  }
var
  smallest : dist;
  where    : sector;
  s, t     : sector;
begin
  for s := 1 to largest - 1 do
    begin
      smallest := d[s];
      where := s;
      for t := s + 1 to largest do
        if smallest.d > d[t].d then
          begin
            smallest := d[t];
            where := t;
          end; {for t}
        d[where] := d[s];
        d[s] := smallest;
    end; {for s}
end; {Sort Distances}

function SetupDistances : boolean;
{ return false if they aborted }
var
  s, n : integer;
begin
  s := GetSector;
  if s <> 0 then
    begin
      TwoWayDistances( s, distances, false, true );
      for n := 1 to maxSector do distances[ n ].s := n;
      SetUpDistances := true;
    end {if}
  else
    SetUpDistances := false;
end; {SetUpDistances}
