procedure MakePort;
var
  s : SectorIndex;
  pt : integer;
begin
  write('Make a port out of which ');
  s := GetSector;
  if s <> 0 then
    if space.sectors[ s ].portType <> NotAPort then
      writeln( s, ' is already a port!')
    else
      space.sectors[s].portType := GetPortType;

end;

procedure KillPort;
var
  s : SectorIndex;
  p1 : portIndex;
begin
  write('Remove Record for Port in which ');
  s := GetSector;
  if s <> 0 then
    if space.sectors[s].PortType = NotAPort then
      writeln( 'I have no record of ', s, ' being a port.')
    else
      begin
        space.sectors[s].portType := NotAPort;
        p1 := portNumber( s );
        space.ports.data[ p1 ] := space.ports.data[ space.ports.top ];
        space.ports.top := space.ports.top - 1;
      end;
end;

procedure SetDock;
var
  sd : SectorIndex;
begin
  if space.dock = 0 then
    writeln('Space Dock location is not known')
  else
    writeln('Current space dock in sector ', space.dock );
  write('Put Space Dock in which ');
  sd := GetSector;
  if sd = 0 then
    if not prompt('Make stardock location unknown?') then
      exit;
  space.dock := sd;
  if sd <> 0 then
    with space.sectors[ sd ] do
      etc := etc or StarDock;
end;

procedure Unexplore;
var
  us : sectorIndex;
begin
  write('Mark as Unexplored Which ');
  us := GetSector;
  if us <> 0 then
    if space.sectors[ us ].number = Unexplored then
      writeln( 'Sector ', us, ' is already marked as unexplored.')
    else
      begin
        writeln('Marking ', us, ' as unexplored.');
        space.sectors[ us ].number := Unexplored;
      end; {if else}
end; {unexplore}

procedure AvoidSector;
var
  us : sectorIndex;
begin
  write('Toggle avoid state on which? ');
  us := GetSector;
  if us <> 0 then
    with space.sectors[ us ] do
      if (etc and avoid) = Nothing  then
        begin
          etc := etc or avoid;
          writeln('Sector ', us, ' marked as avoided.');
        end
      else
        begin
          etc := etc and (not avoid);
          writeln('Sector ', us, ' marked as accessible.');
        end;
end; {unexplore}

procedure ClearAvoids;
var
  i : sector;
begin
  for i := 1 to MaxSector do
    space.sectors[i].etc := space.sectors[i].etc and (not avoid);
  writeln('All avoids cleared.');
end;

procedure ListAvoids;
var
  i : sector;
begin
  writeln('Sectors marked to be avoided:');
  for i := 1 to MaxSector do
    if (space.sectors[i].etc and avoid) <> Nothing then
      write( i : 5 );
  writeln;
end;


procedure EditMenu;
{ choices for direct editing the data base }
var
  ch : char;
begin
  repeat
    repeat
      writeln('Declare a sector to be a <P>ort');
      writeln('Declare a sector <N>OT to be a port');
      writeln('Define location of Star <D>ock');
      writeln('Make sector <U>nexplored');
      writeln('Toggle sector a<V>oidance');
      writeln('<L>ist avoided sectors');
      writeln('<C>lear all avoids');
      writeln;
      writeln('<Q>uit');
      writeln;
      write('Your choice? ');
      readln( ch );
      ch := upcase( ch );
    until ch in ['P', 'N', 'D', 'U', 'V', 'C', 'L', 'Q'];
    case ch of
      'P' : Makeport;
      'N' : Killport;
      'D' : setDock;
      'U' : unexplore;
      'V' : avoidSector;
      'C' : clearAvoids;
      'L' : listAvoids;
      'Q' : ;
    end; {case}
  until ch = 'Q';
end; {Edit Menu}