const
{ general constants }
  error      = maxint;
  author     = 'Copyright 1991, 1992 by Robert Weaver.  All Rights Reserved.';
  source     = 'For latest versions, call 510-376-1554';
  version    = 'version 0.92 (dos)';
  FileNotFound =   2;
  abort      = 'abort';
{ universe dimensions }
  maxSector  = 1000;
  maxWarps   = 6;
  maxPorts   = 420;
  maxNote    = 400;
  NoteSize   = 40;
{ sector (warp number) flag }
  UnExplored = 0;
{ stuff flags }
  NotAPort   = -1;
  Class0     = 8;
{ etc flags }
  NoteExists = 1;
  IsPort     = 2;
  HasFighters= 4;
  SpaceLane  = 8;
  Avoid      = 16;
  Stardock   = 128;
  Nothing    = 0;

type
  str3 = string[ 3 ];
  sector     = 1..maxSector;
  dist = record
           d : integer;
           s : sector;
         end;
  distanceArray = array [ sector ] of dist;
  sectorscanner = array [ sector ] of boolean;
  warpindex  = 0..maxWarps;
  stuff      = -1..8;      { 8 = class 0; xxx (binary) Equip, Org, Fuel }
                           {-1 = not a port   1 = sell, 0 = buy         }
  SectorIndex  = 0..maxSector;
  SectorInfo = record
                 number   : 0..maxWarps;
                 data     : array [ 1..maxwarps ] of sector;
                 porttype : stuff;
                 etc      : integer;
               end;

  note = record
           reference : sector;
           info      : string [ NoteSize ];
         end;
  NoteIndex = 0..MaxNote;
  NoteList = record
               top  : NoteIndex;
               data : array [1..MaxNote] of note;
             end;

  goods = ( Fuel, Organics, Equipment );
  GoodsArray = array [ goods ] of integer;   { + = selling; - = buying }
  percent = 0..100;
  PercentArray = array [ goods ] of percent;
  portSales = record
                where : sector;
                amts  : goodsArray;
                usage : percentArray;
                change: goodsArray;
              end;
  PortPtr = 1..MaxPorts;
  PortIndex = 0..MaxPorts;
  PortList  = record
                top  : PortIndex;
                data : array [ PortPtr ] of PortSales;
              end;

  SectorArray = array [ sector ] of SectorInfo;
  TheVoid = record
              dock    : SectorIndex;
              notes   : NoteList;
              Ports   : PortList;
              sectors : SectorArray;
            end;
