const
  MaxMPS = 15;

type
  DistanceTable = array [0..MaxMPS, 0..MaxMPS] of integer;
  SectorVector  = record
                    size : 0..MaxMPS;
                    data : array [0..MaxMPS] of sectorindex;
                  end;

procedure GetDistanceTableData( var D : distanceTable;
                                var V : SectorVector );
{ read n sectors, and specify the n^2 distances between pairs in D }
var
 i, j : 0..MaxMPS;
 temp : sectorindex;
begin
  writeln('First sector specified is your home sector.');
  writeln;
  write('Please enter your sector values: ');
  for i := 0 to V.size do
    begin
      temp := getsector;
      if temp = 0 then
        begin
          v.size := 0;
          exit;
        end {if temp}
      else
        v.data[i] := temp;
    end; {for i}
  for i := 0 to V.size do
    for j := 0 to V.size do
      if i <> j then
        D[ i, j ] := FixPath( V.data[i], V.data[j] );
  for i := 0 to V.size do
    D[i,i] := 0;
end;

function RouteDist( closed : boolean;
                         p : sectorvector;
                         d : distancetable ) : integer;
var
  sum, i : integer;
begin
  if closed then
    sum := d[ p.size, 0 ]
  else
    sum := 0;
  for i := 1 to p.size do
    sum := sum + d[ p.data[ i-1 ], p.data[i] ];
  RouteDist := sum;
end;

procedure HeapPermute(   closed : boolean;
                              n : integer;
                       var perm : SectorVector;
                       var dists: distanceTable;
                   var bestdist : integer;
                   var bestrout : sectorvector );
{B.R.Heap's permutation generator for contiguous lists}
var
  c, t, thisdist : integer;
begin
  c := 1;
  if n > 2 then
    HeapPermute( closed, n-1, perm, dists, bestdist, bestrout )
  else
    begin
      ThisDist := RouteDist( closed, perm, dists );
      if ThisDist < BestDist then
        begin
          BestDist := ThisDist;
          BestRout := perm;
        end;
    end; {else}
  while c < n do
    begin
      if odd(n) then
        begin
          t := perm.data[n];
          perm.data[n] := perm.data[1];
          perm.data[1] := t;
        end
      else
        begin
          t := perm.data[n];
          perm.data[n] := perm.data[c];
          perm.data[c] := t;
        end;
      c := c + 1;
      if n > 2 then
        HeapPermute( closed, n-1, perm, dists, bestdist, bestrout )
      else
        begin
          ThisDist := RouteDist( closed, perm, dists );
          if ThisDist < BestDist then
            begin
              BestDist := ThisDist;
              BestRout := perm;
            end;
        end; {else}
    end; {while}
end;

procedure MultiPassSector;
{ accept a small number of sectors, and find the best path that hits these
sectors (possibly returning to the base sector}
var
  s1, s2     : sector;
  Table      : DistanceTable;
  targets    : SectorVector;
  routes     : SectorVector;
  numsectors : integer;
  i          : integer;
  bestdist   : integer;
  bestroute  : sectorVector;
  closed     : boolean;
begin
  repeat
    write('How many targets? (max ', maxMPS, ', enter 0 to abort)  ');
    readln( NumSectors );
  until (NumSectors >= 0) and (NumSectors <= MaxMPS );
  if NumSectors = 0 then
    exit
  else
    begin
      targets.size := NumSectors;
      GetDistanceTableData( Table, targets );
      if targets.size = 0 then {they aborted routine}
        exit;
      BestDist := maxint;
      Routes.size := NumSectors;
      for i := 0 to NumSectors do routes.data[i] := i;
      bestroute := routes;
      closed := prompt('Closed path? ');
      HeapPermute( closed, NumSectors, routes, table, bestdist, bestroute );
    end;
  writeln('Best distance is ', bestdist );
  write('The best route is: ', targets.data[0] : 4);
  for i := 1 to NumSectors do
    write( ' > ', targets.data[ bestroute.data[i]] : 4 );
  if closed then
    write( ' > ', targets.data[0] : 4 );
  writeln;
  readln;
  writeln('Here are the intermediate paths:');
  for i := 1 to NumSectors do
    begin
      s1 := targets.data[ bestroute.data[i-1] ];
      s2 := targets.data[ bestroute.data[i] ];
      writeln( s1, ' to ', s2, ' of length ', fixpath( s1, s2 ) );
      printpath( s1, s2 );
      readln;
    end; {for}
  if closed then
    begin
      s1 := targets.data[ bestroute.data[ NumSectors] ];
      s2 := targets.data[ 0 ];
      writeln( s1, ' to ', s2, ' of length ', fixpath( s1, s2 ) );
      printpath( s1, s2 );
      readln;
    end;
end;