{procedure PrintPath( var home : sector; sec : sector );
var
  dummy : text;
begin
  if home <> sec then
    PrintPath( home, distances[ sec ].s );
  displaySector( sec, 'Dist', error, false, dummy )
end;
}
procedure PathLength;
var
  s1, s2 : sector;
  len    : integer;
begin
  write('Distance between which two sectors? ');
  readln( s1, s2 );
  if space.sectors[ s1 ].number <> Unexplored then
    begin
      len := FixPath( s1, s2 );
      if len = Error then
        writeln('You don''t know how to get to ', s2, ' from ', s1, '!' )
      else
        begin
          writeln('Known shortest path from ', s1, ' to ', s2, ' is ');
          PrintPath( s1, s2 );
          writeln;
          writeln('Path is of length ', len );
          readln;
        end; {if finite distance}
    end {visited}
  else
    writeln('Never visited ', s1, ' so can''t tell distances leaving it.');
  if space.sectors[ s1 ].number <> UnExplored then
    begin
      len := FixPath( s2, s1 );
      if len = Error then
        writeln('You don''t know how to get to ', s1, ' from ', s2, '!' )
      else
        begin
          writeln('Known shortest path from ', s2, ' to ', s1, ' is ');
          PrintPath( s2, s1 );
          writeln;
          writeln('Path is of length ', len );
        end; {if finite distance}
    end
  else
    writeln('Never visited ', s2, ' so can''t tell distances leaving it.');
end;

procedure NearestFighters;
var
  s, s1, Closest : sector;
begin
  write('What is your current sector?  ');
  readln( s );
  TwoWayDistances( s, distances, false, true );
  Closest := 1;
  for s1 := 1 to maxSector do
    if (space.sectors[ s1 ].portType = Class0) or (s1=space.dock) then
      if distances[ s1 ].d = maxint then
        writeln('You don''t know how to get to ', s1 )
      else
        begin
          writeln('Path to ', s1, ' is of length ', distances[ s1 ].d );
          PrintPath( s, s1 );
          writeln;
          readln;
          if distances[ s1 ].d < distances[ Closest ].d then
            Closest := s1;
        end; {for if else}
  writeln('The closest target for fighters is ', closest );
end; {Nearest Fighters}

