procedure AddFighterCloud( var update : boolean );
{store a sector as having a fighter for transwarp location }
var
  AddSector : sectorindex;
begin
  write('Fighters in which ');
  AddSector := GetSector;
  if AddSector <> 0 then
    begin
      update := true;
      with space.sectors[ AddSector ] do
        etc := etc or HasFighters;
    end; {if}
end; {Add FIghters}

procedure DeleteFighterCloud( var update : boolean );
{ store a sector as NOT having any fighters for transwarp }
var
  DeleteSector : sectorIndex;
begin
  write('Remove Fighters from which ');
  DeleteSector := GetSector;
  if DeleteSector <> 0 then
    begin
      update := true;
      with space.sectors[ DeleteSector ] do
        etc := etc and (not HasFighters);
    end; {if}
end; {Delete Fighters}

procedure ListFighterClouds;
{ List all known sectors with transwarp locator beams }
var
  s : sector;
  log : boolean;
  f : text;
begin
  log := prompt( 'Log to disk? ');
  if log then
    begin
      assign( f, GetNewFileName('File name for report?  ', 'report.txt') );
      rewrite( f );
    end;
  for s := 1 to MaxSector do
    if space.sectors[s].etc and HasFighters <> Nothing then
      DisplaySector( s, ' Dist:', Error, log, f );
  if log then
    close( f );
end; {ListFighterClouds}

procedure TransWarpPathLength;
{ Ask for current sector and target sector.  Give path, which might
include transwarp, using this data. }
var
  CurrentSector, TargetSector : sectorIndex;
  LengthTo, temp              : integer;
  s, WarpTo                   : sector;
begin
  write('Current ');
  CurrentSector := GetSector;
  if CurrentSector = 0 then
    exit;
  write('Destination ');
  TargetSector := GetSector;
  if TargetSector = 0 then
    exit;
  WarpTo := CurrentSector;
  LengthTo := FixPath( currentSector, TargetSector );
  if LengthTo = Error then
    writeln('You don''t know how to get from ', CurrentSector, ' to ',
            TargetSector, '!')
  else
    for s := 1 to MaxSector do
      if space.sectors[s].etc and HasFighters <> Nothing then
        begin
          write('.');
          temp := FixPath( s, TargetSector);
          if (temp <> error) and (temp+1 < LengthTo) then
            begin
              WarpTo := s;
              LengthTo := temp + 1;
            end; {if}
        end; {else for if}
  writeln;
  write('Use Transwarp to ', WarpTo, ' and then autopilot to ',
        TargetSector );
  if LengthTo <> Error then
    writeln(' ( ', LengthTo, ' turns )')
  else
    writeln;
end; {TransWarpPathLength}

procedure TransWarpMenu( var update : boolean );
{offer transwarp stuff, and update database if anything is changed}
var
  ch : char;
begin
  repeat
    writeln('Your choices: ');
    writeln('  <A>dd new fighter patrol to list');
    writeln('  <D>elete fighter patrol from list');
    writeln('  <L>ist all stored fighter patrols');
    writeln('  find transwarp <P>airs [SSB & SBS]');
    writeln('  <S>hortest path including transwarp to sector');
    writeln('  find <W>eak transwarp pairs [SSB & BBS]');
    writeln('  find <R>eally weak transwarp pairs [SBS & BSB]');
    writeln('  <Q>uit.  I goofed.');
    writeln;
    write('Menu choice? ');
    readln( ch );
    ch := upcase( ch );
  until ch in ['A', 'D', 'L', 'P', 'R', 'S', 'Q', 'W'];
  case ch of
    'A' : AddFighterCloud( update );
    'D' : DeleteFighterCloud( update );
    'L' : ListFighterClouds;
    'P' : PairSearch( 'SSB','SBS');
    'R' : PairSearch( 'SBS', 'BSB');
    'S' : TransWarpPathLength;
    'W' : PairSearch('SSB','BBS');
    'Q' : ;
  end; {case}
end; {TransWarpMenu}
