/* complex.c - collection of routines to do imaginair and polar
 * calculations.
 *
 * 18-Sep-1991
 * Peter Beyer -PA3AEF-
 * beyer@athena.uto.dec.com
 */
#ifndef _COMPLEXC_		   /* Make it safe to include this twice */
#define _COMPLEXC_

#ifndef __TURBOC__
struct complex {
    double x;                      /* Real part */
    double y;                      /* Imaginair part */
};
#endif

struct polair {
    double m;                      /* Magnitude */
    double a;                      /* Angle in degrees */
};

#include <math.h>
#define RTOD(x)  ((x) * 57.29578)  /* Radians to Degrees */
#define DTOR(x)  ((x) / 57.29578)  /* Degrees to Radians */

#ifdef _PROTO_
void cadd (struct complex *a, struct complex *b, struct complex *z);
void csub (struct complex *a, struct complex *b, struct complex *z);
void cmul (struct complex *a, struct complex *b, struct complex *z);
void cinv (struct complex *a, struct complex *z);
void cdiv (struct complex *a, struct complex *b, struct complex *z);
void csqrt (struct complex *a, struct complex *z);
void c2pol (struct complex *a, struct polair *z);
void pol2c (struct polair *a, struct complex *z);
void poladd (struct polair *a, struct polair *b, struct polair *z);
void polsub (struct polair *a, struct polair *b, struct polair *z);
void polmul (struct polair *a, struct polair *b, struct polair *z);
void polinv (struct polair *a, struct polair *z);
void poldiv (struct polair *a, struct polair *b, struct polair *z);
void polsqrt (struct polair *a, struct polair *z);
#endif _PROTO_

/* Complex add function.
 * Z = A + B
 */
void cadd(a, b, z)
struct complex *a, *b, *z;
{
    z->x = a->x + b->x;
    z->y = a->y + b->y;
}

/* Complex substract function.
 * Z = A - B
 */
void csub(a, b, z)
struct complex *a, *b, *z;
{
    z->x = a->x - b->x;
    z->y = a->y - b->y;
}

/* Complex multiply function. 
 * Z = A x B
 */
void cmul(a, b, z)
struct complex *a, *b, *z;
{
    z->x = a->x * b->x - a->y * b->y;
    z->y = a->x * b->y + a->y * b->x;
}

/* Complex invert function
 * Z = 1 / A
 */
void cinv(a, z)
struct complex *a, *z;
{
    double p = a->x * a->x + a->y * a->y;
    
    z->x = a->x / p;
    z->y = (-1 * (a->y) ) / p;
    
}

/* Complex devide function
 * Z = A / B
 */
void cdiv(a, b, z)
struct complex *a, *b, *z;
{
    struct complex p;
    cinv(b,&p);
    cmul(a,&p,z);
}

/* Complex SQRT function
 * Z = SQRT(A)
 */
void csqrt(a, z)
struct complex *a, *z;
{
    double p;

    if ((a->x == 0) && (a->y == 0)) {
        z = a;
    } else {
        p = sqrt((fabs(a->x) + cabs(*a)) / 2);
        if ((a->x < 0 ) && (a->y < 0 ))
            p = p * -1;
        if (a->x < 0) {
            z->y = p;
            z->x = (a->x) / (2 * p);
        } else {
            z->x = p;
            z->y = (a->y) / (2 * p);
        }

    }

}

/* Convert rectangle coordiantes to polar
 * coordinates. (Real, Imaginair to Magnitude, Angle)
 * (Angle returns in degrees)
 * Z = A;
 */
void c2pol(a, z)
struct complex *a;
struct polair *z;
{
    z->m = sqrt(a->x * a->x + a->y * a->y);
    z->a = atan(a->y / a->x);
    if ((a->x < 0) && (a->y < 0))
    	z->a -= M_PI;
    if ((a->x < 0) && (a->y > 0))
	z->a += M_PI;
    z->a = RTOD(z->a);
}

/* Convert polar coordiantes to rectangle coordiantes.
 * (Magnitude, Angle to Real, Imaginair)
 * Angle must be degrees
 * Z = A
 */
void pol2c(a, z)
struct polair *a;
struct complex *z;
{
    z->x = a->m * cos(DTOR(a->a));
    z->y = a->m * sin(DTOR(a->a));
}

/* Polair Add function
 * Z = A + B
 */
void poladd(a, b, z)
struct polair *a, *b, *z;
{
struct complex p, q, r;
    pol2c(a, &p);
    pol2c(b, &q);
    cadd(&p, &q, &r);
    c2pol(&r, z);
}

/* Polair Substract function
 * Z = A - B
 */
void polsub(a, b, z)
struct polair *a, *b, *z;
{
struct complex p, q, r;
    pol2c(a, &p);
    pol2c(b, &q);
    csub(&p, &q, &r);
    c2pol(&r, z);
}

/* Polair Multiply
 * Z = A * B
 */
void polmul(a, b, z)
struct polair *a, *b, *z;
{
    z->m = a->m * b->m;
    z->a = DTOR(a->a) + DTOR(b->a);
    z->a = RTOD(z->a);
}

/* Polair Devide function
 * Z = A / B
 */
void poldiv(a, b, z)
struct polair *a, *b, *z;
{
    z->m = a->m / b->m;
    z->a = DTOR(a->a) - DTOR(b->a);
    z->a = RTOD(z->a);
}

/* Polair Invert function
 * Z = 1 / A
 */
void polinv(a, z)
struct polair *a, *z;
{
    z->m = 1 / a->m;
    z->a = -1 * DTOR(a->a);
    z->a = RTOD(z->a);
}

/* Polair SQRT function
 * Z = SQRT(A)
 */
void polsqrt(a, z)
struct polair *a, *z;
{
    z->m = sqrt(a->m);
    z->a = DTOR(a->a) / 2;
    z->a = RTOD(z->a);
}

#endif /* _COMPLEXC_ */
