/**
***
***  This file is part of the source to the Pobble BBS, Ningi Mail
***  processor, Multiuser Labyrinth, and other sundry programs by
***  Josh Parsons. It is hereby released into the public domain.
***
**/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include "config.h"

char CFG_comment[]=";%#\n";	// Characters that might introduce a comment.
char CFG_flag[]		="/-";		// Characters that might introduce a flag.
char CFG_space[]  =" \t";   // Characters that count as whitespace
int CFG_lines=0;
const char *CFG_fname;

//static char buf[CFG_maxline];
static char *(argv[CFG_maxargs]);
static int argc;
static char *(flgv[CFG_maxargs]);
static int flgc;

int CFG_error(const char *fmt,...) {
   va_list arg_ptr;

	printf("Error in %s, line %d: ",CFG_fname,CFG_lines);
   va_start(arg_ptr, fmt);
   vprintf(fmt, arg_ptr);
   va_end(arg_ptr);
	printf("\n");
	return CFGERR_syntax;
	};

static int near pascal parseline(char *s,CFG_func_t argfunc) {
	int retval=0,isflg;
	char *t;
	flgc=argc=0;
	while(-1) {
		while(*s!=0&&isspace(*s)) s++;
		if(*s==0) break;
		if(strchr(CFG_flag,*s)) isflg=1;
		else isflg=0;
    t=strchr(s,'"');
		if(*s=='"') {
			t=strchr(s+1,'"');
			if(t==NULL) retval=CFG_error("Unterminated quote.");
			s++;
			}
//    else if(isflg&&t&&t<strchr(s+1,' ')&&t[-1]==':') {
    else if(isflg&&t&&t<s+1+strcspn(s+1,CFG_space)&&t[-1]==':') {
    	memmove(t,t+1,strlen(t));
      t=strchr(s+1,'"');
			if(t==NULL) retval=CFG_error("Unterminated quote.");
    	}
		else {
/*			t=strchr(s+1,' ');
			if(t==NULL) t=s+strlen(s);*/
      t=s+1+strcspn(s+1,CFG_space);
			};
		*(t++)=0;
		if(!isflg) {
			if(argc>=CFG_maxargs) retval=CFG_error("Too many arguments.");
			else argv[argc++]=s;
			}
		else {
			if(flgc>=CFG_maxargs) retval=CFG_error("Too many flags.");
			else flgv[flgc++]=s;
			}
		s=t;
		};
	if(retval==0&&argc>0) retval=argfunc(argc,argv,flgc,flgv);
	return retval;
	};

static void near pascal stripcomments(char *s) {
//	s[strcspn(s,CFG_comment)]=0;
	int in_quote=0;
	while(*s!=0) {
		if(*s=='"') in_quote=!in_quote;
		if(!in_quote&&strchr(CFG_comment,*s)) {
			*s=0;
			break;
			};
		s++;
		};
	};

int CFG_parse(const char *fname,CFG_func_t argfunc) {
	FILE *fin;
  char buf[CFG_maxline];
	int retval=0;
	CFG_lines=0;
	CFG_fname=fname;
	fin=fopen(fname,"r");
	if(fin==NULL) return CFGERR_file;
  setvbuf(fin,NULL,_IOLBF,8192);
	while(!feof(fin)) {
		char *s=buf;
		CFG_lines++;
    if((*s=getc(fin))==0x1a||feof(fin))
      break;
    else ungetc(*s,fin);
		fgets(buf,CFG_maxline,fin);
		if(strchr(buf,'\n')==NULL&&!feof(fin)) {
			retval=CFG_error("Line too long.");
			buf[CFG_maxline-1]=0;
			while(!feof(fin)&&getc(fin)!='\n'); // read up to the next line.
			};
		while(*s!=0&&isspace(*s)) s++;	// Strip leading spaces
		stripcomments(s);
		s[strlen(s)+1]=0;								// End buffer with double-null
		retval|=parseline(s,argfunc);
		};
	fclose(fin);
	return retval;
	};

