/************************************************************************/
/** Sqed/32 Installations Batch                                        **/
/**                                                                    **/
/** Aufruf  :       INSTALL <Sprache>                                  **/
/**                                                                    **/
/** Der Installationsbatch verabeitet einen Parameter als Krzel fr   **/
/** die zu installierende Sprache.                                     **/
/**                                                                    **/
/** Momentan werden folgende Krzel verarbeitet:                       **/
/**                                                                    **/
/**      D -   deutsch                                                 **/
/**      E -   english                                                 **/
/**                                                                    **/
/** Hinweis :  Dieser Installations Batch setzt die Installation der   **/
/**            'OS/2 Procedures Language 2/REXX' vorraus.              **/
/************************************************************************/

'@Echo Off'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

rc = SYSGetEA("Install.cmd","CHKEA","EAResult")
if EAResult <> "Sqed/32" then do
   say "-----------------------------------------------------------"
   say "WARNING! The Sqed/32 seems to be repacked by an EA unaware"
   say "archiver. There is no warranty that the other files in this"
   say "archive are untouched and complete."
   say "-----------------------------------------------------------"
   Call YNPrompt 'Continue? ', '1'
end


/* Initialize */
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Parse Arg Language .          /* Parameters */

Space_Req = 750000            /* Required disk space for installation */
Sqed_Ver  = 'v0.90'           /* Version number of Sqed/32            */

/* Deutsche Meldungen  */
D_START = 'Sqed/32 '||Sqed_Ver||' wird nun installiert...'
D_INST1  = '   Sqed/32 Nachrichten Editor - Hinweise zur Installation  :   '
D_INST4  = ' Dieser Batch installiert alle von Sqed/32 bentigten Dateien in ein eigenes'
D_INST5  = ' Verzeichnis auf Ihrer Festplatte.'
D_INST6  = ' Sie werden whrend der Installation nach dem Quell- und Zielverzeichnis'
D_INST7  = ' gefragt. Geben Sie bitte die Verzeichnisse als volle Pfadangaben mit'
D_INST8  = ' Laufwerks- und Pfadangabe an (z.B.: D:\SQED). Nachdem Sie die bentigten'
D_INST9  = ' Angaben gemacht haben, wird die getroffene Auswahl angezeigt. Sollten Sie'
D_INST10 = ' falsche Angaben gemacht haben, knnen Sie die Installation abbrechen.'
D_INST11 = ' Fhren Sie danach einfach den Batch erneut aus und korigieren Sie Ihre'
D_INST12 = ' Eingabe.'
D_INST14 = ' Install.Cmd versteht als Parameter so gut wie garnichts. Einzig die Sprache'
D_INST15 = ' kann durch Buchstaben angegeben werden. Um z.B. Sqed/32 mit deutschen Dialogen'
D_INST16 = ' zu installieren, knnten Sie die Installation von der Befehlszeile so starten:'
D_INST18 = '                             INSTALL.CMD D'
D_INST20 = ' Mgliche Wahl:  D - Deutsch   E - Englisch   I - Italienisch'
D_INST21 = '                 S - Spanisch  W - schWedisch'
D_CONT   = ' Weiter ?'
D_YN     = ' (J oder N)'
D_SRCDIR = 'Quell-Verzeichniss (Vorgabe: 'directory()'):'
D_TRGDIR = 'Ziel-Verzeichnis (Vorgabe: 'FileSpec("drive",directory())||'\SQED) :'
D_READY1  = '      Sqed/32 '||Sqed_Ver||' - ein 32bit multithreaded Nachrichten Editor      '
D_READY2  = ' Bisher wurden folgende Angaben gemacht:'
D_LANG    = ' Sprache:                deutsch'
D_ASKOK   = ' Installieren?'
D_COPY    = 'Sqed/32:  Kopiere nun die Dateien auf Ihre Festplatte.'
D_ERRDLL  = 'FEHLER: DEUTSCH.DLL nicht gefunden!'
D_OBJMSG1 = ' Fr Sqed/32 kann ein Programm Objekt auf der Arbeitsober-    '
D_OBJMSG2 = ' flche oder in Ihrem Systemstart-Ordner angelegt werden.     '
D_OBJASK  = 'Soll ein Programm Objekt angelegt werden ?'
D_OBJLOC  = 'Zielort des Programm Objekts: (D)esktop  (S)ystemstart-Ordner :'
D_OBJTIT  = 'Sqed/32^Nachrichten Editor'
D_OBJMSG3 = 'Objekt wurde erfolgreich angelegt.'
D_OBJMSG4 = 'FEHLER: Objekt konnte nicht angelegt werden!'
D_ALLOK   = 'Die deutsche Version von Sqed/32 wurde erfolgreich installiert.'
D_ERRFR1  = 'Es ist nicht gengend freier Platz auf Ihrer Festplatte!'
D_ERRFR2  = 'Es werden ca. '||Space_Req||' Bytes freier Speicherplatz bentigt.'
D_ERRFR3  = 'Whlen Sie entweder eine Partition mit ausreichendem Platz, oder lschen'
D_ERRFR4  = 'sie nicht mehr bentigte Programme und starten den Install Batch erneut.'

/* English message strings */
E_START = 'Sqed/32 '||Sqed_Ver||' is now being installed...'
E_INST1  = '   Sqed/32 Message Editor - about the installation routine:    '
E_INST4  = ' This program will install all necessary files for Sqed/32 in a user'
E_INST5  = ' selectable directory on your harddisk.'
E_INST6  = ' Prior to the installation you will be asked for the source and target'
E_INST7  = ' directory. Please provide a full specified path including drive and'
E_INST8  = ' directory designator (i.e. D:\SQED). After you provided all necessary'
E_INST9  = ' information, the install program will display a summary. At this point'
E_INST10 = ' you can cancel the installation, if you do not like what you see.'
E_INST11 = ' After that you can call the install routine again and provide the'
E_INST12 = ' correct information.'
E_INST14 = ''
E_INST15 = ''
E_INST16 = ''
E_INST18 = ''
E_INST20 = ''
E_INST21 = ''
E_CONT   = ' Continue ?'
E_YN     = ' (Y or N)'
E_SRCDIR = 'Source directory (default: 'directory()'):'
E_TRGDIR = 'Target directory (default: 'FileSpec("drive",directory())||'\SQED) :'
E_READY1  = '      Sqed/32 '||Sqed_Ver||' - A 32bit Multithreaded Message Editor            '
E_READY2  = ' The following settings have been provided:'
E_LANG    = ' language                english'
E_ASKOK   = ' Install?'
E_COPY    = 'Sqed/32:  Copying to disk.'
E_ERRDLL  = 'ERROR: ENGLISH.DLL not found!'
E_OBJMSG1 = ' A program object for Sqed/32 can be created on the desktop   '
E_OBJMSG2 = ' or in the startup folder.                                    '
E_OBJASK  = 'Shall we create a program object for Sqed/32?'
E_OBJLOC  = 'Target for program object: (D)esktop  (S)tartup folder :'
E_OBJTIT  = 'Sqed/32^Message Editor'
E_OBJMSG3 = 'Object creation successful.'
E_OBJMSG4 = 'ERROR: Unable to create object!'
E_ALLOK   = 'The english version of Sqed/32 has been successfully installed.'.
E_ERRFR1  = 'There is not enough space on your hard disk!'
E_ERRFR2  = 'Installation requires about '||Space_Req||' bytes of free space.'
E_ERRFR3  = 'Please select a different partition or delete files that are no longer'
E_ERRFR4  = 'needed and restart the install program.'

/* italian strings */
I_START  = 'Sqed/32 '||Sqed_Ver||'  in corso di installazione...'
I_INST1  = '   Sqed/32 Message Editor - informazioni sull"installazione:   '
I_INST4  = ' Questo programma installer tutti i file necessari a Sqed/32 in una'
I_INST5  = ' directory di vostra scelta.           '
I_INST6  = ' Prima dell"installazione vi saranno richieste le directory di partenza'
I_INST7  = ' e di arrivo. Per favore inserite la path completa compresa di disco'
I_INST8  = ' e directory (ad esempio: . D:\SQED). Dopo che avrete inserito tutte  '
I_INST9  = ' le informazioni necessari il programma visualizzer un sommario.      '
I_INST10 = " A questo punto potrete cancellare l'installazione se vorrete.    "
I_INST11 = ' Dopo di che potrete sempre rieseguire il programma per inserire  '
I_INST12 = ' le informazioni corrette.'
I_INST14 = ''
I_INST15 = ''
I_INST16 = ''
I_INST18 = ''
I_INST20 = ''
I_INST21 = ''
I_CONT   = ' Continuo ?'
I_YN     = ' (Y or N)'
I_SRCDIR = 'Source directory (default: 'directory()'):'
I_TRGDIR = 'Target directory (default: 'FileSpec("drive",directory())||'\SQED) :'
I_READY1  = '      Sqed/32 '||Sqed_Ver||' - A 32bit Multithreaded Message Editor            '
I_READY2  = ' Le seguenti preferenze sono state scelte: '
I_LANG    = ' linguaggio             italiano'
I_ASKOK   = ' Installo?'
I_COPY    = 'Sqed/32:  Copio sul disco.'
I_ERRDLL  = 'ERRORE: ITALIAN.DLL non trovata!'
I_OBJMSG1 = ' Un icona programma per Sqed/32 pu essere creata sul desktop '
I_OBJMSG2 = ' o nel cartella di startup.                                   '
I_OBJASK  = 'Devo creare un icona programma per Sqed/32 ? '
I_OBJLOC  = "Dove creo l'icona programma:(D)esktop (S)tartup folder :"
I_OBJTIT  = 'Sqed/32^Message Editor'
I_OBJMSG3 = 'Icona creata con successo. '
I_OBJMSG4 = 'ERRORE: Non posso creare l"icona'
I_ALLOK   = 'La versione italiana di Squed/32  stata installata correttamente.'
I_ERRFR1  = 'Non c" spazio sufficiente sul tuo disco.'
I_ERRFR2  = 'L"installazione richiede circa '||Space_Req||' bytes di spazio libero.'
I_ERRFR3  = 'Per favore scegli una disco differente o cancella dei files che non'
I_ERRFR4  = 'sono necessari e riesegui il programma di installazione.'

/* spanish strings */
S_START = 'Sqed/32 '||Sqed_Ver||' est siendo instalado...'
S_INST1  = '   Sqed/32 Editor de Mensajes - rutina de instalacin:         '
S_INST4  = ' Este programa va a instalar todos los ficheros necesarios para'
S_INST5  = ' Sqed/32 en un directorio de su disco duro.'
S_INST6  = ' Antes de la instalacin se le preguntar por los directorios de'
S_INST7  = ' origen y destino. Por favor, especifique el path completo incluyendo'
S_INST8  = ' el disco (p.ej. D:\SQED). Despus de que usted haya dado toda la'
S_INST9  = ' informacin necesaria, el programa de instalacin mostrar un sumario.'
S_INST10 = ' En ese momento, puede usted cancelar la instalacin si no le gusta lo'
S_INST11 = ' que ve. Ms tarde, puede ejecutar la rutina de instalacin de nuevo'
S_INST12 = ' y dar la informacin correcta.'
S_INST14 = ' Install.Cmd slo requiere un parmetro. El nico parmetro a dar es el'
S_INST15 = ' carcter que representa el lenguaje a instalar. Este es un ejemplo de'
S_INST16 = ' cmo instalar la versin espaola de Sqed/32:'
S_INST18 = '                             INSTALL.CMD S'
S_INST20 = ' Opciones posibles:  D - alemn   E - ingls   I - italiano'
S_INST21 = '                     S - espaol  W - sueco'
S_CONT   = ' Continuar?'
S_YN     = ' (Y or N)'
S_SRCDIR = 'Directorio de origen (Por defecto: 'directory()'):'
S_TRGDIR = 'Directorio de destino (Por defecto: 'FileSpec("drive",directory())||'\SQED) :'
S_READY1  = '      Sqed/32 '||Sqed_Ver||' - Un Editor de Mensajes multithread de 32 bits    '
S_READY2  = ' Se ha seleccionado la siguiente configuracin:'
S_LANG    = ' lenguaje                   espaol'
S_ASKOK   = ' Instalar?'
S_COPY    = 'Sqed/32:  Copiando a disco.'
S_ERRDLL  = 'ERROR: no encuentro SPANISH.DLL!'
S_OBJMSG1 = ' Si lo desea, se puede crear un objeto de programa para Sqed  '
S_OBJMSG2 = ' en el desktop o en la carpeta de inicio (Startup folder).    '
S_OBJASK  = 'Crear objeto de programa para Sqed/32?'
S_OBJLOC  = 'Destino para el objeto de programa: (D)esktop  (S)tartup folder :'
S_OBJTIT  = 'Sqed/32^Editor de Mensajes'
S_OBJMSG3 = 'Objeto creado con xito.'
S_OBJMSG4 = 'ERROR: No se pudo crear objeto!'
S_ALLOK   = 'La versin espaola de Sqed/32 ha sido instalada con xito'.
S_ERRFR1  = 'No hay suficiente espacio en su disco duro!'
S_ERRFR2  = 'La instalacin requiere unos '||Space_Req||' bytes de espacio libre.'
S_ERRFR3  = 'Seleccione otra particin o borre algunos ficheros que no sean'
S_ERRFR4  = 'necesarios y reinicie el programa de instalacin.'

/* swedish strings */
W_START = 'Sqed/32 '||Sqed_Ver||' installeras...'
W_INST1  = '   Sqed/32 Message Editor - om installationen:                 '
W_INST4  = ' Detta program kommer att installera alla ndvndiga filer fr Sqed/32 i ett av'
W_INST5  = ' dig valt bibliotek p din hrddisk.'
W_INST6  = ' Innan installationen kommer du att tillfrgas om frn resp till vilket'
W_INST7  = ' bibliotek installationen skall ske i. V.v ge full skvg inklusive enhet'
W_INST8  = ' (drive) och biblioteksnamn (ex. D:\SQED). Efter det att alla ndvndiga '
W_INST9  = ' indata fr installationen uppgivits kommer installationsprogrammet att visa'
W_INST10 = ' en sammanfattning av installationsdata. Vid denna tidpunkt kan, om s nskas,'
W_INST11 = ' installationen avbrytas. Drefter kan man nyo starta installationsprogrammet'
W_INST12 = ' och mata in ndrade uppgifter.'
W_INST14 = ''
W_INST15 = ''
W_INST16 = ''
W_INST18 = ''
W_INST20 = ''
W_INST21 = ''
W_CONT   = ' Fortstta ?'
W_YN     = ' ([J]aeller [N]ej)'
W_SRCDIR = 'Installera frn bibliotek (default: 'directory()'):'
W_TRGDIR = 'Till bibliotek (default: 'FileSpec("drive",directory())||'\SQED) :'
W_READY1  = '      Sqed/32 '||Sqed_Ver||' - <en 32bit Multithreaded Message Editor            '
W_READY2  = ' Fljande instllningar fresls:'
W_LANG    = ' sprk                svenska'
W_ASKOK   = ' Installera?'
W_COPY    = 'Sqed/32:  Kopierar till disk.'
W_ERRDLL  = 'ERROR: SWEDEN.DLL hittades ej!'
W_OBJMSG1 = ' Ett programobjekt fr Sqed/32 kan skapas p Skrivbordet      '
W_OBJMSG2 = ' eller i Start-up-foldern.                                    '
W_OBJASK  = 'Skapa Programobjektet SQED/32?'
W_OBJLOC  = 'Skapas i:  Skrivbor(d)et  (S)tartup foldern :'
W_OBJTIT  = 'Sqed/32^Message Editor'
W_OBJMSG3 = 'Programobjekt skapat.... '
W_OBJMSG4 = 'ERROR: Programobjekt kan ej skapas!'
W_ALLOK   = 'Den svenska versionen av Sqed/32 r nu installerad.'.
W_ERRFR1  = 'Det finns inte tillrcklig plats p hrddisken!'
W_ERRFR2  = 'Installationen behver omkring '||Space_Req||' byte fritt utrymme.'
W_ERRFR3  = 'Vlj en annan partition eller radera andra filer som inte lngre '
W_ERRFR4  = 'behvs och starta om installationsprogrammet.'

Call SysCls
if Language = " " then do
  Language = GetLanguage()
  Call InstallNote
end

/* Source */

  Say
  Call GetInput value(Language||'_SRCDIR')
  Pull SourcePath

  If SourcePath = " " Then Do
     SourcePath = directory()
  end

/* Target */
    if first = 0 then call InstallNote
    Say

    Call GetInput value(Language||'_TRGDIR')
    Parse Pull TargetPath

    If TargetPath = " " Then Do
       TargetPath=FileSpec("drive",directory())||'\SQED'
    End

/* Correct SourcePath and TargetPath if necessary */
FStr = Right(SourcePath,1)

If FStr == "\" Then
Do
   FPos = Length(SourcePath)
   SourcePath = DelStr(SourcePath, FPos)
End

FStr = Right(TargetPath,1)

If FStr == "\" Then
Do
   FPos = Length(TargetPath)
   TargetPath = DelStr(TargetPath, FPos)
End

/* deutsche Strings */
D_ASKDIR = 'Das Verzeichnis: <'TargetPath'> existiert noch nicht auf Ihrer Festplatte.'
D_ASKDIR1 = 'Soll das Verzeichnis: <'TargetPath'> angelegt werden?'
D_INFDIR  = 'Lege Verzeichnis: <'TargetPath'> an...'
D_ERRDIR  = 'Konnte Verzeichnis <'TargetPath'> nicht anlegen.'
D_ERRLW   = 'Auf das Ziel-Laufwerk: 'FileSpec("drive",TargetPath)' kann nicht geschrieben werden!'
D_ERRLW1  = 'Beim Testen des Ziellaufwerks: 'filespec("drive", Targetpath)'ist ein Fehler aufgetreten'
D_ERRLW2  = 'Mglicherweise ist das Laufwerk nicht bereit, es handelt sich um CD-ROM oder...'
D_SRCINF  = ' Quell-Verzeichnis:      <'SourcePath'>'
D_TRGINF  = ' Ziel-Verzeichnis:       <'TargetPath'>'

/* english strings */
E_ASKDIR = 'The directory <'TargetPath'> does not yet exist.'
E_ASKDIR1 = 'Shall we create the directory <'TargetPath'> ?'
E_INFDIR  = 'Creating directory <'TargetPath'> ...'
E_ERRDIR  = 'Unable to create directory <'TargetPath'>.'
E_ERRLW   = 'You do not have write permission on drive: ['filespec("drive", Targetpath)'] '
E_ERRLW1  = ''
E_ERRLW2  = ''
E_SRCINF  = ' Source directory:      <'SourcePath'>'
E_TRGINF  = ' Target directory:      <'TargetPath'>'

/* italian Strings */
I_ASKDIR  = 'La directory <'TargetPath'> non esiste.'
I_ASKDIR1 = 'Devo creare la directory <'TargetPath'> ?'
I_INFDIR  = 'Creo la directory <'TargetPath'> ...'
I_ERRDIR  = 'Non posso creare la directory <'TargetPath'>.'
I_ERRLW   = 'Non hai accesso in scrittura al disco: ['filespec("drive", Targetpath)'] '
I_ERRLW1  = ''
I_ERRLW2  = ''
I_SRCINF  = ' Directory sorgente:    <'SourcePath'>'
I_TRGINF  = ' Directory di arrivo:   <'TargetPath'>'

/* spanish strings */
S_ASKDIR  = 'El directorio <'TargetPath'> no existe.'
S_ASKDIR1 = 'Crear directorio <'TargetPath'> ?'
S_INFDIR  = 'Creando directorio <'TargetPath'> ...'
S_ERRDIR  = 'No se pudo crear directorio <'TargetPath'>.'
S_ERRLW   = 'No hay acceso a escritura en el disco: ['filespec("drive", Targetpath)'] '
S_ERRLW1  = 'Ocurri un error al verificar el disco de destino: 'filespec("drive", Targetpath)
S_ERRLW2  = 'El disco puede estar desconectado, daado....'
S_SRCINF  = ' Directorio de origen:      <'SourcePath'>'
S_TRGINF  = ' Directorio de destino:     <'TargetPath'>'

/* swedish strings */
W_ASKDIR  = 'Biblioteket <'TargetPath'> finns ej.'
W_ASKDIR1 = 'Skapa bibliotek <'TargetPath'> ?'
W_INFDIR  = 'Skapar bibliotek <'TargetPath'> ...'
W_ERRDIR  = 'Kan ej skapa bibliotek <'TargetPath'>.'
W_ERRLW  = 'Du kan ej skriva till enhet (drive): ['filespec("drive", Targetpath)'] '
W_ERRLW1 = ''
W_ERRLW2 = ''
W_SRCINF  = ' Frn bibliotek:      <'SourcePath'>'
W_TRGINF  = ' Till bibliotek:      <'TargetPath'>'


/* Target Drive Writeonly ?*/
call checkdrive
/* Check drive free space */
Drv_Info = SysDriveInfo(FileSpec("drive",TargetPath))
Free = X2C(C2X(word(drv_info, 2)))

if Space_Req > Free then do
 Call SysCls
 say
 say value(Language||'_ERRFR1')
 say
 say value(Language||'_ERRFR2')
 say value(Language||'_ERRFR3')
 say value(Language||'_ERRFR4')
 exit
end

Call SysFileTree TargetPath, FileStem, 'D'

/* Directory doesn't exist */
If FileStem.0 = '0' Then Do
  Say
  Say value(Language||'_ASKDIR')
  Say
  Call YNPrompt value(Language||'_ASKDIR1'), '1'
  Say
  Say value(Language||'_INFDIR')
  retc = SysMkDir(TargetPath)
  if retc \= 0 Then Do
    Say value(Language||'_ERRDIR')
    exit
  End
End

/* ready ? */
Call SysCls
Say '    ͻ'
Say '    '||value(Language||'_READY1')
Say '    ͼ'
Say
Say '    '||value(Language||'_READY2')
Say
Say '    'value(Language||'_SRCINF')
Say '    'value(Language||'_TRGINF')
Say '    'value(Language||'_LANG')
Say
Say
Call YNPrompt value(Language||'_ASKOK'), '1'

Call SysCls
Say value(Language||'_START')

Call CopyFile 'Sqed.exe',     SourcePath, TargetPath

If Language = 'd' then Do
  Result = SysFileTree( SourcePath||'\DEUTSCH.DLL', 'Files', 'F' )
  If Files.0 = 0 Then Do
    Say value(Language||'ERRDLL')
    Exit
  End

  Command = '@Copy 'SourcePath||'\DEUTSCH.DLL' TargetPath||'\Sqed.dll'
  Command
  Call CopyFile 'Sqed32.txt',   SourcePath, TargetPath
  Call CopyFile 'History.txt', SourcePath, TargetPath
End

If Language = 'e' then do
  Result = SysFileTree( SourcePath||'\ENGLISH.DLL', 'Files', 'F' )
  If Files.0 = 0 Then Do
    Say value(Language||'_ERRDLL')
    Exit
  End

  Command = '@Copy 'SourcePath||'\ENGLISH.DLL' TargetPath||'\Sqed.dll'
  Command

  Call CopyFile 'Sqed32uk.txt', SourcePath, TargetPath
  Call CopyFile 'History.eng', SourcePath, TargetPath
End

If Language = 's' then do
  Result = SysFileTree( SourcePath||'\SPANISH.DLL', 'Files', 'F' )
  If Files.0 = 0 Then Do
    Say value(Language||'_ERRDLL')
    Exit
  End

  Command = '@Copy 'SourcePath||'\SPANISH.DLL' TargetPath||'\Sqed.dll'
  Command

  Call CopyFile 'Sqed32uk.txt', SourcePath, TargetPath
  Call CopyFile 'History.eng', SourcePath, TargetPath
End

If Language = 'i' then do
  Result = SysFileTree( SourcePath||'\ITALIAN.DLL', 'Files', 'F' )
  If Files.0 = 0 Then Do
    Say value(Language||'_ERRDLL')
    Exit
  End

  Command = '@Copy 'SourcePath||'\ITALIAN.DLL' TargetPath||'\Sqed.dll'
  Command

  Call CopyFile 'SQED32UK.TXT', SourcePath, TargetPath
  Call CopyFile 'HISTORY.ENG', SourcePath, TargetPath
End

If Language = 'w' then do
  Result = SysFileTree( SourcePath||'\SWEDEN.DLL', 'Files', 'F' )
  If Files.0 = 0 Then Do
    Say value(Language||'_ERRDLL')
    Exit
  End

  Command = '@Copy 'SourcePath||'\SWEDEN.DLL' TargetPath||'\Sqed.dll'
  Command

  Call CopyFile 'SQED32UK.TXT', SourcePath, TargetPath
  Call CopyFile 'HISTORY.ENG', SourcePath, TargetPath
End

/* Create program object on desktop, Startup-Folder or none? */
Call SysCls
Say
Say '        ͻ'
Say '                                                                      '
Say '        'value(Language||'_OBJMSG1')
Say '        'value(Language||'_OBJMSG2')
Say '                                                                      '
Say '        ͼ'
Say

Ret = YNPrompt(value(Language||'_OBJASK'), '0')
If Ret = 'Y' | Ret = 'y' | Ret = 'J' | Ret = 'j' Then Do
  /* Location */
  Say
  Call GetInput value(Language||'_OBJLOC')
  Parse Pull Location

  If Location = 'D' | Location = 'd' then
    Folder = '<WP_DESKTOP>'
  Else
  If Location = 'S' | Location = 's' then
    Folder = '<WP_START>'
  Else
    Folder = '<WP_DESKTOP>'
  Type = 'WPProgram'
  Title = value(Language||'_OBJTIT')
  Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='TargetPath'\SQED.EXE;OBJECTID=<SQED32>;'
  RT = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
  Say
  If RT = 1 Then Do
    Say value(Language||'_OBJMSG3')
  end
  Else
    Say value(Language||'_OBJMSG4')
end

Say
Say value(Language||'_ALLOK')

Signal DONE

/* Some Routines, Signal Handler */
/* Language */
GetLanguage:
  Say
  Call GetInput 'Language: (D)eutsch  (E)nglish  (I)talian  (S)panish  S(w)edish:'
  Do Forever
    Key = SysGetKey( 'NOECHO' )
    If Key = 'D' | Key = 'd' Then Do
      return Key
    End
    Else If Key = 'E' | Key = 'e' Then Do
      return Key
    End
    Else If Key = 'S' | Key = 's' Then Do
      return Key
    End
    Else If Key = 'I' | Key = 'i' Then Do
      return Key
    End
    Else If Key = 'W' | Key = 'w' Then Do
      return Key
    End
    Else
      Call Beep 240,200
  End
  Say
End

/* Copy File */
CopyFile: Arg ArgFile2Copy, ArgFloppyDir, ArgInstallDir

/* deutsche Strings */
D_ERRCOP = 'Warnung! 'ArgFile2Copy' konnte nicht kopiert werden. Fortfahren ?'
D_MSGCOP = 'Kopiere 'ArgFloppyDir||'\'||ArgFile2Copy' nach 'ArgInstallDir||'\'||ArgFile2Copy'.'

/* english strings */
E_ERRCOP = 'Warning: Cannot copy 'ArgFile2Copy'. Proceed ?'
E_MSGCOP = 'Copy 'ArgFloppyDir||'\'||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'.'

/* italian strings */
I_ERRCOP = 'Attenzione: non posso copiare 'ArgFile2Copy'. Continuo?'
I_MSGCOP = 'Copy 'ArgFloppyDir||'\'||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'.'

/* spanish strings */
S_ERRCOP = 'Aviso: No se puede copiar 'ArgFile2Copy'. Proceder?'
S_MSGCOP = 'Copiar 'ArgFloppyDir||'\'||ArgFile2Copy' a 'ArgInstallDir||'\'||ArgFile2Copy'.'

/* swedish strings */
W_ERRCOP = 'Varning: Kan ej kopiera 'ArgFile2Copy'. Fortstta ?'
W_MSGCOP = 'Kopierar 'ArgFloppyDir||'\'||ArgFile2Copy' till 'ArgInstallDir||'\'||ArgFile2Copy'.'

  Say
  Say value(Language||'_MSGCOP')
  Command = '@Copy 'ArgFloppyDir||'\'||ArgFile2Copy  ArgInstallDir||'\'||ArgFile2Copy
  Command
  if rc \= 0 Then Do
    Call YNPrompt value(Language||'_ERRCOP'), '1'
  End
  Return

/* Show Input prompt */
GetInput: Parse Arg ArgPrompt

  /* Cursor position */
  Parse Value SysCurPos() With Row .

  /* Screen Size */
  Parse Value SysTextScreenSize() With NumRows .

  /* End of Screen ? */
  if Row = NumRows - 1 Then Row = Row - 1

  /* Input */
  Col = Length( ArgPrompt ) + 1

  /* Show input */
  Say ArgPrompt
  Call SysCurPos Row, Col

  Return

/* Yes/No user prompt */

YNPrompt: Parse Arg ArgPrompt, ArgAbort

  Call GetInput ArgPrompt||value(Language||'_YN')

  Do Forever
    Key = SysGetKey( 'NOECHO' )
    If Key = 'J' | Key = 'j' | Key = 'Y' | Key = 'y' Then Do
      Say
      Return Key
    End
    Else If Key = 'N' | Key = 'n' Then Do
      Say
      If ArgAbort = '1' Then exit
      Return Key
    End
  End
  Return 'y'

/* Checks target drive */
CheckDrive:
  strname = FileSpec("drive",TargetPath)||"\DEL.ME"
  strtxt  = "result of a stupid drive check function, please delete"
  checkdrv = lineout(strname,strtxt)
  if checkdrv = 0 then do
    check = lineout(strname)
    chkfd = sysfiledelete(strname)
    return
  end
  else do
   Call SysCls
   say
   say value(Language||'_ERRLW1')
   say value(Language||'_ERRLW2')
   say
   exit
 end


/* Show help screen */

InstallNote:
  Call SysCls
  Say '        ͻ'
  Say '        '||value(Language||'_INST1')
  Say '        ͼ'
  Say
  Say value(Language||'_INST4')
  Say value(Language||'_INST5')
  Say value(Language||'_INST6')
  Say value(Language||'_INST7')
  Say value(Language||'_INST8')
  Say value(Language||'_INST9')
  Say value(Language||'_INST10')
  Say value(Language||'_INST11')
  Say value(Language||'_INST12')
  Say
  Say value(Language||'_INST14')
  Say value(Language||'_INST15')
  Say value(Language||'_INST16')
  Say
  Say value(Language||'_INST18')
  Say
  Say value(Language||'_INST20')
  Say value(Language||'_INST21')
  Say

  Call YNPrompt value(Language||'_CONT'), '1'
  Call SysCls

  Return

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
