/*---------------------------------------------------------------

  Program:    FIXPRT.CMD
  Op Sys:     OS/2 1.3 or later
  Runtime:    REXX/2
  Libraries:  none
  Author:     Brad Berson
  Date:       April 28, 1992
  History:    1.00  Original version.

-----------------------------------------------------------------

  FixProtocols  Copyright (C) 1992  Brad Berson  Psycho Psoftware
                  All Rights Reserved.  So There.

  You are entitled to freely distribute this file unmodified
  and accompanied by FIXPRT.DOC.  Technical support available via
  CIS:[71631,132], the Ilink OS/2 conference or USPS.

  This program corrects defective protocol code numbers in PMcomm
  dialing directory files caused by directory conversions using
  test versions of QMtoPM, the Qmodem->PMcomm .FON translator.
  See the accompanying FIXPRT.DOC for more info.

  Invocation:  FIXPRT [PMcomm.FON] [PMcomm.NEW]
  Switches:    none
  FixProtocols dialogue will request info for items not included.

-----------------------------------------------------------------

      name        c21   1
      number      c21   22    PMCOMM.FON file format:
      baud        c7    43    int 2 byte, long 4 byte (unsigned)
      parity      c5    50    null-terminated/padded strings
      datab       c2    55
      stopb       c2    57    timeson     int   84
      script      c13   59    filesdl     int   86
      protocol    int   72    filesul     int   88
      prefix      int   74    cpsul       int   90
      suffix      int   76    termtype    int   92
      laston      long  78    autosel     int   94
      cpsdl       int   82    fill        c27   96

---------------------------------------------------------------*/

cr='0d'x
lf='0a'x
nul='0'x
crlf=cr||lf
recsdone=0
recsfixd=0
pmreclen=122
infile='PMCOMM.FON'
outfile='PMCOMM.NEW'

SIGNAL ON HALT NAME ERRH
SIGNAL ON ERROR NAME ERRH
SIGNAL ON SYNTAX NAME ERRH
PARSE UPPER ARG inarg outarg

SAY ' '
SAY '* FixProtocols/REXX 1.00, Copyright 1992 Brad Berson'
SAY '* Use ONLY on PMcomm .FON files created by QMtoPM!!!'
SAY ' '

IF POS('?',inarg)>0 THEN DO
  SAY 'Invocation:  FIXPRT [PMcomm.FON] [PMcomm.NEW]'
  SAY 'Switches:    none'
  SAY 'FixProtocols dialogue will request info for items not included.'
  EXIT
END

IF inarg>'' THEN
  infile=inarg
ELSE DO
  CALL CHAROUT ,'PMcomm FON file specification <'||infile||'>: '
  pmans=LINEIN()
  IF pmans>'' THEN infile=pmans
END

IF outarg>'' THEN
  outfile=outarg
ELSE DO
  CALL CHAROUT ,'Output listfile specification <'||outfile||'>: '
  ofans=LINEIN()
  IF ofans>'' THEN outfile=ofans
END

IF RIGHT(infile,1)='\' THEN infile=infile||'PMCOMM'
IF RIGHT(outfile,1)='\' THEN outfile=outfile||'PMCOMM'
IF POS('.',infile,LENGTH(infile)-3)=0 THEN infile=infile||'.FON'
IF POS('.',outfile,LENGTH(outfile)-3)=0 THEN outfile=outfile||'.LST'

/* Open PMCOMM.FON and get size) */
pmstate=STREAM(infile,'c','open read')
IF pmstate<>'READY:' THEN DO
  SAY 'Failed to open 'infile'... 'pmstate
  EXIT
END
pmlength=STREAM(infile,'c','query size')
pmrecs=pmlength/pmreclen

/* Open PMCOMM.LST, scratch if exists */
ofstate=STREAM(outfile,'c','open write')
IF ofstate<>'READY:' THEN DO
  SAY 'Failed to open 'outfile'... 'ofstate
  EXIT
END
ofstate=STREAM(outfile,'c','seek =1')

SAY 'Creating 'outfile' from 'infile'...'

/* Get records and do translations */
DO recnum=1 TO pmrecs BY 1
  pmrecord=CHARIN(infile,,pmreclen)
  CALL CHAROUT ,cr||'Processing record '||recnum
  protocol=C2D(REVERSE(SUBSTR(pmrecord,72,2)),2)
  SELECT
    WHEN protocol=1 THEN fprotocol=234
    WHEN protocol=2 THEN fprotocol=233
    WHEN protocol=3 THEN fprotocol=228
    WHEN protocol=4 THEN fprotocol=232
    WHEN protocol=5 THEN fprotocol=230
    OTHERWISE fprotocol=protocol
  END
  IF protocol=fprotocol THEN
    CALL CHAROUT ,': no change    '
  ELSE DO
    CALL CHAROUT ,': '||protocol||' -> '||fprotocol||'   '
    recsfixd=recsfixd+1
  END
  ofrecord=OVERLAY(REVERSE(D2C(fprotocol,2)),pmrecord,72,2)
  ofstate=CHAROUT(outfile,ofrecord)
  recsdone=recsdone+1
  DO 1000 ; NOP /*look ma! 2fast!*/ ; END
END

/* Close files and do some begging */
pmstate=STREAM(infile,'c','close')
ofstate=STREAM(outfile,'c','close')
CALL CHAROUT ,cr'FIXPRT complete, 'recsdone' entries processed, '
CALL CHAROUT ,recsfixd' repaired.'crlf
SAY ' '
SAY 'Thank you for using QMtoPM!  I hope you have found'
SAY 'this software to be useful will consider registering.'
SAY ' '
SAY 'Brad Berson, ABC-TV, 47 W. 66th St., NY NY 10023'
EXIP:
EXIT

/* Error handler */
ERRH:
  SAY ' '
  IF RC='RC' THEN
    SAY 'REXX/2 ERROR in line 'sigl
  ELSE
    SAY 'REXX/2 ERROR 'rc' in line 'sigl': 'ERRORTEXT(rc)
  SAY SOURCELINE(sigl)
  SAY 'Condition: 'CONDITION('C')
  SAY 'PROGRAM ABENDED.'
  EXIT

