/*---------------------------------------------------------------

  Program:    QMTOPM.CMD
  Op Sys:     OS/2 1.3
  Runtime:    REXX/2
  Libraries:  none
  Author:     Brad Berson
  Date:       April 28, 1992
  History:    1.00  Original conversion from QuickBASIC!

-----------------------------------------------------------------

  QMtoPM  Copyright (C) 1992  Brad Berson  Psycho Psoftware
              All Rights Reserved.  So There.

  You are entitled to freely distribute this file unmodified
  and accompanied by QMTOPM.DOC.  Modified versions may not
  be distributed without written permission from author.
  Evaluation is free.  If you use the output of QMtoPM and
  are satisfied that it has performed the best it could
  within the limitations enforced by Qmodem and PMcomm, you
  should consider sending a Shareware donation amount of $10
  (or more!) to:  Brad Berson, #2 Chaparral Road, Chestnut
  Ridge, New York 10977.

  Technical support available via CIS:[71631,132] or USPS.

  This program converts dialing directory files (*.FON)
  from Forbin Project / Mustang's Qmodem 4.3 to Multi-Net's
  PMcomm version 1.09/1.10.  Eases migration from DOS to
  OS/2.  See accompanying QMTOPM.DOC for more info.

  Invocation:  QMTOPM [Qmodem.FON] [PMcomm.FON] [switches]
  Switches:    [Y|N][T|B][A|O] in any order, no spaces.
  QMtoPM Dialogue will request info for items not included.

-----------------------------------------------------------------

         Qmodem          File formats          PMcomm

      name        c28   1                name        c21   1
      fill        c2    29               number      c21   22
      number      c20   31               baud        c7    43
      fill        c2    51               parity      c5    50
      datab       int   53               datab       c2    55
      stopb       int   55               stopb       c2    57
      parity      c1    57               script      c13   59
      script      c13   58               protocol    int   72
      laston      uint  71               prefix      int   74
      timeson     long  80               suffix      int   76
      fill        c2    84               laston      long  78
      protocol    c1    86               cpsdl       int   82
      echo        c1    87               timeson     int   84
      password    c15   88               filesdl     int   86
      entrynum    int   103              filesul     int   88
      marked      c1    105              cpsul       int   90
      emulation   c1    106              termtype    int   92
      learntag    c1    107              autosel     int   94
      notenum     int   108              fill        c27   96
      hasnote     c1    110
      noprefix    c1    111    String field formats:
      baud        long  112    Qmodem: len byte + nul-padded str
      fill        c3    116    PMcomm: null-terminated string

---------------------------------------------------------------*/

bl='07'x
cr='0d'x
lf='0a'x
nul='0'x
crlf=cr||lf
pmrecnum=0
recsdone=0
qmreclen=118
pmreclen=122
maxlines=1000
totitems=maxlines
infile='QMODEM.FON'
outfile='PMCOMM.FON'
lstfile='PMCOMM.PWD'
SIGNAL ON HALT NAME ERRH
SIGNAL ON ERROR NAME ERRH
SIGNAL ON SYNTAX NAME ERRH
PARSE UPPER ARG qmarg pmarg switches

SAY ' '
SAY '* QMtoPM/REXX 1.00, Copyright 1992 Brad Berson'
SAY '* The Qmodem to PMcomm .FON file converter'
SAY ' '

IF POS('?',qmarg)>0 THEN DO
  SAY 'Invocation:  QMTOPM [Qmodem.FON] [PMcomm.FON] [switches]'
  SAY 'Switches:    [Y|N][T|B][A|O] in any order, no spaces.'
  SAY 'QMtoPM Dialogue will request info for items not included.'
  SIGNAL EXIP
END

IF qmarg>'' THEN
  infile=qmarg
ELSE DO
  CALL CHAROUT ,'Qmodem FON file specification <'||infile||'>: '
  qmans=LINEIN()
  IF qmans>'' THEN infile=qmans
END

IF pmarg>'' THEN
  outfile=pmarg
ELSE DO
  CALL CHAROUT ,'PMcomm FON file specification <'||outfile||'>: '
  pmans=LINEIN()
  IF pmans>'' THEN outfile=pmans
END

IF POS('Y',switches)=0 & POS('N',switches)=0 THEN DO
  DO FOREVER
    CALL CHAROUT ,'Create a password list PMCOMM.PWD from QMODEM.FON? <Y/N> '
    pwans=TRANSLATE(LINEIN())
    IF pwans='Y' | pwans='N' THEN DO
      LEAVE
    END
  END
END

IF POS('T',switches)=0 & POS('B',switches)=0 THEN DO
  DO FOREVER
    CALL CHAROUT ,'<T>ranslate script names to *.CMD or leave them <B>lank? '
    xlans=TRANSLATE(LINEIN())
    IF xlans='T' | xlans='B' THEN DO
      LEAVE
    END
  END
END

IF POS('A',switches)=0 & POS('O',switches)=0 THEN DO
  DO FOREVER
    CALL CHAROUT ,'<A>ppend new records to PMCOMM.FON or <O>ver-write file? '
    aoans=TRANSLATE(LINEIN())
    IF aoans='A' | aoans='O' THEN DO
      LEAVE
    END
  END
END

IF switches>'' THEN DO
  IF POS('Y',switches)>0 THEN pwans='Y'
  IF POS('N',switches)>0 THEN pwans='N'
  IF POS('T',switches)>0 THEN xlans='T'
  IF POS('B',switches)>0 THEN xlans='B'
  IF POS('A',switches)>0 THEN aoans='A'
  IF POS('O',switches)>0 THEN aoans='O'
END

IF RIGHT(infile,1)='\' THEN infile=infile||'QMODEM'
IF RIGHT(outfile,1)='\' THEN outfile=outfile||'PMCOMM'
IF POS('.',infile,LENGTH(infile)-3)=0 THEN infile=infile||'.FON'
IF POS('.',outfile,LENGTH(outfile)-3)=0 THEN outfile=outfile||'.FON'

SAY 'Creating 'outfile' from 'infile'...'

qmstub=LEFT(infile,LASTPOS('.',infile)-1)
pmstub=LEFT(outfile,LASTPOS('.',outfile)-1)

qmstate=STREAM(infile,'c','open read')
IF qmstate<>'READY:' THEN DO
  SAY 'Failed to open 'infile'... 'qmstate
  EXIT
END
qmlength=STREAM(infile,'c','query size')
qmrecs=qmlength/qmreclen

pmstate=STREAM(outfile,'c','open write')
IF pmstate<>'READY:' THEN DO
  SAY 'Failed to open 'outfile'... 'pmstate
  EXIT
END
pmlength=STREAM(outfile,'c','query size')
IF pmlength > 0 THEN pmrecnum=pmlength/pmreclen-1
IF aoans='O' THEN DO
  pmstate=STREAM(outfile,'c','seek =1')
  pmrecnum=0 ; END
ELSE DO
  pmstate=STREAM(outfile,'c','seek <'pmreclen)
END

IF pwans='Y' THEN DO
  lstfile=pmstub||'.PWD'
  lfstate=STREAM(lstfile,'c','open write')
  IF lfstate<>'READY:' THEN DO
    SAY 'Failed to open 'lstfile'... 'lfstate
    EXIT
  END
END

DO recnum=1 TO qmrecs BY 1
  qmrecord=CHARIN(infile,,qmreclen)
  IF LEFT(qmrecord,1) > nul THEN DO  /* skip empty entries */
    CALL CHAROUT ,cr||'Processing record '||recnum
    CALL BRQM
    pmcpsdl=D2C(0,2)  /* nulls into non-xlatable fields */
    pmcpsul=D2C(0,2)
    pmfilesdl=D2C(0,2)
    pmfilesul=D2C(0,2)
    pmautosel=D2C(0,2)
    pmprefix=REVERSE(D2C(1,2))
    pmsuffix=REVERSE(D2C(1,2))
    pmname=R2CS(qmname,21)
    pmnumber=R2CS(qmnumber,21)
    pmdatab=R2CS(qmdatab,2)
    pmstopb=R2CS(qmstopb,2)
    pmbaud=R2CS(qmbaud,7)
    pmtimeson=REVERSE(D2C(qmtimeson,2))
    pmtermtype=REVERSE(D2C(174,2))  /* ANSI */
    pmfill=COPIES(nul,27)
    SELECT
      WHEN qmparity='N' THEN pmparity=R2CS('None',5)
      WHEN qmparity='E' THEN pmparity=R2CS('Even',5)
      WHEN qmparity='O' THEN pmparity=R2CS('Odd',5)
      WHEN qmparity='M' THEN pmparity=R2CS('Mark',5)
      WHEN qmparity='S' THEN pmparity=R2CS('Spac',5)
      OTHERWISE pmparity=R2CS('None',5)
    END
    SELECT
      WHEN qmprotocol='X' THEN pmprotocol=REVERSE(D2C(234,2))
      WHEN qmprotocol='R' THEN pmprotocol=REVERSE(D2C(234,2))
      WHEN qmprotocol='C' THEN pmprotocol=REVERSE(D2C(233,2))
      WHEN qmprotocol='O' THEN pmprotocol=REVERSE(D2C(228,2))
      WHEN qmprotocol='Y' THEN pmprotocol=REVERSE(D2C(232,2))
      WHEN qmprotocol='G' THEN pmprotocol=REVERSE(D2C(230,2))
      WHEN qmprotocol='B' THEN pmprotocol=REVERSE(D2C(150,2))
      WHEN qmprotocol='K' THEN pmprotocol=REVERSE(D2C(222,2))
      WHEN qmprotocol='Z' THEN pmprotocol=REVERSE(D2C(231,2))
      WHEN qmprotocol='A' THEN pmprotocol=REVERSE(D2C(711,2))
      OTHERWISE pmprotocol=REVERSE(D2C(234,2))  /* Xmodem if ? */
    END
    IF POS('.',qmscript)>0 & xlans='T' THEN DO
      dotpos=POS('.',qmscript)
      pmscript=R2CS(LEFT(qmscript,dotpos)||'CMD',13) ; END
    ELSE DO
      pmscript=COPIES(nul,13)
    END
    IF qmlaston<29200 | qmlaston=65535 THEN
      pmlaston=REVERSE(D2C(0,4))
    ELSE DO
      laston=qmlaston-25566
      tmplaston=FORMAT(laston*86400,9)
      pmlaston=REVERSE(D2C(tmplaston,4))
    END
    CALL PUPM
    IF pwans='Y' THEN CALL PRLI
    pmrecnum=pmrecnum+1
    recsdone=recsdone+1
  END
END
pmrecord=COPIES(nul,pmreclen)  /* end with blank record */
pmstate=CHAROUT(outfile,pmrecord)

qmstate=STREAM(infile,'c','close')
pmstate=STREAM(outfile,'c','close')
IF pwans='Y' THEN DO
  lfrecord=COPIES('=',75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord='EOF'crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord=COPIES('=',75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfstate=STREAM(lstfile,'c','close')
END

CALL CHAROUT ,cr||qmrecs' entries processed; '
CALL CHAROUT ,recsdone' entries converted.'crlf
SAY 'PMcomm directory now has 'pmrecnum' entries.'
SAY ' '
SAY 'If this program saved you hours of tedium while'
SAY "making the switch to OS/2, consider the author's"
SAY 'time and effort and pay for this quality Shareware.'
SAY ' '
SAY 'Brad Berson, ABC-TV, 47 W. 66th St., NY NY 10023'
EXIP:
EXIT

/* Subroutine to break Qmodem records into fields */
BRQM:
  qmname=TP2R(SUBSTR(qmrecord,1,28))
  qmnumber=TP2R(SUBSTR(qmrecord,31,20))
  qmdatab=C2D(REVERSE(SUBSTR(qmrecord,53,2)),2)
  qmstopb=C2D(REVERSE(SUBSTR(qmrecord,55,2)),2)
  qmparity=SUBSTR(qmrecord,57,1)
  qmscript=TP2R(SUBSTR(qmrecord,58,13))
  qmlaston=C2D(REVERSE(SUBSTR(qmrecord,71,2)))
  qmtimeson=C2D(REVERSE(SUBSTR(qmrecord,80,4)),4)
  qmprotocol=SUBSTR(qmrecord,86,1)
  qmpword=TP2R(SUBSTR(qmrecord,88,15))
  qmnotenum=C2D(REVERSE(SUBSTR(qmrecord,108,2)),2)
  qmbaud=C2D(REVERSE(SUBSTR(qmrecord,112,4)),4)
  RETURN

/* Subroutine to write PMcomm records from fields */
PUPM:
  pmrecord=pmname||pmnumber||pmbaud||pmparity||pmdatab||pmstopb||,
           pmscript||pmprotocol||pmprefix||pmsuffix||pmlaston||,
           pmcpsdl||pmtimeson||pmfilesdl||pmfilesul||pmcpsul||,
           pmtermtype||pmautosel||pmfill
  pmstate=CHAROUT(outfile,pmrecord)
  RETURN

/* Subroutine to print entries to LST file */
PRLI:
  notefile=STREAM(qmstub||'.'||qmnotenum,'c','query exists')
  IF qmpword>' ' | notefile>' ' THEN DO
    IF totitems=maxlines THEN DO
      CALL LFHD
      totitems=0
    END
    totitems=totitems+1
    lfrecord=pmname||COPIES('.',20-LENGTH(qmpword))||qmpword
    IF notefile>' ' THEN DO
      lfrecord=lfrecord||COPIES(' ',45-LENGTH(lfrecord))||notefile
    END
    lfstate=CHAROUT(lstfile,lfrecord||crlf)
  END
  RETURN

/* Subroutine to print password file heading */
LFHD:
  header='Passwords & notefiles for '||outfile||,
  ': QMtoPM/REXX (C) 1992 Brad Berson'
  lfrecord=COPIES('=',75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord=CENTER(header,75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord=COPIES('-',75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord='  Entry name               '||,
           'Password          '||,
           'Notefile name'||,
           crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  lfrecord=COPIES('=',75)||crlf
  lfstate=CHAROUT(lstfile,lfrecord)
  RETURN

/* Function to convert TPASCAL string to raw string */
TP2R: PROCEDURE
  string=arg(1)
  lenbyte=C2D(SUBSTR(string,1,1))
  IF lenbyte > 0 THEN
    string=STRIP(SUBSTR(string,2,lenbyte))
  ELSE
    string=''
  RETURN string

/* Function to convert raw string to C string */
R2CS: PROCEDURE
  string=arg(1)
  strlen=arg(2)
  string=LEFT(string,strlen-1)
  string=SUBSTR(string,1,strlen,'0'x)
  RETURN string

/* Function to convert TPASCAL string to C string */
TP2C: PROCEDURE
  string=arg(1)
  strlen=arg(2)
  string=R2CS(TP2R(string),strlen)
  RETURN string

/* Error handler */
ERRH:
  SAY ' '
  IF RC='RC' THEN
    SAY 'REXX/2 ERROR in line 'sigl
  ELSE
    SAY 'REXX/2 ERROR 'rc' in line 'sigl': 'ERRORTEXT(rc)
  SAY SOURCELINE(sigl)
  SAY 'Condition: 'CONDITION('C')
  SAY 'PROGRAM ABENDED.'
  EXIT

