/********************************************
 * ptyopen.c : open pty for IRIX 
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ********************************************/

#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

int PtyOpen(ptyFd,ttyName)
int *ptyFd;
char **ttyName;
{
  void (*func)();

  /* The default handling for SIGCHLD
   * cannot be allowed while in _getpty()
   * since it might fork() and wait() which
   * would in effect cause the program to
   * hang.
   */
   
  func = signal(SIGCHLD,SIG_DFL);

  *ttyName = (char *) _getpty(ptyFd,O_RDWR | O_NDELAY,0622,0);

  signal(SIGCHLD,func);

  if (*ttyName == NULL)
    return(-1);
  return(0);
}


