/*****************************************************
 * channel.c : 'high level' channel control for pcucp
 *
 * Copyright (C) 1992 J.Lepp{j{rvi
 *****************************************************/

#include "system.h"
#include "usrmsg.h"
#include "mux.h"
#include "control.h"
#include "packetio.h"
#include "channel.h"

int ChanOpen(type)
char *type;
{
    int ch;

    ch = MuxOpen(type);
    if (ch >= 0)
    {
        if (!CtrlSendCmd("OPEN %d %s",ch,type));
            return(ch);
    }
    return(-1);
}

void ChanClose(ch)
int ch;
{
    MuxClose(ch);
    CtrlSendCmd("CLOSE %d",ch);
}

void ChanPriorize(ch)
int ch;
{
    if (MuxPriorize(ch) != ch)
        CtrlSendCmd("PRIORIZE %d",ch);
}

