// serweb.cpp
// Written by Gus Estrella (estrella@cass.ma02.bull.com)
// 
//

#include "stdafx.h"
#include "serweb.h"

#include "mainfrm.h"
#include "serwedoc.h"
#include "serwevw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSerwebApp

BEGIN_MESSAGE_MAP(CSerwebApp, CWinApp)
	//{{AFX_MSG_MAP(CSerwebApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSerwebApp construction

CSerwebApp::CSerwebApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSerwebApp object

CSerwebApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CSerwebApp initialization

BOOL CSerwebApp::InitInstance()
{
	WSADATA wsaData;         // Winsock
    int error;              // Winsock
                                   
       
    // Initialize WINSOCK below ....
    
    HowManyClients = GetProfileInt("SERWEB","HowManyClients", 5);                                

    error = WSAStartup(WS_VERSION_REQD, &wsaData);
	if (error != 0)
	  {                               
  	    MessageBox(NULL,"WinSocket could not be initialized.  Please check", AfxGetAppName(), MB_OK);
	    WSACleanup();
	    return FALSE;
	  }                                                               
	
	if (( LOBYTE (wsaData.wVersion) < WS_VERSION_MAJOR) ||
	    ( LOBYTE (wsaData.wVersion) == WS_VERSION_MAJOR &&
	      HIBYTE (wsaData.wVersion) < WS_VERSION_MINOR) )
	  {
	    sprintf(buf, "Windows Sockets version %d.%d not supported by winsock.dll", LOBYTE(wsaData.wVersion), HIBYTE(wsaData.wVersion));
	    MessageBox(NULL, buf,  AfxGetAppName(), MB_OK);   
	    WSACleanup();
	    return FALSE;   
	  }
    
    if (wsaData.iMaxSockets < (HowManyClients + 1))
      {
        sprintf(buf, "This application requires a minimun of %d supported sockets.  Close other network applications and restart or change the .INI file entry for Number of Clients.", MIN_SOCKETS_REQD);
	    MessageBox(NULL, buf,  AfxGetAppName(), MB_OK);
	    WSACleanup();
	    return FALSE;   
	  }
           
    // Continue with the window initialization now ......
       
    	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	AddDocTemplate(new CSingleDocTemplate(IDR_MAINFRAME,
			RUNTIME_CLASS(CSerwebDoc),
			RUNTIME_CLASS(CMainFrame),     // main SDI frame window
			RUNTIME_CLASS(CSerwebView)));


	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CSerwebApp::ExitInstance()      
{
    int error;              // Winsock
                 
   error = WSACleanup();                      // Winsock code
	if (error != 0)
	  {                               
	    sprintf(buf, "Windows Sockets error %d.", error);
	    MessageBox(NULL, buf,  AfxGetAppName(), MB_OK);   
      }
   
   if (m_pMainWnd != NULL)       
      VERIFY(m_pMainWnd->DestroyWindow());

   return CWinApp::ExitInstance();
}             
      
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CSerwebApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CSerwebApp commands
