// serwevw.h : interface of the CSerwebView class
//
/////////////////////////////////////////////////////////////////////////////
#define COLUMN_MAX 80        // How many columns to allow for the screen

// WWW variables below..  We will read from a file but for now they are gard coded.


// WWW variables that will remain.. Don't replace ...

#define MAX_CLIENTS     10    // Maximun number of connections to allow
#define SEND_BUFFER    300    // How many characters to send at a time ..
// State of the sockets below ....
#define SOCK_FREE        4    // The socket is not being used .
#define WAITING          5    // Waiting for the socket to send information
#define SENDING          6    // Sending data to the other server 
#define SOCK_FULL        7    // All sockets aree in use.  Send can msg.

#define CLIENT_MSG    WM_USER+1     // The clients is crying ..
#define INCOMING_MSG  WM_USER+2     // The master has closed, or a connections has comed ..


#define MAX_IN_BUF   100      // how many chars to receive from client .....
#define SEND_BUF_LEN 200      // How many chars to send at a time ....

struct WWWSockDef {
    short    State;             // Status of the Socket
    SOCKET   CliSock;
    CString  InBuf;
    CFile    SendFile;
    char     SendBuf[SEND_BUF_LEN];
    int      HowManyInSendBuf;  
    int      OffsetToSend; 
    CTime    LastTime; 
    char     CliIp[30];          // IP Of client.
}; 
    

// Misc stuff ..........
#define TIME_TO_CHECK     (360*60)       // Milliseconds to check for inactive connections
#define IdEv               20           // ID Event for Timer.

#define INACTIVE          2  // No response in over 3 minutes should be killed.

    
//////////////////////////////////////////////////////////////////////
class CSerwebView : public CScrollView
{
protected: // create from serialization only
	CSerwebView();
	DECLARE_DYNCREATE(CSerwebView)
    
    WWWSockDef WWWConv[MAX_CLIENTS+1];    // All conversations going on ....
    SOCKET     WWWServer;               // The popetier - controls all connections
    SOCKET     cli_sock;
    
    struct sockaddr_in srv_addr, cli_addr;
    LPSERVENT srv_info;
    LPHOSTENT host_info;

    char buf[200];                      // All purpose buffer.  Usually for error messages.
    
    int WWWPort;             // Port to listen on
    int HowManyClients;      // similar to app one, but for ease of use, lets redefine it and re get it....

    CString SendDir;             // From where do we send data ?                
    CString FileNotExistMsg;     // File to send if we can't file a file being requested. 
    CString ClosedServerMsg;     // File to send if server is closed.
    CString PeriodAllowedMsg;    // File to sedn if user send for a file with ..
    
// Attributes
public:
	CSerwebDoc* GetDocument();


// Operations
public:
	void OnInitialUpdate();
	virtual void OnUpdate(CView* pSender, LPARAM lHint = 0L, CObject* pHint = NULL);
	virtual void PrintSt(CString StToPrint);      
	virtual void PrintSt(char* AString);      
	virtual void PrintChar(char nChar, char OutputIt = 'n');          // Print just one char ....
	virtual void ProcessRequest(int SockNumber);      
	virtual void ProcessRead(int SockNumber);      
	virtual void SendBlockOfData(int SockNumber);      
	virtual CString GetFirstString(CString TheString, int WrdToGet);      
    virtual void KillConn(int SockNumber);

// Implementation
public:
	virtual ~CSerwebView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// Generated message map functions
protected:
	//{{AFX_MSG(CSerwebView)
	afx_msg LRESULT OnWWWClientMsg(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWWWServerMsg(WPARAM wParam, LPARAM lParam);
	afx_msg void OnPeriodOk();
	afx_msg void OnServerInact();
	afx_msg void OnUpdateStat();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG	// debug version in serwevw.cpp
inline CSerwebDoc* CSerwebView::GetDocument()
   { return (CSerwebDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
