/*
  MODULE: WS_PAINT.C  (main window (debug) display routines)
*/

#include "ws_glob.h"
#include "winftp.h"

#include <stdarg.h>

int nLineHeight=5;
int nScreenRows=10;

#define  MAX_SIZE   100
#define  MAX_MSG    100

LPSTR lpDebugMsg=NULL;
LPSTR lpMem[MAX_MSG+1];

#define LPDBG(x) (lpDebugMsg+(x*MAX_SIZE))

extern HWND hWndDbg;

//*************************************************************************
//*************************************************************************
int GetLocalInfo()
{
  int nRc;
  struct hostent FAR *hostptr;
  struct in_addr FAR *iptr;

  DoPrintf("Using %s",(LPSTR)WSAData.szDescription);
  if (lstrlen (WSAData.szSystemStatus)>0)
      DoPrintf("System Status: %s", (LPSTR)WSAData.szSystemStatus);
  if ((nRc=gethostname ((LPSTR) szString, MAXHOSTNAMELEN))==SOCKET_ERROR)
    ReportWSError("GetHostName",WSAGetLastError());
  else
    DoPrintf("Local Host: %s",szString);

  if(!nRc)
  {
    if((hostptr=gethostbyname(szString))==NULL) 
    {
      ReportWSError("gethostbyname",WSAGetLastError());
    } 
    else 
    {
      while ( (iptr = (struct in_addr *) *(hostptr->h_addr_list)) != NULL) 
      {
        DoPrintf("Local Address: %s", inet_ntoa (*iptr));
        hostptr->h_addr_list++;
      }
    }
  }
  DoAddLine("WinFTP written by Santanu Lahiri");
  return(TRUE);
}

//*************************************************************************
//*************************************************************************
void ReleaseDisplayMem()
{
//  int nIndex;
//  for (nIndex=0; nIndex<ptrhGMem; nIndex++)  GlobalFree (hGMem[nIndex]);
  
  if (lpDebugMsg!=NULL) GlobalFreePtr (lpDebugMsg);
  ptrhGMem=0;
}

//*************************************************************************
//*************************************************************************
void AddLineToLog (LPSTR lpStr)
{
  FILE *fp;
  
  if ((fp=fopen (szLogFile, "at"))!=NULL)
  {
    fprintf (fp, "%s\n", lpStr);
    fclose (fp);
  }
}

//*************************************************************************
//*************************************************************************
void DoAddLine (LPSTR szString)
{
  int nLen;
  RECT rect;

  if (lstrlen (szString)==0) return;
  if (!(bVerbose) && szString[0]=='[') return;

  if (nLogFlag==MF_CHECKED) AddLineToLog (szString);
  if (szString[0]!='[') SetStatus (hWndMain, (LPSTR) szString);
  // added in some error checking to try to eliminate GPFs
  if (szString) 
  {
    if (lpDebugMsg==NULL)
    {
      int nI;
      
      lpDebugMsg = GlobalAllocPtr (GHND, (MAX_MSG+1)*MAX_SIZE);
      for (nI=0; nI<MAX_MSG; nI++) lpMem[nI] = LPDBG(nI);
    }
    nLen = lstrlen(szString);
    if (nLen>0) 
    {
      if (ptrhGMem<(MAX_MSG-1)) ptrhGMem++;
      else 
      {
        LPSTR lp = lpMem[0];
        memmove (lpMem, lpMem+1, MAX_MSG*sizeof (LPSTR));
        lpMem[MAX_MSG-1] = lp;
      }
      strncpy (lpMem[ptrhGMem], szString, MAX_SIZE-1);
    }
  }
  GetClientRect(hWndDbg,&rect);
  rect.top=min(0,(ptrhGMem-sVPos-1))*nLineHeight;

  if((UINT) ptrhGMem > (UINT) (sVPos+nScreenRows))
    PostMessage(hWndDbg,WM_VSCROLL,SB_LINEDOWN,0L);
  else
    InvalidateRect(hWndDbg,&rect,TRUE);

  UpdateWindow(hWndDbg);
}

//*************************************************************************
//*************************************************************************
void DoPrintf(char *szFormat,...)
{
   va_list vaArgs;
   static char szBuf[256];

   va_start(vaArgs,szFormat);
   if (vsprintf (szBuf,szFormat,vaArgs)!=EOF) DoAddLine (szBuf);
   va_end(vaArgs);
}

//*************************************************************************
//*************************************************************************
void DoPaint(HWND hWnd)
{
  HDC         hDC;   // handle for the display device
  PAINTSTRUCT ps;    // holds PAINT information
  UINT        nI;

  RECT rRect;
  TEXTMETRIC tm;

  memset(&ps, 0x00, sizeof(PAINTSTRUCT));
  hDC = BeginPaint(hWnd, &ps);
  // Included as the background is not a pure color
  SetBkMode(hDC, TRANSPARENT);
  GetTextMetrics(hDC,&tm);
  nLineHeight=tm.tmHeight+tm.tmExternalLeading;
  GetClientRect(hWnd,&rRect);
  nScreenRows = rRect.bottom/nLineHeight;
  ShowScrollBar (hWnd, SB_VERT, (nScreenRows<ptrhGMem));
  for (nI=0; (nI+sVPos) < (UINT) ptrhGMem; nI++) 
  {
    TextOut (hDC, 20, nI*nLineHeight, lpMem[nI+sVPos], lstrlen (lpMem[nI+sVPos]));
  }
  // Inform Windows painting is complete
  EndPaint(hWnd, &ps);
}


