program delete_duplicate_4dos_command_history_entries;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/09/08.  First public release.  DDA
v1.01  : 1993/10/12.  Fixed bug: would not properly process files in
                            directories other than the current one.  DDA

------------------------------------------------------------------------------}

uses dos , crt ;
type
    link = ^node;
    node = record
             cmd  : string ;
             next : link ;
           end;
var
   inbufr,
   inlist,
   ccmd      : string ;

   anchor,
   chain,
   temp,
   cnode     : link ;

   before,
   after     : text ;

   workpath,
   infile,
   outfile,
   tmpfile   : string ;

   i_case,
   twirl     : boolean ;
   histnumb  : word ;
   histsize,
   fdt       : longint ;

procedure showhelp ( errornum : byte );
const
    progdata = '4HIST- Free 4DOS utility: command history duplicate entry deleter.';
    progdat2 = 'V1.01: October 12, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
    usage = 'Usage: 4HIST file [/i (ignore case)]';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'you must specify -exactly- one filespec.';
      2 : message := 'cannot find ' + paramstr (1) + '!';
      3 : message := 'unable to open ' + paramstr (1) + '!';
      4 : message := 'file is empty, cannot continue.';
      5 : message := 'undefined error, may not have worked properly.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

function converttoupper(w : string) : string;
var
   cp  : integer;        {the position of the character to change.}
begin
     for cp := 1 to length(w) do
         w[cp] := upcase(w[cp]);
     converttoupper := w;
end;

procedure openfiles(var sfile, dfile : text; name1, name2, wp : string);
var
     dirinfo : searchrec ;
     inname  : string [64] ;
     insize  : longint ;

begin       { open the file to process, and another for output }
     findfirst ( (wp+name1), archive, dirinfo );
     if doserror <> 0 then
        showhelp (2);

     inname := wp+dirinfo.name ;
     insize := dirinfo.size ;

     assign ( sfile, inname );     { we know names of both, }
{$i-} reset ( sfile ); {$i+}     { but if source does not exist, }
     if ( ioresult <> 0 ) then  { show help                     }
         showhelp(3);

     if insize = 0 then
         showhelp(4);

     assign ( dfile,wp+name2 );     { create output file regardless }
     rewrite ( dfile );
end;

procedure getpath ( var wpath, inf : string );
var ps1 : string ;
begin
     wpath := '';
     ps1 := inf;
     while (( pos ( '\',ps1 )) <> 0 ) do begin
        wpath := copy ( ps1,1,( pos ( '\',ps1 )));
        delete ( ps1,1,( pos ( '\',ps1 )));
     end;

     if (wpath = '') then begin
        ps1 := inf;
        while (( pos ( ':',ps1 )) <> 0 ) do begin
           wpath := copy ( ps1,1,( pos ( ':',ps1 )));
           delete ( ps1,1,( pos ( ':',ps1 )));
        end;
     end;

     inf := copy ( inf, ( length (wpath)+1 ), ( length ( ps1 )) );
end;

procedure woops;
begin
  if ( exitcode <> 0) then showhelp (5);
  halt (0);
end;


begin
     exitproc := @woops;
     outfile := 'dda_4h-!.out';
     tmpfile := 'dda_4h-!.tmp';
     if paramcount >= 1 then
        infile := paramstr (1)
     else showhelp (1) ;

     getpath ( workpath, infile );

     i_case := false ;
     if ( paramcount = 2 ) then
        if (( converttoupper ( paramstr (2) )) = '/I' )  then
           i_case := true ;

     openfiles ( before, after, infile, outfile, workpath );

     new ( anchor );
     anchor^.cmd  := '';
     anchor^.next := nil ;
     chain := anchor ;

     twirl := true ;
     histsize := 0 ;
     histnumb := 0 ;

     while not eof ( before ) do begin
           readln ( before, ccmd );

           twirl := not twirl ;
           if twirl then write ('\')
                   else write ('/');
           gotoxy ( wherex - 1, wherey );

           histsize := histsize + length ( ccmd ) ;
           histnumb := histnumb + 1 ;

           new ( cnode );
           cnode^.cmd  := ccmd ;
           cnode^.next := nil  ;
           chain := anchor ;

           inbufr := cnode^.cmd ;
           if i_case then inbufr := converttoupper ( inbufr );

           while ( chain^.next <> nil )  do begin

                 inlist := chain^.next^.cmd ;
                 if i_case then inlist := converttoupper ( inlist );

                 if ( inbufr = inlist ) then
                 begin
                      temp := chain^.next ;
                      chain^.next := chain^.next^.next ;
                      dispose ( temp );
                 end
                 else
                    chain := chain^.next ;
           end;

           inlist := chain^.cmd ;
           if i_case then inlist := converttoupper ( inlist );

           if ( inbufr <> inlist ) then
           begin
              chain^.next := cnode ;
              chain := cnode ;
           end;
     end;

     histsize := histsize + histnumb ;
     write ( 'History was: ', histsize, ' bytes (',
              histnumb, ' commands), and is now: ' );
     histsize := 0 ;
     histnumb := 0 ;
     repeat
           temp := anchor ;
           anchor := anchor^.next;
           dispose ( temp );
           writeln ( after, anchor^.cmd ) ;
           histsize := histsize + length ( anchor^.cmd ) ;
           histnumb := histnumb + 1 ;
     until anchor^.next = nil ;
     dispose ( anchor );

     histsize := histsize + histnumb ;
     writeln ( histsize, ' bytes (', histnumb, ' commands).' );

     close ( after );
     reset ( after );
     getftime ( before, fdt );
     setftime ( after, fdt );
     close ( before );
     close ( after );
     rename ( before, workpath+tmpfile );
     rename ( after, workpath+infile );
     erase  ( before );
end.
