PROGRAM AddColumnOfNumbersInFile;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.01  : 1993/12/20.  Now handles lines up to 255 chars (not just 80).  DDA
                      Added showhelp procedure, ad only shows on error.  DDA

------------------------------------------------------------------------------}

CONST
     ProgData = 'ADDCOL- Free DOS utility: adds a column of numbers in a text file.';
     ProgDat2 = 'V1.01: December 20, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
     Usage    = 'Usage: ADDCOL <file> [<column # start in> <column width>]';

VAR
   NumbFile     : Text;

   CSumStr      : String[40];
   CSum         : Real;

   StartLoc,
   NumbLen      : Byte;
   NumbersAdded : Word;


procedure showhelp(problem:byte); {if any *foreseen* errors arise, we are sent}
var                          { here to give a little help and exit peacefully }
   message : string[80];
begin
   writeln(progdata);                  { just tell user what this program   }
   writeln(progdat2);                  { is and who wrote it                }
   writeln;
   writeln(usage);
   writeln;
   writeln('Error encountered:');
   case problem of
     255 : message := '';
   else
        message := 'Unknown error.';
   end;
   writeln(message);
   halt(problem);
end;

PROCEDURE InitGVars;
VAR ValERR     : Integer;
BEGIN
     Assign(NumbFile,ParamStr(1));
{$I-} Reset(NumbFile); {$I+}
     IF ((IOResult <> 0) OR (ParamCount = 0)) THEN
          showhelp (1);
     IF (ParamCount = 3) THEN
     BEGIN
          Val(ParamStr(2),StartLoc,ValERR);
          Val(ParamStr(3),NumbLen,ValERR);
     END
     ELSE BEGIN
          StartLoc := 1;
          NumbLen := 50;
     END;
     CSum := 0.0;
     NumbersAdded := 0;
END;

PROCEDURE AddTheNumbs;
VAR
   CNumbStr     : String;
   CNumb        : Real;
   ValERR       : Integer;
   MaxLen       : Integer;
BEGIN
     MaxLen := StartLoc + NumbLen;
REPEAT
     ReadLn(NumbFile,CNumbStr);
     IF (Length(CNumbStr) <> 0) THEN
     BEGIN
          Delete(CNumbStr,MaxLen,255);
          WHILE (CNumbStr[Length(CNumbStr)] = ' ') DO
             Delete(CNumbStr,Length(CNumbStr),1);
          CNumbStr := Copy(CNumbStr,StartLoc,NumbLen);
          Val(CNumbStr,CNumb,ValERR);
          IF (ValERR = 0) THEN
          BEGIN
             CSum := CSum + CNumb;
             Inc(NumbersAdded);
          END;
     END;
UNTIL Eof (NumbFile);
     Close(NumbFile);
END;

FUNCTION NormalizeRealStr ( AbNormal : String ) : String;
VAR LastChar : String[1];
BEGIN
     LastChar := Copy(AbNormal,Length(AbNormal),1);
     WHILE LastChar = '0' DO
     BEGIN
          Delete(AbNormal,Length(AbNormal),1);
          LastChar := Copy(AbNormal,Length(AbNormal),1);
     END;
     IF   Pos('.',AbNormal) = Length(AbNormal) THEN
          Delete(AbNormal,Length(AbNormal),1);
     NormalizeRealStr := AbNormal;
END;

BEGIN
     InitGVars;
     AddTheNumbs;
     Str(CSum:0:8, CSumStr);
     WriteLn('The ',NumbersAdded,' numbers from "',ParamStr(1),'" total ',NormalizeRealStr(CSumStr));
END.
