/****************************************************************************/
/*                THE FOLLOWING PROGRAM IS THE SOLE PROPERTY OF             */
/*                               RONALD Q. SMITH                            */
/*             CONTAINING HIS PROPRIETARY CONFIDENTIAL INFORMATION          */
/*                 COPYRIGHT (c) RONALD Q. SMITH 1992, 1993                 */
/****************************************************************************/

/* Version of this software.                                                */

#define version "3.52"

/* Global data types.                                                       */

/* "modes" holds flags that control the operation of CLOCK.SYS              */

struct modes {
    unsigned : 9;
    unsigned day_light: 1;
    unsigned disp_24 : 1;
    unsigned disp_tim : 1;
    unsigned pw_ena : 1;
    unsigned disabl : 1;
    unsigned chk_forw : 1;
    unsigned chk_back : 1;
};

/* "off" holds a time offset in hours, minutes, and seconds.                */

struct off {
    int hour;
    int minute;
    int second;
};

/* "date_time" is a structure that holds a date and time.                   */

struct date_time {
    unsigned int year;
    unsigned int month;
    unsigned int day;
    struct off time;
    int hsecond;
};

/* "time_zone" holds a time zone name and offset.                           */

struct time_zone {
    struct off offs;
    unsigned char zone[32];
};

/* "limit" is used to hold the data that sets time limits for changes.      */

struct limit {
    struct off back;
    struct off forward;
};
/* "disp" is used to hold the data that specifies the location and attributes
    of the continuous time display.                                         */

struct disp {
    int x;
    int y;
    int attribute;
};

/* CLOCK_DATA is the CLOCK.SYS data that is returned by clksta (AKA CLKSTA
   for FORTRAN, Pascal, and BASIC languages).  Because we need to be language
   independent, all of the data is word-aligned.  Only the data types int and
   character are used.  Some of the int data is encoded bits or addresses.  */

struct CLOCK_DATA {
    int connected;                      /* Connection state             */
    struct modes mode;                  /* Mode bits                    */
    struct date_time cal_time;          /* Current date and time        */
    struct time_zone standard;          /* Offset of standard UTC       */
    struct time_zone daylight;          /* Daylight offset              */
    struct limit rules;                 /* Maximum clock movement       */
    struct disp display;                /* Time display loc and attr    */
    unsigned char vers[6];              /* CLOCK.SYS version nnn.nn     */
    int clock_type;                     /* Type of clock installed      */
    int ct_1;                           /* Data for clock type          */
    int ct_2;
    int ct_3;
    int ct_4;
    unsigned int clock_seg;             /* Segment CLOCK.SYS loaded at  */
    unsigned int clock_long;            /* Size of CLOCK.SYS            */
};

/* Function prototypes                                                      */

extern int pascal far connec(int *connect);
extern int pascal far stzone(int *std_hour, int *std_minute, int *std_second,
    unsigned char std_name[32], int *day_hour, int *day_minute,
    int *day_second, unsigned char day_name[32]);
extern int pascal far stmode(struct modes *mode);
extern int pascal far rstrct(int *back_hour, int *back_minute,
    int *back_second,int *forward_hour, int *forward_minute,
    int *forward_second);
extern int pascal far tdisp(int *disp_x, int *disp_y, int *attribute);
extern void pascal far setpw(unsigned char *pword);
extern int pascal far newpw(unsigned char *pword);
extern int pascal far clksta(struct CLOCK_DATA *data);

/****************************************************************************/
/*                THE PRECEDING PROGRAM IS THE SOLE PROPERTY OF             */
/*                               RONALD Q. SMITH                            */
/*             CONTAINING HIS PROPRIETARY CONFIDENTIAL INFORMATION          */
/*                 COPYRIGHT (c) RONALD Q. SMITH 1992, 1993                 */
/****************************************************************************/
