@echo off
REM
REM RESTZIP.BAT
REM
REM This batch file restores an UNZIPALLed ALLFILES.ZIP file as the
REM only file in the current subdirectory.  
REM
REM If the file ZIPALL1.USD is present in the current subdirectory 
REM (indicating that ZIPALL1.BAT was used to create the ALLFILES.ZIP --
REM and thus ALLFILES.ZIP contains no files from children subdirectories),
REM it will display all files within ONLY the current subdirectory that 
REM have the Archive attribute, as an indication of whether any files were
REM changed or added since UNZIPALL.BAT was executed. 
REM 
REM If the file ZIPALL1.USD is NOT present in the current subdirectory,
REM (indicating that ZIPALL.BAT was used to create the ALLFILES.ZIP --
REM and thus ALLFILES.ZIP DOES contain files from children subdirectories),
REM it will display all files within the current subdirectory AND any 
REM children subdirectories that have the Archive attribute, as an indication
REM of whether any files were changed or added since UNZIPALL.BAT executed.
REM
REM
REM After displaying files with the Archive attribute, the user must select:
REM
REM N -- No change   ALLFILES.ZIP will not be updated and the other files
REM                  will be deleted, child subdirectories removed, if any.
REM
REM U -- Update      ALLFILES.ZIP file will be updated with changed or added
REM                  files, in a move method that removes files and dirs.  
REM
REM X -- Exit        To exit RESTZIP.BAT with no action taken.
REM
REM
REM This BAT file:
REM   requires the use of the MS-DOS 5.0 (+) ATTRIB and DIR commands.
REM   requires the use of Patri-Soft's PDEL.EXE (Shareware)
REM   requires my WHICHWAY.EXE (Freeware)
REM   requires my FEED.EXE (Freeware)
REM
cls
if exist ALLFILES.ZIP goto continue
echo.
echo ALLFILES.ZIP does not exist in this subdirectory -- cannot be restored as
echo the only file.  Use ZIPALL or ZIPALL1 to create a new ALLFILES.ZIP.
goto exit
:continue
if not exist ZIPALL1.USD goto nowarn
dir /aa /b | more
echo.
echo If any file names are listed above, they are files that were changed or added
echo since you unzipped ALLFILES.ZIP with UNZIPALL.BAT.  You may want to Update
echo ALLFILES.ZIP with the new versions of the changed files (and add any newly
echo created files to it.)  Otherwise, you'll want to simply delete every file
echo except ALLFILES.ZIP to leave it as it was before you ran UNZIPALL.BAT.
echo Even if no files have changed, you can select Update to force the Archive
echo attribute to be turned on for ALLFILES.ZIP, for backup purposes.
echo Decide now, while viewing the list of files, above, before continuing.
pause
cls
whichway X,U,N
if errorlevel 255 goto abort
if errorlevel 3 goto nochange
if errorlevel 2 goto update
if errorlevel 1 goto abort
:nochange
attrib -h -s -r *.*
pdel allfiles.zip /o /wh /ba /eq /nt 
if not exist allfiles.zip echo ALLFILES.ZIP blown somehow!! -- Unerase it now!
REM *****************  USER MUST EDIT THE FOLLOWING LINE ********************* 
REM *****************  TO INDICATE WHERE ZIPALL1.USD IS !!!  *****************
copy c:\pkware\zipall1.usd 
if not exist zipall1.usd goto usdexit
attrib -a zipall1.usd
attrib -a allfiles.zip
prompt $P$G
dir
echo.
echo ALLFILES.ZIP has been successfully restored, all other files deleted.
echo The Archive bit for ALLFILES.ZIP has been reset (off).
echo ZIPALL1.BAT was used to create ALLFILES.ZIP for this directory only.
echo If this directory has subdirectories, DO NOT DELETE their contents!
goto exit
:update
if exist zipall1.usd del zipall1.usd
pkzip allfiles.zip *.* -mu -whs -Jhrs -ex
if errorlevel 1 goto errexit1
attrib +a allfiles.zip
REM *****************  USER MUST EDIT THE FOLLOWING LINE ********************* 
REM *****************  TO INDICATE WHERE ZIPALL1.USD IS !!!  *****************
copy c:\pkware\zipall1.usd
if not exist zipall1.usd goto usdexit
attrib -a zipall1.usd
prompt $P$G
dir
echo.
echo ALLFILES.ZIP has been updated with changed (and/or new) files.
echo All other files have been deleted (except Read-only files.)
echo.
echo ZIPALL1.BAT was used to create ALLFILES.ZIP from this directory only.
echo If this directory has subdirectories, DO NOT DELETE their contents!
echo.
goto exit
:nowarn
dir /aa /b /s | more
echo.
echo If any file names are listed above, they are files that were changed or added
echo since you unzipped ALLFILES.ZIP with UNZIPALL.BAT.  You may want to Update
echo ALLFILES.ZIP with the new versions of the changed files (and add any newly
echo created files to it.)  Otherwise, you'll want to simply delete every file
echo except ALLFILES.ZIP to leave it as it was before you ran UNZIPALL.BAT.
echo Even if no files have changed, you can select Update to force the Archive
echo attribute to be turned on for ALLFILES.ZIP, for backup purposes.
echo Decide now, while viewing the list of files, above, before continuing.
pause
cls
whichway X,U,N
if errorlevel 255 goto abort
if errorlevel 3 goto nochang2
if errorlevel 2 goto update2
if errorlevel 1 goto abort
:nochang2
attrib -h -s -r *.*
pdel allfiles.zip /o /eq /ba /wh /nt 
dir /ad /b | feed eatdir.bat
if not exist allfiles.zip echo ALLFILES.ZIP blown ! -- Unerase now!!
attrib -a allfiles.zip
prompt $P$G
dir
echo.
echo ALLFILES.ZIP has been successfully restored, all other files deleted.
echo Child subdirectories, if any, have also been removed.
echo ZIPALL.BAT was used to create ALLFILES.ZIP from this dir and any children dirs.
goto exit
:update2
pkzip allfiles.zip *.* -mu -whs -Jhrs -ex -rp
if errorlevel 1 goto errexit1 
attrib -h -s -r *.*
pdel allfiles.zip /o /eq /ba /wh /nt  
dir /ad /b | feed eatdir.bat
attrib +a allfiles.zip
prompt $P$G
dir
echo.
echo ALLFILES.ZIP has been updated with changed (and/or new) files.
echo All other files have been deleted.
echo Child subdirectories, if any, have also been removed.
echo ZIPALL.BAT was used to create ALLFILES.ZIP from this dir and any children dirs.
echo.
echo RUN YOUR BACKUPS BEFORE UNZIPPING THIS ALLFILES AGAIN -- ARCHIVE BIT IS ON!
echo.
goto exit
:errexit1
echo Error in execution of PKZIP.EXE (in RESTZIP.BAT).
echo ALLFILES.ZIP may not have been updated - Read messages above, generated 
echo by PKZIP, and do a DIR to see what's in the current directory before
echo proceeding.
goto exit
:usdexit
echo Error in execution of RESTZIP.BAT.
echo DID YOU READ THE INSTALLATION INSTRUCTIONS?
echo You must edit two lines in RESTZIP.BAT and one line in ZIPALL1.BAT to 
echo change the hardcoded location of ZIPALL1.USD from "c:\pkware" to 
echo wherever you decided to install these batch files (and ZIPALL1.USD).
echo Just locate the string "c:\pkware" and edit appropriately.
pause
goto exit
:abort
dir
echo.
echo RESTZIP aborted at point of decision.  No action taken.
goto exit
:exit
echo on
