/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedask.c_v   1.6   25 Mar 1992 15:44:36   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedask.c"
*!global paths!
*   gedcom\library\gedask.c
*   gedcom\all\gedask.c
*!end!
*
*   FILE NAME: GEDASK.C           
*
*   DESCRIPTION:
*       This file contains functions which find context within a record
*
*   ROUTINES:
*
*
*   MODIFICATION HISTORY:
*   _________________________________________________________________________
*    |  Date  | Who |  Comments
*    -------------------------------------------------------------------------
*$Log:   J:/gedcom/gedlib/vcs/gedask.c_v  $
 * 
 *    Rev 1.6   25 Mar 1992 15:44:36   fhdodj
 * Added function ged_ask_partial().
 * 
 *    Rev 1.5   21 Oct 1991 08:55:48   fhdodj
 * changed char to byte.
 * 
 *    Rev 1.4   28 Jun 1991 11:38:20   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.3   16 May 1991 13:37:40   odj
 * Moved ged_ask_string to its own file (gedaskst.c), and moved ged_match 
 * functions to the file gedmisc.c.
 * 
 *    Rev 1.2   03 May 1991 11:44:00   odj
 * Added check in ged_ask_string.  If ged_make_path fails, return NULL.
 * 
 *    Rev 1.1   15 Feb 1991 10:06:46   odj
 * moved void * into ifdefs for non ansi compilers who use char * instead.
 * 
 *    Rev 1.0   20 Dec 1990 08:16:32   odj
 * Initial revision.
***********************************************************************/

#include "gedcom.h"

/********************************************************************
*!name!
*    ged_ask()
*!1!
*
*        NAME: ged_ask
*
*        DESCRIPTION:
*            Gets the nth occurance of the node in obj at the end of
*            the path msg. In the future, if there is no value, an
*            attempt will be made to compute a value.
*
*        RETURN VALUE:
*            Returns the nth occurance of the node at the end of the
*            path or NULL if unsuccesful. If a value less than 0 is
*            given for nth, the first value will be returned. If a
*            value greater than the number of occurances is given,
*            NULL will be returned.
*
*        CALLS: ged_hunt_tags
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_ask(obj, msg, nth)
    NODE *obj;  /* The tree in which we will follow path msg */
    NODE *msg;  /* The path to follow */
    int   nth;  /* Which occurance to return */
    {			/*!end!*/

	if (!msg && (nth < 2)) /* If no msg and we are looking for the */
	    return(obj); /* first occurance we are already there */
	if (!msg)  /* If no msg and we are not looking for the */
	    return(NULL); /* next occurance, there isn't one */
        obj = ged_get_child(obj);
        if (!obj)  /* If no tree to look in, we must fail. */
            return(NULL);
        return(ged_hunt_tags(obj, msg, &nth));
    }
/**/
/********************************************************************
*!name!
*    ged_ask_partial()
*!1!
*
*        NAME: ged_ask_partial
*
*        DESCRIPTION:
*            Gets the nth occurance of the node in obj at the end of
*            the path msg. In the future, if there is no value, an
*            attempt will be made to compute a value.
*
*        RETURN VALUE:
*            Returns the nth occurance of the node at the end of the
*            path or NULL if unsuccesful. If a value less than 0 is
*            given for nth, the first value will be returned. If a
*            value greater than the number of occurances is given,
*            NULL will be returned.
*
*        CALLS: ged_hunt_tags
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_ask_partial(obj, msg, nth)
    NODE *obj;  /* The tree in which we will follow path msg */
    NODE *msg;  /* The path to follow */
    int   nth;  /* Which occurance to return */
    {			/*!end!*/
    NODE *ret_val;
    NODE *tmp_obj;
    NODE *start_obj = obj;

	if (!msg && (nth < 2)) /* If no msg and we are looking for the */
	    return(obj); /* first occurance we are already there */
	if (!msg)  /* If no msg and we are not looking for the */
	    return(NULL); /* next occurance, there isn't one */
        if (nth <= 0)
            nth = 1;
	while(obj && (nth > 0))
	    {
	    tmp_obj = ged_get_child(obj);
	    if (tmp_obj)
                ret_val = ged_hunt_tags(tmp_obj, msg, &nth);
            if ((obj = ged_get_next_node(obj)) == start_obj)
                {
	        obj = NULL;
		ret_val = NULL;
		}
	    }
        return(ret_val);
    }
/**/
/********************************************************************
*!name!
*    ged_ask_xref()
*!1!
*
*        NAME: ged_ask_xref
*
*        DESCRIPTION:
*            Finds the node in obj at the current level, or at a
*            lower level with the given Xref value.
*
*        RETURN VALUE:
*            Returns the node with the given Xref value, or NULL if
*            it cannot be found.
*
*        CALLS: ged_apply_tree, ged_match_xrefs
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_ask_xref(obj, xref)
    NODE *obj;   /* The tree in which we will try to find xref */
    byte *xref;  /* The cross reference to find */
    {			/*!end!*/

        if (!obj || !xref)  /* If no tree, or no xref to look for, fail */
            return(NULL);
        return(ged_apply_tree(obj, 0, 1, ged_match_xrefs, xref, NULL));
    }
/**/
/********************************************************************
*!name!
*    ged_hunt_tags()
*!1!
*
*        NAME: ged_hunt_tags
*
*        DESCRIPTION:
*            Traverses the path in msg to find the nth occurance of
*            the node in the tree obj at the end of the path.
*
*        RETURN VALUE:
*            The nth occurance of the node at the end of the path
*            msg in obj, or NULL if not found. If a value less than
*            one is given for nth, the first occurance will be
*            returned. If a value for nth is given that is greater
*            than the number of occurances, NULL will be returned.
*
*        CALLS: ged_inherits
*
*        CALLED BY: ged_ask, ged_ask_string
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_hunt_tags(obj, msg, nth)
    register NODE *obj;  /* The tree to look in */
    register NODE *msg;  /* The path describing what to look for */
    int   *nth;          /* Which occurance to return */
    {			/*!end!*/
    NODE *lastObj = obj->parent;  /* contains the last obj position */
    NODE *start = obj->parent;    /* tells where we started. */

        while (msg)
            {

            /* find the next part of the path                   */
            while (obj && !ged_inherits(obj, msg))
                obj = obj->sibling;
		
	    /* try again when no more obj or need next answer.  */
            if (!obj || (!msg->child && (--(*nth) > 0)))
                {
		if (!obj)
                    {
                    obj = lastObj;
                    msg = msg->parent;
                    }
                while (!obj->sibling && msg)
                    {
                    obj = obj->parent;
                    msg = msg->parent;
                    }
                obj = obj->sibling;
                lastObj = ged_get_parent(obj);
                }

            /* if there is more in msg keep looking.            */
            else if (msg->child)
                {
                msg = msg->child;
                lastObj = obj;
                obj = obj->child;
                }

            /* The right answer was found */
            else if (*nth <= 0)
                return(obj);
            }
        if (start->sibling == obj)
            return(NULL);
        return(obj);
    }
/**/
/********************************************************************
*!name!
*    ged_inherits()
*!1!
*
*        NAME: ged_inherits
*
*        DESCRIPTION:
*            Will determine if node1 is equivalent to node2.
*            Currently only checks that tag1 equals tag2. In the
*            future will check for things like marriage is
*            equivalent to banns.
*
*        RETURN VALUE:
*            returns 0 if false, and 1 if true.
*
*        CALLS: ged_match_tags
*
*        CALLED BY: ged_hunt_tags
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_inherits(node1, node2)
    NODE *node1;
    NODE *node2;
    {			/*!end!*/

        if (ged_match_tags(node1, node2))
            return(0);
        return(1);
    }

/********************************************************************
*!name!
*    ged_match_xrefs()
*!1!
*
*        NAME: ged_match_xrefs
*
*        DESCRIPTION:
*            Compares two Xrefs.
*
*        RETURN VALUE:
*            Returns 0 if equal, or a non-zero value if not.
*
*        CALLS: ged_get_xref, ged_match
*
*        CALLED BY: ged_hunt_xref, ged_apply_tree
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_match_xrefs(unreferencedLevel, obj, xref, unreferencedArg2)
    int   unreferencedLevel;
    NODE *obj;
#ifdef NON_ANSI
    byte *xref;
    byte *unreferencedArg2;
#else
    void *xref;
    void *unreferencedArg2;
#endif
    {			/*!end!*/

        return(ged_match(ged_get_xref(obj), (byte *)xref));
    }
