/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gederror.c_v   1.5   27 Sep 1991 07:28:02   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgederror.c"
*!global paths!
*   gedcom\library\gederror.c
*   gedcom\all\gederror.c
*!end!
*
*   FILE NAME: GEDERROR.C
*
*   DESCRIPTION:
*       This file contains functions for gedcom error reporting and 
*       handling.
*
*   ROUTINES:
*       ged_error(int err_no, NODE * err_node);
*
*$Log:   J:/gedcom/gedlib/vcs/gederror.c_v  $
 * 
 *    Rev 1.5   27 Sep 1991 07:28:02   fhdodj
 * Added ranges for Gedcom processor and Hash package errors in the default
 * ged_error function.
 * 
 *    Rev 1.4   09 Sep 1991 10:51:22   fhdodj
 * Added #define NON_ANSI for function pointer prototype.
 * 
 *    Rev 1.3   28 Jun 1991 14:05:40   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.2   18 Jun 1991 13:35:38   odj
 * Error message is now printed to stderr, an additional line is also printed 
 * if the node the error occurred on is included.
 * 
 *    Rev 1.1   18 Jun 1991 08:11:04   odj
 * Fixed typo.
 * 
 *    Rev 1.0   17 Jun 1991 16:14:44   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/*  Static global to keep track of user error function */
#ifdef NON_ANSI
static int (*ged_error_handler)() = NULL;
#else
static int (*ged_error_handler)(int, NODE *) = NULL;
#endif

/*****************************************************************************
*!name!
*    ged_set_error_handler()
*!1!
*
*   NAME:   ged_set_error_handler
*
*   DESCRIPTION:
*       Set the static global ged_error_handler to point to a user defined
*       error handler.
*
*   RETURN VALUE:
*       None.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
*****************************************************************************/
void ged_set_error_handler(error_handler)
#ifdef NON_ANSI
    int (*error_handler)();
#else
    int (*error_handler)(int, NODE *);
#endif
    {			/*!end!*/
        ged_error_handler = error_handler;
    }

/*****************************************************************************
*!name!
*    ged_error()
*!1!
*
*   NAME:   ged_error
*
*   DESCRIPTION:
*       if a user defined error function has been defined, then that error
*       function is called, otherwise, the error is printed to stderr.
*
*   RETURN VALUE:
*       Value to indicate continiue or do not continue.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
*****************************************************************************/
int ged_error(err_no, err_node)
    int err_no;
    NODE * err_node;
    {			/*!end!*/

        if (ged_error_handler)
            return((*ged_error_handler)(err_no, err_node));
        if (err_no < 100)
            {
            fprintf(stderr,
                    "GEDCOM ERROR:  Memory Error Number %d has occurred\n",
                    err_no);
            if (ged_get_line(err_node))
                fprintf(stderr, "LINE: %s\n", ged_get_line(err_node));
            }
        else if (err_no < 200)
            {
            fprintf(stderr,
                    "GEDCOM ERROR:  IO Error Number %d has occurred\n",
                    err_no);
            if (ged_get_line(err_node))
                fprintf(stderr, "LINE: %s\n", ged_get_line(err_node));
	    }
        else if (err_no < 300)
            {
             fprintf(stderr,
                    "GEDCOM ERROR:  Bad GEDCOM Error Number %d has occurred\n",
                    err_no);
            if (ged_get_line(err_node))
                fprintf(stderr, "LINE: %s\n", ged_get_line(err_node));
            }
        else if (err_no < 400)
            {
            fprintf(stderr, "GEDCOM ERROR:  GEDPROC Error Number %d has occurred\n", err_no);
            if (ged_get_line(err_node))
                fprintf(stderr, "LINE: %s\n", ged_get_line(err_node));
            }
        else if (err_no < 500)
            {
            fprintf(stderr, "GEDCOM ERROR:  GEDHASH Error Number %d has occurred\n", err_no);
            if (ged_get_line(err_node))
                fprintf(stderr, "LINE: %s\n", ged_get_line(err_node));
            }
        return(1);
    }
