/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedget.c_v   1.7   25 Mar 1992 15:48:24   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedget.c"
*!global paths!
*   gedcom\library\gedget.c
*   gedcom\all\gedget.c
*!end!
*
*   FILE NAME: GEDGET.C           
*
*   DESCRIPTION:
*       This file contains functions which retrieve pieces of records or
*        nodes.
*
*   ROUTINES:
*
*
*   MODIFICATION HISTORY:
*$Log:   J:/gedcom/gedlib/vcs/gedget.c_v  $
 * 
 *    Rev 1.7   25 Mar 1992 15:48:24   fhdodj
 * Made macros versions accesible only inside this file of ged_get_tag,
 * and ged_get_xref, to speed up the functions ged_get_tag, and ged_get_value.
 * this also speeds up the ged_ask functions.
 * 
 *    Rev 1.6   17 Mar 1992 08:41:58   fhdodj
 * modified ged_get_tag and ged_get_xref.
 * 
 *    Rev 1.5   21 Oct 1991 09:01:44   fhdodj
 * Changed char to be byte.
 * 
 *    Rev 1.4   04 Sep 1991 14:46:54   fhdodj
 * ged_get_value() returns NULL if node->line is NULL.
 * 
 *    Rev 1.3   02 Jul 1991 08:25:56   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.2   16 May 1991 12:46:44   odj
 * Fixed bug.  If ged_get_value_raw had a NULL directly after the tag, an
 * invalid pointer was returned (the position after the '\0' in the string)
 *
 *    Rev 1.1   15 Jan 1991 15:04:46   odj
 * changed in ged_get_value and ged_get_value_raw a condition *line > ' ' to be
 * !isspace(*line) && *line.
 *
 *    Rev 1.0   20 Dec 1990 08:25:38   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/********************************************************************
*
*        NAME: GED_GET_XREF
*
*        DESCRIPTION:
*            Macro version of ged_get_xref
*
********************************************************************/
#define GED_GET_XREF(node, xref)			\
	if (xref = ged_get_line(node))			\
	    {						\
	    while (isspace(*xref))			\
		xref++;					\
	    if (*xref == '@')				\
		{					\
		byte *startxref = xref;			\
		while(!isspace(*xref) && (*xref != '@'))\
		    xref++;				\
		if (*xref != '@')			\
		    startxref = NULL;			\
		xref = startxref;			\
		}					\
            else					\
	        xref = NULL;				\
	    }

/********************************************************************
*    GED_GET_TAG()
*
*        NAME: GED_GET_TAG
*
*        DESCRIPTION:
*            Macro version of ged_get_tag
*
********************************************************************/
#define GED_GET_TAG(node, tag)			\
	if (tag)				\
	    {					\
	    tag++;				\
	    while(*tag++ != '@')		\
		;				\
	    while(isspace(*tag))		\
		tag++;				\
	    }					\
	else if (node && (tag = node->line))	\
	    {					\
	    while (isspace(*tag))		\
		tag++;				\
	    }

/********************************************************************
*!name!
*    ged_get_child()
*!1!
*
*        NAME: ged_get_child
*
*        DESCRIPTION:
*            Gets a pointer to Child.
*
*        RETURN VALUE:
*            A pointer to Child, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_child(node)
    NODE *node;
    {			/*!end!*/

	return(node ? node->child : NULL);
    }

/********************************************************************
*!name!
*    ged_get_last_sibling()
*!1!
*
*        NAME: ged_get_last_sibling
*
*        DESCRIPTION:
*            Gets the last sibling in the sibling list.
*
*        RETURN VALUE:
*            A pointer to the node, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_last_sibling(node)
    register NODE *node;
    {			/*!end!*/

	if (!node)
            return(NULL);
        while (node->sibling)
             node = node->sibling;
        return(node);
    }

/********************************************************************
*!name!
*    ged_get_line()
*!1!
*
*        NAME: ged_get_line
*
*        DESCRIPTION:
*            Gets a pointer to line.
*
*        RETURN VALUE:
*            A pointer to line, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_get_line(node)
    NODE *node;
    {			/*!end!*/

        return(node ? node->line : NULL);
    }
/**/
/********************************************************************
*!name!
*    ged_get_next_node()
*!1!
*
*        NAME: ged_get_next_node
*
*        DESCRIPTION:
*            Gets the next node in the tree. The next node will be
*            a child node if one exists, then a sibling. If we have
*            niether of these, then we try a parent sibling for
*            these same values.
*
*        RETURN VALUE:
*            A pointer to the node, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_next_node(node)
    NODE *node;
    {			/*!end!*/
    NODE *returnValue = ged_get_child(node);

	if (returnValue)
	    return(returnValue);
	while (!ged_get_sibling(node) && node)
            node = ged_get_parent(node);
	return(ged_get_sibling(node));
    }

/********************************************************************
*!name!
*    ged_get_next_level()
*!1!
*
*        NAME: ged_get_next_level
*
*        DESCRIPTION:
*            Gets the next node in the tree. The next node will be
*            a child node if one exists, then a sibling. If we have
*            niether of these, then we try a parent sibling for
*            these same values.  adjusts level to be the current
*            level.
*
*        RETURN VALUE:
*            A pointer to the node, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_next_level(node, level)
    NODE *node;
    int *level;
    {			/*!end!*/
    NODE *returnValue = ged_get_child(node);

	if (returnValue)
	    {
            *level += 1;
	    return(returnValue);
	    }
	while (!ged_get_sibling(node) && node)
            {
	    *level -= 1;
            node = ged_get_parent(node);
            }
	return(ged_get_sibling(node));
    }

/********************************************************************
*!name!
*    ged_get_parent()
*!1!
*
*        NAME: ged_get_parent
*
*        DESCRIPTION:
*            Gets a pointer to parent
*
*        RETURN VALUE:
*            A pointer to parent, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_parent(node)
    NODE *node;
    {			/*!end!*/

        return(node ? node->parent : NULL);
    }
/**/
/********************************************************************
*!name!
*    ged_get_previous_node()
*!1!
*
*        NAME: ged_get_previous_node
*
*        DESCRIPTION:
*            Gets the previous node in the tree. The method to find
*            the previous node in the tree is a follows. If there is
*            no previous sibling, then the previous node is the
*            parent. If there is a previous node then go to the
*            last sibling of the child, see if it has a child, and
*            do it again.
*
*        RETURN VALUE:
*            A pointer to the node, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_previous_node(node)
    NODE *node;
    {			/*!end!*/
    NODE *returnValue = ged_get_previous_sibling(node);

        if (!returnValue)
            return(ged_get_parent(node));
	while (node = ged_get_last_sibling(ged_get_child(returnValue)))
            returnValue = node;
        return(returnValue);
    }

/********************************************************************
*!name!
*    ged_get_previous_sibling()
*!1!
*
*        NAME: ged_get_previous_sibling
*
*        DESCRIPTION:
*            Gets the sibling in the sibling list listed before the
*            current node.
*
*        RETURN VALUE:
*            A pointer to the node, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_previous_sibling(node)
    NODE *node;
    {			/*!end!*/
    register NODE *temp = ged_get_parent(node);

        if (!temp || ((temp = ged_get_child(temp)) == node))
            return(NULL);
	while (temp->sibling != node)
             temp = temp->sibling;
        return(temp);
    }
/**/
/********************************************************************
*!name!
*    ged_get_sibling()
*!1!
*
*        Name: ged_get_sibling
*
*        DESCRIPTION:
*            Gets a pointer to sibling.
*
*        RETURN VALUE:
*            A pointer to sibling, or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_get_sibling(node)
    NODE *node;
    {			/*!end!*/

        return(node ? node->sibling : NULL);
    }

/********************************************************************
*!name!
*    ged_get_tag()
*!1!
*
*        NAME: ged_get_tag
*
*        DESCRIPTION:
*            Gets a pointer to the tag
*
*        RETURN VALUE:
*            A pointer to the tag part of the line, or NULL if none.
*
*        CALLS: getXref
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_get_tag(node)
    NODE *node;
    {			/*!end!*/
    byte *tag = NULL;

	GED_GET_XREF(node, tag)
	GED_GET_TAG(node, tag)
	return(tag);
    }

/**/
/********************************************************************
*!name!
*    ged_get_value()
*!1!
*
*        NAME: ged_get_value
*
*        DESCRIPTION:
*            returns a pointer to the value part of the line
*
*        RETURN VALUE:
*            A pointer to the value part of line, or NULL if none.
*
*        CALLS: ged_get_tag
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_get_value(node)
    NODE *node;
    {			/*!end!*/
    byte *line;

	if (!node || !node->line)
	    return(NULL);
	GED_GET_XREF(node, line)
	GED_GET_TAG(node, line)
	if (line)
	    {
	    while (!isspace(*line) && *line)
		line++;
	    while (isspace(*line))
		line++;
	    }
	return(line);
    }

/**/
/********************************************************************
*!name!
*    ged_get_value_raw()
*!1!
*
*        NAME: ged_get_value_raw
*
*        DESCRIPTION:
*            returns a pointer to the value part of the line
*
*        RETURN VALUE:
*            A pointer to the value part of line, or NULL if none.
*
*        CALLS: ged_get_tag
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_get_value_raw(node)
    NODE *node;
    {			/*!end!*/
    byte *line;

	if (!node)
	    return(NULL);
	if (line = ged_get_tag(node))
	    {
	    while (!isspace(*line) && *line)
		line++;
	    if (*line)
		line++;
	    }
	return(line);
    }
/**/
/********************************************************************
*!name!
*    ged_get_xref()
*!1!
*
*        NAME: ged_get_xref
*
*        DESCRIPTION:
*            Gets a pointer to the Xref identifier
*
*        RETURN VALUE:
*            A pointer to the xref part of the line or NULL if none.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_get_xref(node)
    NODE *node;
    {			/*!end!*/
    byte *xref;

	GED_GET_XREF(node, xref)
	return(xref);
    }

/**/
/********************************************************************
*!name!
*    ged_get_tree_size()
*!1!
*
*        NAME: ged_get_tree_size
*
*        DESCRIPTION:
*            Compute how much space the gedcom record will take if in a
*            Buffer.
*
*        RETURN VALUE:
*            The size.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_get_tree_size(NODE *node)
    {
    int size = 0;
    int tmp = 0;
    int level = 0;
    
	while(node)
	    {
	    size += node->length + 3; /* 1 for space 2 for CR LF */
	    tmp = level;
	    while(tmp > 9) /* get length of level */
		{
		tmp /= 10;
		size++;
		}
	    size++;        /* add one for last digit of level. */
	    node = ged_get_next_level(node, &level);
	    }
        size++;   /* add one to NULL terminate. */
        return(size);
    }
