/****************************************************************************
 * 
 *      Copyright (c) 1991  Corporation of the President of 
 *                          the CHURCH of JESUS CHRIST of LATTER-DAY SAINTS.
 * 
 *      All rights reserved.  Unauthorized reproduction of this software is
 *      prohibited and is in violaton of United States copyright laws.
 * 
 ****************************************************************************/
/****************************************************************************
 *
 * FILE: GEDHASH.H
 *
 * MODIFICATION HISTORY:                                                                                                                                                  
 * ----------------------------------------------------------------------                                                                                                                                                  
 * |  Date           | Who | Comments
 * ----------------------------------------------------------------------
 * | 09/12/91 09:58am| LAM | Code only used for external & internal hash functions moved here
 * ----------------------------------------------------------------------                                                                                                                                                  
 ****************************************************************************/


#define BLKLEN 512 /* Length of block on disk. A key/value record must fit in this. */
#define when  break; case
#define DEF_ERR 50  /*  Default error code to send to ged_error */
#define DUP_KEY_FOUND 2
#define KVSIZE sizeof(KVPAIR)
#ifndef MAX_XREF_ID_LENGTH
#define MAX_XREF_ID_LENGTH 11
#endif
#define MAX_TAG_LENGTH 20 /* Used in expander function */
#ifndef MAX_MEMORY
#define MAX_MEMORY (LEN)6000
#endif
#define GLIMIT (unsigned long)5000 /* for GLIMIT variable in gedproc.c */
#define SEEK_SIZ 10  /* Size of seek val returned from gedhash_lookup() */
#define MAX_FILE_H (HSIZ)400  /* Maximum size of hash table that goes to file */
#define MIN_FNAME_SIZ 13  /* Minimum lenth of file name.  Used in gedhash_create_table */
#define PATH_SIZ 120    /* Size of a Full path name of a file */
#define EXT_SIZ 5   /* Size of a file name extention */
#define NO_SUCCESS 0
#define SUCCESS 1
#define KEY_NOT_FOUND -1
#define HTAB_NOT_FOUND -2
#define IO_ERROR -1       /* Returned by elseek(), eread(), etc. */
#define IO_SUCCESS 1       /* Returned by elseek(), eread(), etc. */
#define TRUE 1     
#define FALSE 0     


/******* ged_error() error codes *************/

#define SEEK_ERR         401
#define READ_ERR         402
#define RECORD_ERR       403
#define CREATE_TABLE_ERR 404
#define XREF_LENGTH_ERR  405
#define INS_ERR          406 /* xref hash insertion error in gedhash_create_xref() */ 
#define NO_TRLR_ERR      407 /* No TRLR tag encountered in gedhash_create_xref() */
#define WRITE_ERR        408  /* Error with write() */
#define OPEN_ERR         409   /* Error with open()  */
#define FOPEN_ERR        410  /* Error with fopen() */
#define BLKLEN_ERR       411 /* Error with open()  */
#define CHNG_FLOPPY      412 /* User must insert a floppy with the right .G00 */
#define PTR_ERR          413 /* Could not find a pointer */
#define SETUP_INSERT_ERR 414 /* Could not insert value into disk hash table from diskSetup */
#define REMOVE_ERR       415 /* Error with remove() */
#define CLOSE_ERR        416 /* Error with close() */
#define GEDFN_ERR        417 /* Error in gedhash_fopen() */




/* Returns count of the number of key currently held in the hash table */
#define GEDHASH_COUNT(htab) (htab ? htab->key_count : 0L)


#ifndef NON_ANSI /* ##paramerter## : ## not allowed on both sides of parameter */
/* So don't have to type cast */
#define GEDHASH_LOOKUP(htab, key, keyLen, val, valLen, status, data_type) (##data_type##*)\
        gedhash_lookup(htab, key, (KSIZ)keyLen, val, (LEN *)valLen, status)
#endif

/* A kinder, gentler gedhash_insert.  Values are type-casterated for you. */
#define GEDHASH_INSERT(htab, key, keyLen, val, valLen) \
            gedhash_insert(htab, key, (KSIZ)keyLen, val, (LEN)valLen)

#define SET_LENGTH(keyOrVal, len) len = ((len) ? len : strlen(keyOrVal) +1)


/*********** MACRO NAME: GED_EREAD   DESCRIPTION: Performs read() and checks for error */
#define GED_EREAD(handle, buffer, count) if (read(handle, buffer, count) <= 0) \
    ged_error(READ_ERR, NULL)


/* Used in ged_create_xref_hash_table() */
typedef enum {
              WANT_LEVEL, WANT_1ST_AT_SIGN_OR_TAG, WANT_XREF,
              WANT_TERMINATOR, HAVE_KEY_WANT_TERMINATOR, WANT_TERMINAT_OR_TRLR_TAG
             }  CX_State;

typedef enum { GHFALSE, GHTRUE } GHBool;

typedef long MEMSIZ;


typedef unsigned int LEN;  /* Used to type valLen field of KVPAIR & KVDISK structs */
typedef unsigned int KSIZ; /* Used to type keyLen */
typedef unsigned long HSIZ;  /* Used to type the h field of a HASH_TAB struct */
typedef unsigned long ITSIZ;  /* Used to type the it_pos field of a HASH_TAB struct */

/***************** KVPAIR struct -- Memory-based hash table record *********/


typedef struct hash_cell
  {
  char *key;     /*  look-up key */
  KSIZ keyLen;   /*  length of key */
  char *val;     /*  value associated with key */
  LEN valLen;    /*  Length of val */
  struct hash_cell *next; /* Points to next record in hash table collision list */
  } KVPAIR;

/* KVDISK struct--Disk-based hash table record. key and val are positioned behind this record */

typedef struct two_len
    {  
    KSIZ keyLen;
    LEN valLen;
    unsigned long totalLen; /* When record 1st made, this gets (keyLen + valLen) Also points to nxt blk */
    } KVDISK;


/******** HASH_TAB struct -- Contains info associated with a hash table *****/

typedef struct
  {
  HSIZ h;            /* size of hash table */
  POOL *pool;        /* stores hash table.  Destroyed when written to disk */
  KVPAIR **table;    /* table of pointers to hash table */
  ITSIZ it_pos;      /* iterate position.  Points to begin. of collison list (memory) */
  KVPAIR *mem_iterate; /* points to current position in collision list in memory*/
  long disk_iterate; /* points to current seek position in collision list on disk */
  MEMSIZ maxMemory;  /* maximum memory that this table can use */
  MEMSIZ memoryLeft; /* maximum memroy less memory used by table */
  char hfn[PATH_SIZ];/* hash file name */
  int isMemory;      /* contains value 1 if hash table goes to memory.  Used to
                      * determine if a temporary file should be deleted when 
                      * gedhash_close_table is called. */

  int fh;            /* hash file handle */
  char gedfn[PATH_SIZ];    /* GEDCOM data file name */
  FILE *fg;          /* GEDCOM data file pointer */
  int ged_ext;       /* If .gedfn spans multiple disks, this is used to show current disk
                      * being processed, i.e.,  .GED = -1, .G00 = 0, .G01 = 1, etc. */
  long key_count;    /* The number of keys currently in the table */
  } HASH_TAB;


int     ged_eclose(int handle);
FILE *  ged_efopen(char *path, char *mode);
int     ged_elseek( int handle, long offset, int origin);
int     ged_eopen(char *filename, int oflag, int pmode);
int     ged_eread(int handle, void *buffer, unsigned count );
int     ged_ewrite(int handle, void *buffer, unsigned int count);
int     gedhash_close_table(HASH_TAB *htab);
int     gedhash_copy(HASH_TAB *htab_dest, HASH_TAB *htab_source);
HASH_TAB *gedhash_create_table(HASH_TAB *htab, char *perm_file, HSIZ hash_size, MEMSIZ max_memory);
HASH_TAB gedhash_create_xref(char *ged_filename, char *hash_filename, HSIZ h_size);
int     gedhash_delete(HASH_TAB *htab, void * key, KSIZ keyLen);
int     gedhash_destroy_table(HASH_TAB *htab);
NODE *  gedhash_find_xref(HASH_TAB *htab, NODE *dataCtxt);
FILE *  gedhash_fopen(HASH_TAB *htab, char *gedcom_path, char *mode);
char *  gedhash_get_drive(void);
char *  gedhash_get_file(void);
NODE *  gedhash_get_rec_xref(HASH_TAB *htab, char *value);
int     gedhash_insert(HASH_TAB *htab, void *key, KSIZ keyLen, void *val, LEN valLen);
int     gedhash_iterate(HASH_TAB *htab, void *key, KSIZ *keyLen, void *val, LEN *valLen);
void    gedhash_iterate_reset(HASH_TAB *htab);
void *  gedhash_lookup(HASH_TAB *htab, void *key, KSIZ keyLen, void *val, LEN *valLen, int *status);
int     gedhash_pointer(char *filename);
HSIZ    gedh_prime(HSIZ h);
void    *gedh_word_align(void *address);
//NODE    *read_tree(FILE *, short *, unsigned long);
