/****************************************************************************
 * 
 *      Copyright (c) 1991  Corporation of the President of 
 *                          the CHURCH of JESUS CHRIST of LATTER-DAY SAINTS.
 * 
 *      All rights reserved.  Unauthorized reproduction of this software is
 *      prohibited and is in violaton of United States copyright laws.
 * 
 ****************************************************************************/
/*******************************************************************
 *
 * FILE: GEDISK.H  DESCRIPTION:  Header file for gedisk.c
 *
 ********************************************************************/

#define STATE break; case  /* Switch statement identifies each state */
#define WHILESTATE( x ) while ( x ) switch( x )
#define COND(pred, action, next_state) if(pred) { action##(); state = next_state; break; }
#define NIL() /* Function that does nothing */

/* If key is matched in gedh_insert_disk() then return DUP_KEY_FOUND */
#define SET_DUP_FOUND() (Return_status = DUP_KEY_FOUND)


/************* Macroes for Event testing functions ***************/
    
#define IsDefault TRUE
#define IsEOBLK       (RecordType == EOBLOCK)
#define IsEOList      (RecordType == EOLIST)
#define IsGarbage     (RecordType == GARBAGE)
#define IS_GARBAGE_SLOT  (Garbage.size) /* Was a garbage slot that was found? */
#define IsGarbInOldBlock (Filepos != Garbage.block)
#define IsGarbInThisBlock (Filepos == Garbage.block)
#define IsMatched     (RecordType == MATCHED)
#define IsUnmatched   (RecordType == UNMATCHED)
  
/* I have found a match.  Is match the best fit out between it & possible garbage? */
#define IsMatchBest (RightKvSize && (!IsGarbage || (IsGarbage && gedh_closer_fit())))
        
/* Is size of this Kv record the same size as the record we wish to insert */
#define IsRightSize (gedh_kvsize(Kv) >= (KeyLen + ValLen))

/* Is size of this Kv record as big or bigger than record we wish to insert */
#define RightKvSize (gedh_kvsize(Kv) >= (KeyLen + ValLen))

/* Make sure enough room in block to write the current record plus the
 * EOBlock record I do this by taking the differrence between the start of
 * the Buffer and the current location of kv.  Then add the size of the kv
   record and then the size of an EOBlock record. */
#define IsRoomHere  (( ( (char *)Kv - (char *)Buffer ) +    \
      (2* (sizeof(KVDISK))) + (LEN)KeyLen + ValLen +7 /* word alignmnt */ ) < (LEN)BLKLEN )


/************************ typedef's ******************************/

typedef enum { QUIT, LSEEK_TO_HASH, GET_NEXT_KV, LOAD_KV, GET_RECORD_TYPE, WANT_TO_INSERT,
               FOUND_GARBAGE, FOUND_MATCH, WHERE_IS_GARB, WRITE_EOLIST, WANT_TO_MATCH,
               UNSUCCESS, WANT_RECORD, LOAD_ITERATE_KV, WANT_NEXT_ROW, LSEEK_TO_IT_POS,
               WANT_TO_DELETE } State;

typedef struct garbStruct
  {
  long block; /* points to block number with the best garbage slot */
  KVDISK *garb_record;   /* points to the position within the block */
  LEN size;   /* size of garbage record */
  } GARB;

/************* Prototypes for Action functions ***************/
static void gedh_hash_seek(void);
static void gedh_writeNewBlk(void);
static void gedh_writeEOL(void);
static void gedh_makeGarb(void);
static void gedh_toGarbBuf(void);
static void gedh_toOldBuf(void);
static void gedh_setGarb(void);
static void gedh_toBuf(void);
static void gedh_toNxtBlk(void);
static void gedh_toBuf(void);
static void gedh_getRecordType(void);
static void gedh_loadKv(void);
static void gedh_loadNxtKv(void);
static void gedh_hash_seek(void);
static void gedh_read_block(char *buf);
static LEN gedh_kvsize(KVDISK *kv);


/************* Prototypes for Other functions ***************/
static GHBool gedh_closer_fit(void);


/*************** Variables used in state machine **************/

static int Buffer_change_flag; /* Indicates if buffer is changed & needs rewriting to disk */
static HASH_TAB *Htab;
static char *Key;
static KSIZ KeyLen;
static char *Val;
static LEN ValLen;
static KVDISK *Kv; /* current record in buffer */
static GARB Garbage; /* position of a possible garbage slot*/
static int Fh;
static char Buffer[BLKLEN]; /* buffer to read in block */
static char *Dkey;
static char *Dval; /* Used to load key and val strings from disk buffer */
static long Filepos;
static long *NextBlock;
static READSTATUS RecordType;
static LEN Room; /* For debugging a isRoomHere macro.  Not used right now. */
static int Return_status; /* Return status from functions SUCCESS or no_SUCCESS */

/* Used in FOUND_GARBAGE state. If a match for key was found, but the new
value was too big to fit in the old record, then the collision list is traversed
until a garbage record is found that fits the record, or the EOList is found. */
static int IsMatchFound;
