/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedrdmem.c_v   1.1   06 Nov 1992 10:43:48   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedrdmem.c"
*!global paths!
*   gedcom\library\gedrdmem.c
*   gedcom\all\gedrdmem.c
*!end!
*
*   FILE NAME: GEDRDMEM.C
*
*   DESCRIPTION:
*       This file contains functions for reading from files.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedrdmem.c_v  $
 * 
 *    Rev 1.1   06 Nov 1992 10:43:48   fhdodj
 * Fixed header information.
 * 
 *    Rev 1.0   05 Aug 1992 19:28:32   fhdodj
 * Initial revision.
 * 
 *    Rev 1.0   28 Jul 1992 09:34:36   fhdodj
 * Initial revision.
 * 
 *    Rev 1.12   03 Mar 1992 09:44:54   fhdodj
 * Replaced fpos with -bytesRead in NON_ANSII part of ged_read_line.
 * 
 *    Rev 1.11   03 Mar 1992 09:35:14   fhdodj
 * Removed fflush and ftell from file.
 * 
 *    Rev 1.10   21 Oct 1991 09:06:44   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.9   09 Aug 1991 10:24:24   fhdodj
 * Changed condition in ged_read_tree so that LAST_RECORD is now returned.
 * 
 *    Rev 1.8   26 Jul 1991 13:31:26   fhdodj
 * Fixed status return from ged_read_line and ged_read_level.  Didn't return
 * LAST_RECORD correctly.
 * 
 *    Rev 1.7   28 Jun 1991 14:08:10   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.6   25 Jun 1991 09:04:14   fhdodj
 * Fixed functions ged_connect_child and ged_connect_sibling.  They were 
 * attaching nodes in the wrong place when given an argument other than -1.
 * 
 *    Rev 1.5   18 Jun 1991 13:39:56   odj
 * Added check in ged_read_line so we dont get an error for invalid character
 * when there is a carriage return or newline.
 * 
 *    Rev 1.4   18 Jun 1991 11:08:12   odj
 * Changed error number ranges.
 * 
 *    Rev 1.3   17 Jun 1991 16:03:00   odj
 * Added IO status checks.  Added calls to ged_error() function.  Also added
 * checking in ged_read_line function for invalid tags and cross references
 * being read.  Changed arguments to ged_read_level() function so that status is
 * now being checked in this function also.
 * 
 *    Rev 1.2   25 Apr 1991 10:06:18   odj
 * changed ged_fprintf() to output a carriage return linefeed insteadof just a 
 * linefeed.
 * 
 *    Rev 1.1   14 Feb 1991 15:02:42   odj
 * void is not allowed by some non ansi compilers (e.g. the CYBER). so I 
 * changed void to be char for non ansi compilers.
 * 
 *    Rev 1.0   20 Dec 1990 08:59:48   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

int ged_read_node(fp, startLevel, status, bytesRead, node)
    register FILE *fp;
    short          startLevel;
    short         *status;
    int           *bytesRead;
    NODE          **node;
    {                   /*!end!*/
    int  level = 0;
    int  levelRead = 0;
    int  c;
    short hasCrossRef = 0;
    short inTag = 0;
    short len = 0;
    byte  buf[300];
    int   count = 1;   /* start at one because fgetc got the first byte */
    byte *lineStart;

	memset(buf, '\0', 300);

	/* advance until we find a number or find EOF */
	while (!isdigit(c = fgetc(fp)) && (c != EOF))
	    {
	    *bytesRead += 1;
	    if (!isspace(c) && (c != 26) && (c != '\n') && (c != '\r'))
		{
		printf("ERROR 206 occured at position %ld\n", ftell(fp));
		ged_error(206, NULL);
		}
	    }
	if (ferror(fp))
	    ged_error(101, NULL);

	if ((startLevel == 0) && (c == '0'))
	    {
	    ungetc(c, fp);
	    *status = MORE_RECORDS;
	    return(0);
	    }

	if (c != EOF)
	    {
	    buf[0] = (byte) c;
	    *bytesRead += 1;
/*	    while (((c = fgetc(fp)) != EOF) && (c != '\n') && (c != '\r'))
	        {
                if (ferror(fp))
                    ged_error(103, NULL);
		*bytesRead += 1;
                buf[x++] = c;
		}
	    while (((c = fgetc(fp)) != EOF) && (c == '\n') && (c == '\r'))
	        *bytesRead += 1;
*/
	    fscanf(fp, "%300[^\n\r]%*[\n\r]", &buf[1]);
	    if (ferror(fp))
		ged_error(103, NULL);
	    }
	/* get the number          */
	while (isdigit(c))
	    {
	    levelRead = 1;
	    level = (level * 10) + (int)(c - '0');
	    c = buf[count++];
	    *bytesRead += 1;
	    }

	/* Advance the pointer until we are past white space         */
	while ((c == '\t') || (c == ' '))
	    {
	    *bytesRead += 1;
	    c = buf[count++];
	    }
	lineStart = &buf[count - 1];

	if (c == '@')
	    {
	    hasCrossRef = 1;
            *bytesRead += 1;
            c = buf[count++];
            }
        else if (c != EOF)
            inTag = 1;

        /* Advance the pointer until we are at the end of the line         */
        while ((c != '\0') && (c != '\n') && (c != '\r') && (c != EOF))
            {
            if (hasCrossRef)
                {
		if (c == '@')
                    {
                    hasCrossRef = 0;

                    /* Advance the pointer past any tabs and spaces */
                    while ((c == '\t') || (c == ' '))
                        {
                        *bytesRead += 1;
                        c = buf[count++];
                        }
                    inTag = 1;
                    len = 0;
		    }
                else
                    {
                    len++;
                    if ((c < 32) || (c > 127))
                        ged_error(201, NULL);
                    if (len > MAX_CROSSREF_LEN)
                        ged_error(202, NULL);
                    }
                }
            else if (inTag)
                {
		if (isspace(c))
		    inTag = 0;
                else
                    {
                    len++;
                    if ((c < 32) || (c > 127))
                        ged_error(203, NULL);
                    if (len > MAX_TAG_LEN)
                        ged_error(204, NULL);
                    }
                }
            *bytesRead += 1;
	    c = buf[count++];
	    }
        if (hasCrossRef)
            ged_error(205, NULL);
        if ((c == '\n') || (c == '\r'))
            buf[count - 1] = '\0';
        while (c != '\0')
            {
            *bytesRead += 1;
            c = buf[count++];
            }
        if ((level <= startLevel) && (levelRead))
	    {
#ifdef NON_ANSI
            fseek(fp, -*bytesRead, 1);
#else
            fseek(fp, -*bytesRead, SEEK_CUR);
#endif
            if (ferror(fp))
                ged_error(108, NULL);
            *status = MORE_RECORDS;
            }
        if (feof(fp))
            *status = LAST_RECORD;
	if (!levelRead)
	    *status = END_OF_FILE;
        *node = ged_copy_node(lineStart, NULL, NULL);
        return(level);
    }

NODE * ged_read_nodetree(fp, status)
    FILE     *fp;
    short     *status;
    {                   /*!end!*/
    int   level, prev;
    int   startLev = 0;
    int   bytesRead = 0;
    NODE *root;
    NODE *node;
    NODE *tmpNode;
    int x;

        if (!fp)
            return(NULL);
        *status = -1;
        prev = startLev = ged_read_node(fp, -1, status, &bytesRead, &node);
        root = tmpNode = node;
        while ((*status != LAST_RECORD) && (*status != END_OF_FILE) &&
	       ((level = ged_read_node(fp, startLev, status, &bytesRead, &node))
				   > startLev))
            {
            if ((prev < level) && ((level - prev) != 1))
                {    /* not next child of prev      */
                *status = MISSING_LEVEL;
                }
            else
                {
                if (prev < level)
                    tmpNode = ged_connect_child(tmpNode, node, -1);
                else
		    {
		    for (x = prev - level; x; x--)
                        tmpNode = ged_get_parent(tmpNode);
                    tmpNode = ged_connect_sibling(tmpNode, node, -1);
                    }
                prev = level;
                }
            bytesRead = 0;
            }
        return(root);
    }
