/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedset.c_v   1.6   21 Oct 1991 08:58:12   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedset.c"
*!global paths!
*   gedcom\library\gedset.c
*   gedcom\all\gedset.c
*!end!
*
*   FILE NAME: GEDSET.C
*
*   DESCRIPTION:
*       This file contains functions for modifying the lines of nodes.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedset.c_v  $
 * 
 *    Rev 1.6   21 Oct 1991 08:58:12   fhdodj
 * Changed char to be byte.
 * 
 *    Rev 1.5   26 Sep 1991 15:54:04   fhdodj
 * Made fixes in a couple of functions to loops weren't right, and a comparison
 * was backwards.
 *
 *    Rev 1.4   26 Sep 1991 10:53:46   fhdodj
 * ged_set_ functions now only allocate memory if the changed item is longer
 * than the old.
 *
 *    Rev 1.3   28 Jun 1991 15:02:10   fhdkrf
 * Added keywords for PolyDoc
 *
 *    Rev 1.2   15 Jan 1991 15:06:26   odj
 * In ged_set_value and ged_set_tag changed ged_get_value to be
 * ged_get_value_raw.
 *
 *    Rev 1.1   15 Jan 1991 11:17:10   odj
 * If ged_set_value is given a NULL string for it's new value, the space is
 * which separates the tag from the value is also removed now.
 *
 *    Rev 1.0   20 Dec 1990 09:03:20   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/********************************************************************
*!name!
*    ged_set_line()
*!1!
*
*        NAME: ged_set_line
*
*        DESCRIPTION:
*            Sets node->line to be the line passed in.
*
*        RETURN VALUE:
*            A pointer to the new line, or NULL if an error occurs.
*
*        CALLS: ged_alloc_pool, ged_get_pool
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_set_line(node, line)
    NODE *node;
    byte *line;
    {                        /*!end!*/
    POOL *pool = ged_get_pool();
    byte *nodeLine = ged_get_line(node);
    int nodeLineLen = strlen(nodeLine);
    int lineLen = strlen(line);

        if (!node || !pool || !line)
            return(NULL);
        if (nodeLineLen < lineLen)
            {
            nodeLine = node->line = (*(pool->ged_alloc_pool))
                                                 ((unsigned long)lineLen + 1);
            if (!node->line)
                return(NULL);
            }
        strcpy(nodeLine, line);
        node->length = nodeLineLen;
        return(nodeLine);
    }
/**/
/********************************************************************
*!name!
*    ged_set_tag()
*!1!
*
*        NAME: ged_set_tag
*
*        DESCRIPTION:
*            Allocates memory for a new line. Keeps the old value and
*            puts it and the new tag in node->line.
*
*        RETURN VALUE:
*            A pointer to the new line.
*
*        CALLS: ged_get_xref, ged_get_tag, ged_get_value,
*               ged_alloc_pool
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_set_tag(node, tag)
    NODE *node;
    byte *tag;
    {                        /*!end!*/
    byte *value,
         *xref,
         *oldTag,
         *temp;
    POOL *pool = ged_get_pool();
    int   tagLen = 0;
    int   nodeTagLen = 0;

        temp = oldTag = ged_get_tag(node);
        xref = ged_get_xref(node);
        value = ged_get_value_raw(node);
        if (!node || !tag || !oldTag || !value)
            return(NULL);
        while (*temp && !isspace(*temp))
            {
            nodeTagLen++;
            temp++;
            }
        temp = tag;
        while (*temp && !isspace(*temp))
            {
            tagLen++;
            temp++;
            }
        if (tagLen <= nodeTagLen)
            {
            temp = oldTag;
            while (*temp++ = *tag++)
                ;
            }
        if (tagLen > nodeTagLen)
            {
            if (!pool)
                return(NULL);
            if (xref)
                *(oldTag-1) = '\0';
            temp = node->line = (*(pool->ged_alloc_pool))
                                ((unsigned long)strlen(value) + strlen(tag) +
                                                (xref ? strlen(xref) : 0) + 3);
            if (!temp)
                return(NULL);
            if (xref)
                {
                while (*temp++ = *xref++)
                    ;
                *(temp - 1) = ' ';
                }
            while (*temp++ = *tag++)
                ;
            }
        if (*value != '\0')
            *(temp - 1) = ' ';
        if (tagLen != nodeTagLen)
            {
            memcpy(temp, value, strlen(value) + 1);
            node->length = strlen(node->line);
            }
        return(node->line);
    }
/**/
/********************************************************************
*!name!
*    ged_set_value()
*!1!
*
*        NAME: ged_set_value
*
*        DESCRIPTION:
*            allocates memory for a new line keeps the old tag and
*            puts it and the new value in node->line.
*
*        RETURN VALUE:
*            returns a pointer to the new value in the line.
*
*        CALLS: ged_get_value, ged_get_line, ged_alloc_pool
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_set_value(node, value)
    NODE *node;
    byte *value;
    {                        /*!end!*/
    byte *old_value = ged_get_value_raw(node),
         *start = ged_get_line(node),
         *line;
    POOL *pool = ged_get_pool();
    int   value_len;
    int   old_value_len;

        if (!node || !value || !start)
            return(NULL);
        value_len = strlen(value);
        old_value_len = strlen(old_value);
        if (value_len <= old_value_len)
            strcpy(old_value, value);
        else
            {
            if (!pool)
                return(NULL);
            if (old_value && (*old_value != '\0'))
                *(old_value - 1) = '\0';
            line = node->line = (*(pool->ged_alloc_pool))
                        ((unsigned long)(value_len + strlen(start) + 2));
            if (!line)
                return(NULL);
            while (*line++ = *start++)
                ;
            if (*value == '\0')
                *(line - 1) = '\0';
            else
                {
                *(line - 1) = ' ';
                strcpy(line, value);
                }
            }
        node->length = strlen(node->line);
        return(node->line);
    }
/**/
/********************************************************************
*!name!
*    ged_set_xref()
*!1!
*
*        NAME: ged_set_xref
*
*        DESCRIPTION:
*            Allocates memory for a new line. Keeps the old value and
*            tag, and puts the new xref in node->line.
*
*        RETURN VALUE:
*            A pointer to the new line.
*
*        CALLS: ged_get_tag, ged_alloc_pool
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_set_xref(node, xref)
    NODE *node;
    byte *xref;
    {                        /*!end!*/
    byte *line = ged_get_tag(node),
         *old_xref = ged_get_xref(node),
         *temp;
    POOL *pool = ged_get_pool();
    int   old_xref_len = 0;
    int   xref_len = 0;

        if (!line || !xref || !node)
            return(NULL);
        temp = old_xref;
        if (temp)
            while(*temp && !isspace(*temp))
                {
                temp++;
                old_xref_len++;
                }
        else
            old_xref_len = 0;
        xref_len = strlen(xref);
        if (xref_len <= old_xref_len)
            {
            temp = old_xref;
            while (*temp++ = *xref++)
                ;
            *(temp - 1) = ' ';
            }
        if (xref_len < old_xref_len)
            memcpy(temp, line, strlen(line) + 1);
        else if (xref_len > old_xref_len)
            {
            if (!pool)
                return(NULL);
            temp = node->line = (*(pool->ged_alloc_pool))
                              ((unsigned long)strlen(line) + strlen(xref) + 2);
            if (!temp)
                return(NULL);
            while (*temp++ = *xref++)
                ;
            *(temp - 1) = ' ';
            strcpy(temp, line);
            }
        node->length = strlen(node->line);
        return(node->line);
    }

