/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedwrite.c_v   1.1   30 Nov 1992 09:16:48   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedwrite.c"
*!global paths!
*   gedcom\library\gedwrite.c
*   gedcom\all\gedwrite.c
*!end!
*
*   FILE NAME: GEDWRITE.C
*
*   DESCRIPTION:
*       This file contains functions for writing to files.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedwrite.c_v  $
 * 
 *    Rev 1.1   30 Nov 1992 09:16:48   fhdodj
 * Fixed problem in ged_sprintf_line where limit was not always correctly
 * updated.
 * 
 *    Rev 1.0   28 Jul 1992 09:33:02   fhdodj
 * Initial revision.
 * 
 *    Rev 1.12   03 Mar 1992 09:44:54   fhdodj
 * Replaced fpos with -bytesRead in NON_ANSII part of ged_read_line.
 * 
 *    Rev 1.11   03 Mar 1992 09:35:14   fhdodj
 * Removed fflush and ftell from file.
 * 
 *    Rev 1.10   21 Oct 1991 09:06:44   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.9   09 Aug 1991 10:24:24   fhdodj
 * Changed condition in ged_read_tree so that LAST_RECORD is now returned.
 * 
 *    Rev 1.8   26 Jul 1991 13:31:26   fhdodj
 * Fixed status return from ged_read_line and ged_read_level.  Didn't return
 * LAST_RECORD correctly.
 * 
 *    Rev 1.7   28 Jun 1991 14:08:10   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.6   25 Jun 1991 09:04:14   fhdodj
 * Fixed functions ged_connect_child and ged_connect_sibling.  They were 
 * attaching nodes in the wrong place when given an argument other than -1.
 * 
 *    Rev 1.5   18 Jun 1991 13:39:56   odj
 * Added check in ged_read_line so we dont get an error for invalid character
 * when there is a carriage return or newline.
 * 
 *    Rev 1.4   18 Jun 1991 11:08:12   odj
 * Changed error number ranges.
 * 
 *    Rev 1.3   17 Jun 1991 16:03:00   odj
 * Added IO status checks.  Added calls to ged_error() function.  Also added
 * checking in ged_read_line function for invalid tags and cross references
 * being read.  Changed arguments to ged_read_level() function so that status is
 * now being checked in this function also.
 * 
 *    Rev 1.2   25 Apr 1991 10:06:18   odj
 * changed ged_fprintf() to output a carriage return linefeed insteadof just a 
 * linefeed.
 * 
 *    Rev 1.1   14 Feb 1991 15:02:42   odj
 * void is not allowed by some non ansi compilers (e.g. the CYBER). so I 
 * changed void to be char for non ansi compilers.
 * 
 *    Rev 1.0   20 Dec 1990 08:59:48   odj
 * Initial revision.
***********************************************************************/
#include "gedcom.h"

/**/
/********************************************************************
*!name!
*    ged_fprintf_line()
*!1!
*
*        NAME: ged_fprintf_line
*
*        DESCRIPTION:
*            Writes a line to the file pointed to by fp.
*
*        RETURN VALUE:
*            None.
*
*        CALLED BY: ged_tree_to_file
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_fprintf_line(level, node, tfp, unreferencedArg2)
    int   level;
    NODE *node;
#ifdef NON_ANSI
    byte *tfp;
    byte *unreferencedArg2;
#else
    void *tfp;
    void *unreferencedArg2;
#endif
    {			/*!end!*/
    FILE *fp = (FILE *) tfp;

        if (node->line)
            fprintf(fp, "%d %s\r\n", level, node->line);
        if (ferror(fp))
            ged_error(109, NULL);
        return(1);
    }
/**/
/********************************************************************
*!name!
*    ged_sprintf_line()
*!1!
*
*        NAME: ged_sprintf_line
*
*        DESCRIPTION:
*            Writes a line to gedBuf
*
*        RETURN VALUE:
*            None.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
int ged_sprintf_line(level, node, tempGedBuf, tempLimit)
    int       level;
    NODE     *node;
#ifdef NON_ANSI
    byte     *tempGedBuf;
    byte     *tempLimit;
#else
    void     *tempGedBuf;
    void     *tempLimit;
#endif
    {			/*!end!*/
    byte **gedBuf = (byte **)tempGedBuf;
    byte *ptr = *gedBuf;
    unsigned *limit = tempLimit;

        if (node->line && ((*limit - node->length + 5) > 0))
            {                                    /* ^ level len plus space */
            sprintf(ptr, "%d %s\n", level, node->line);
            while (*ptr != '\0')
                {
		*limit--;
                ptr++;
		}
                ptr++;
            *gedBuf = ptr;
            }
        return(1);
    }
/**/
/********************************************************************
*!name!
*    ged_tree_to_file()
*!1!
*
*        NAME: ged_tree_to_file
*
*        DESCRIPTION:
*            Writes the input tree to the file pointed to by fp.
*
*        RETURN VALUE:
*            None.
*
*        CALLS: ged_apply_tree, ged_fprintf_line
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
void ged_tree_to_file(tree, fp, level)
    NODE    *tree;
    FILE    *fp;
    unsigned level;
    {			/*!end!*/

        ged_apply_tree(tree, level, 0, ged_fprintf_line, fp, NULL);
    }

/********************************************************************
*!name!
*    ged_tree_to_ged()
*!1!
*
*        NAME: ged_tree_to_ged
*
*        DESCRIPTION:
*            Writes the input tree to buffer gedBuf. limit is the size
*            of gedBuf.
*
*        RETURN VALUE:
*            Returns the address to the position in the buffer where
*            we finished writing.
*
*        CALLS: ged_apply_tree, ged_sprintf_line
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
byte * ged_tree_to_ged(tree, gedBuf, limit, level)
    NODE    *tree;
    byte    *gedBuf;
    unsigned limit;
    unsigned level;
    {			/*!end!*/

        ged_apply_tree(tree, level, 0, ged_sprintf_line, &gedBuf, &limit);
        return(gedBuf);
    }
