
/*****************************************************************************
*
*   FILE:       MAKEGED.c
*   AUTHOR:     Brian L. Jensen
*   DATE:       Oct 1989
*   RELEASE:    1.0 - Oct 1989
*
*      (c) 1988,1989 Corporation of the President of the Church of Jesus Christ
*      Copyright   of Latter-day Saints.
*
*      All rights reserved.  Unauthorized reproduction of this software is
*      prohibited and is in violaton of United States copyright laws.
*
*   DESCRIPTION:
*       This is the main driver for the makeged utility which converts
*       fixed format records into GEDCOM.
*
*   CHANGE HISTORY
*       Date    Who         Description of Change
*       ----    ----        ---------------------
*     3/22/90   BLJ     Fixed some bugs and improved for SSN data.
******************************************************************************/
#if cyber
#include <ctype_h>
#include "setjmp_h"
#include ".AIMMGR.AIM.H.AIMDEFS_H"
byte *strstr();
byte *malloc();
#else
#include "setjmp.h"
#include "AIMDEFS.H"
#endif

/* Routines in MAKEGED.c */
#if defined( LINT_ARGS )
        int  cdecl main( int, byte ** );
 static void printMenu( void );
 static void printStats( void );
 static int  createGed( int, byte * );
 static void outputLine( int, byte *, byte * );
 static void getString( int, int, byte * );
 static void checkForDitto( byte *, byte * );
        int  walkTree( NODE *, int, int, int ( * )() );
        void GEDhook1( byte *, byte * );
        void GEDhook2( byte *, byte * );
        void GEDhook3( byte *, byte * );
        void GEDhook4( byte *, byte * );
        void strDecap( byte *);
        void GEDhook5( byte *, byte * );
        void GEDhook6( byte *, byte * );
        void GEDhook7( byte *, byte * );
        int  ERR_EXIT( byte *, int );
#else
        int  cdecl main();
 static void printMenu();
 static void printStats();
 static int  createGed();
 static void outputLine();
 static void getString();
 static void checkForDitto();
        int  walkTree();
        void GEDhook1();
        void GEDhook2();
        void GEDhook3();
        void GEDhook4();
        void strDecap();
        void GEDhook5();
        void GEDhook6();
        void GEDhook7();
#endif

 NODE *templet = NULL;      /* Pointer to GEDCOM templet */
 byte format = 0;           /* 0 = ASCII else EBCDIC */
 byte *recBuf;              /* Holds a single record from input file */
 long recCnt = 0L;          /* Count of records processed */
 int outFd = 0;             /* File Pointer for output GEDCOM file */
 int recLen = 0;            /* Length of the input file records */
 byte famHeadNum[12];       /* Used for GEDhook #1 */
 long curFilePos = 0L;      /* Gives a beginning position of the current record*/

#define TREE_SIZ        8192
#define MAX_LINE_LEN    1024

/** The structure if used for the ditto function  **/
struct DitArray
    {
    byte str[MAX_LINE_LEN];     /* Will save a line to use latter */
    }  dittoArray[6];

/**  The array of strings is used by emitLine() for GEDCOM buffer output  **/
 static byte *levelStr[] = { "\n0 ",
                             "\n1 ", "\n2 ", "\n3 ", "\n4 ", "\n5 ",
                             "\n6 ", "\n7 ", "\n8 ", "\n9 ", "\n10 ",
                             "\n11 ", "\nMAX_LEVEL_ERR "
                           };

 extern int jumpArray[ ][ _JBLEN ];  /* ERRORLIB.C */
 extern int jumpPos;                 /* ERRORLIB.C */

/**  MACRO's used in MAKEGED.c  **/
int ERR_EXIT(s,n)
    byte *s;
    int n;
    {
    printf("\n==================  ERROR  ========================\n");
    if ( n ) printf("  %s %d\n", s, n );
    else printf("  %s \n", s );
    printf("==================  ERROR  ========================\n");
    exit(0);
    }

void xact( handle )
    NODE *handle;
    {
    }

/**/
/******************************************************************************
*
*   NAME    main()
*
*   DESCRIPTION
*       The entry point to makeged
*
******************************************************************************/
int cdecl main( argc, argv )
    int argc;
    byte *argv[];
    {
    byte treeBuf[ TREE_SIZ ];   /* Buffer to hold the GEDCOM templet */
    byte option, *ptr;
    int  rc, argNum, fd = 0;
    int createGed();           /* Function which creates a GEDCOM line */
    int status = SUCCESS;
    int errorStatus = 0;
    int procNum = 0;
    FILE *fp;

        *famHeadNum = '\0';  /* GEDhook1 */
        if (argc == 1)  /* No arguments, copy standard input */
            printMenu();

        /**  Check for a long jump and Set up the AIM system  **/
        clearJump();
        if ( (errorStatus = setjmp( &jumpArray[ jumpPos++][0] ) ) )
            ERR_EXIT(" AIM error number =", errorStatus);

        startup( "testdef", NULL );

        /**  Parse all input options  **/
        argNum = 1;
        ptr = argv[argNum];
        while ( *ptr == '-' || *ptr == '/' )
            {
            argNum++;
            ptr++;              /* Point past the '-' */
            option = *ptr++;
            switch (toupper(option))
                {
                case 'A' :  /*  Input is in ASCII format (DEFAULT)  */
                    break;
                case 'E' :  /*  Input is in EBCDIC format */
                    format++;
                    break;
                case 'N' :  /* Records to Process */
                    if ((procNum = atoi( ptr )) <= 0 )
                        ERR_EXIT(" Invalid Number of Records to Process",procNum);
                    break;
                case 'R' :  /* Record Length */
                    if ((recLen = atoi( ptr )) <= 0 )
                        ERR_EXIT("  Invalid Record Length", recLen);
                    break;
                case 'T' :  /* The file containing the GEDCOM templet */
                    if ((fp = fopen( ptr, "r")) == NULL)
                        ERR_EXIT(" Cannot open file GEDCOM templet file", 0);

                    templet = readGedTree( fp, treeBuf, TREE_SIZ, &rc );
            /**        printf("\n ----  GEDCOM Templet  ----\n");
              *      PRINT_TREE( templet, 0, 0 );
              *      printf(" ----  **************  ----\n\n");
              **/
                    if ( rc != LAST_RECORD )
                        ERR_EXIT("  readGedTree Failure on GEDCOM templet", rc);
                    fclose(fp);
                    break;
                case 'O' :  /* Open the output GEDCOM file */
                    if (( outFd = open( ptr, RDWR_PARMS )) == -1 )
                        {
                        if (( outFd = open( ptr, CREATE_PARMS )) == -1 )
                            ERR_EXIT(" Unable to Open output GEDCOM file ", 0 );
                        }
                    break;
                case 'L' :  /* Turn on AIM logging */
                    if ( *ptr != 'F' )
                        SETUP_LOG("GED_log", 1 );  /* output to screen */
                    else
                        SETUP_LOG("GED_log", 2 );  /* output to file */
                    break;
                default  :  ERR_EXIT(" Invalid makeGed Option ", 0 );
                }
            ptr = argv[argNum];
            }

        /**  Open the input Fixed format record file  **/
        if ( !ptr || (fd = open( ptr, READ_ONLY_PARMS )) == -1 )
            ERR_EXIT("  Unable to Open Input Record File. ", 0 );

        /**  Integrity checks  **/
        if ( ! templet ) ERR_EXIT("  No Input GEDCOM Templet ", 0 );
        if ( ! fd )      ERR_EXIT("  No Input Record File ", 0 );
        if ( ! outFd )   ERR_EXIT("  No Output GEDCOM File ", 0 );
        if ( ! recLen )  ERR_EXIT("  No Record Length Given ", 0 );

        /** Allocate buffer for a record, with safty zone **/
        if ( (recBuf = malloc( recLen + 48 )) == NULL )
            ERR_EXIT("   malloc() failure ", 0 );

        /**  Loop for each record  **/
        while ( (read( fd, recBuf, recLen ) == recLen) && status == SUCCESS )
            {
            /**  Process this record  **/
            LOG1(" Record "); LOG_NUM( recCnt, " read \n");
            status = walkTree( templet, 0, 0, createGed );
            recCnt++;
            curFilePos += recLen;  /* So the hooks can print present pos */

            if ( procNum && recCnt >= procNum )
                break;
            }

        printStats();
        close(fd);
        close(outFd);
        free( recBuf );
        shutDown();
    exit(0);
    }

/**/
/****************************************************************************
*
*   NAME    printMenu
*
*   DESCRIPTION:
*       prints the options available for the IGI_GEN program
*
**************************************************************************/
static void printMenu()
    {
    printf(" MAKEGED: [-options]  INPUT_TAPE_FILE\n");
    printf("   -a       - Input tape in ASCII format. (Default)\n");
    printf("   -e       - Input tape is in EBCDIC format\n");
    printf("   -n##     - Number of records to process. (Default = ALL \n");
    printf("   -r##     - Record size in input file (Default = 512)\n");
    printf("   -t[name] - Name of GEDCOM templete file (Required)\n");
    printf("   -o[name] - Name of the output GEDCOM file (Required)\n");
    printf("   -l[F|S]  - Turns on Logging F to GED_LOG File else screen\n");
    exit(0);
    }

/**/
/****************************************************************************
*
*   NAME    printStats
*
*   DESCRIPTION:
*       prints the stats from this run of the MAKEGED program.
*
**************************************************************************/
static void printStats( )
    {
    printf("\n\n\t+---------------------------------------------------+\n");
        printf("\t|           M A K E G E D   Statistics              |\n");
        printf("\t+---------------------------------------------------+\n\n");

        printf("\t        Records Read             = %d\n", recCnt );

        printf("\t+---------------------------------------------------+\n\n");
    }

/**/
/****************************************************************************
*
*   NAME    createGed
*
*   DESCRIPTION:
*       This routine will take the input GEDCOM templet line and read the
*       instruction and then apply them to creating a single GEDCOM line.
*       By reading the needed record info form the input record file.
*
*   RETURN VALUE:
*       SUCCESS;
*
**************************************************************************/
static int createGed( level, handleLine )
    int level;      /* Current level of the GEDCOM templet Node */
    byte *handleLine;     /* GEDCOM templet line */
    {
    byte *info, infoLine[200];
    byte tLine[MAX_LINE_LEN];    /* Temperary buffer to hold output line */
    byte tag[20];   /* Tag of the GEDCOM templet line */
    byte *ptr;
    int pos, len;

        tLine[0] = '\0';    /* Clear the line */
        strcpy( infoLine, handleLine );
        info = infoLine;

        /* Get the templet tag */
        copyWord( tag, &info );

        LOG3("  createGed() tag=", tag, " value="); LOG2( info, "\n");

        /** If NO more values on the line then just output the TAG **/
        if ( ! info )
            {
            outputLine( level, tag, "" );
            return( SUCCESS );
            }

        /**  Determine the Processing Options on the Line  **/
        if ( !strncmp( info, "P=", 2 ) )   /* P=position */
                {
                info += 2;  /* Skip the 'P=' */
                pos = atoi( info );
                if ( pos <= 0 || pos > recLen )
                    ERR_EXIT("  Invalid Field Position Given ", pos );
                pos--;  /* make position zero based */

                /**  Check for a length variable  **/
                info = strstr( info, "L=" );
                if ( !info )
                    len = 1;
                else
                    {
                    info += 2;
                    if (( len = atoi( info )) <= 0 || len > MAX_LINE_LEN )
                        ERR_EXIT("  Invalid Field Length Given ", len );
                    }
                getString( pos, len, tLine );
                checkForDitto( info, tLine );
              /*if ( tLine[0] != '\0')*/  /* This could create BAD gedcom, VISIT */
                /* clipLine() needs to be fixed it leaves ONE space */
                if ( tLine[0] != ' ' || strlen(tLine) > 1 ) /*VISIT*/
                    outputLine( level, tag, tLine );
                }
        else if ( !strncmp( info, "GEDhook", 7 ) ) /* call a GEDhook[1- 5] */
                {
                LOG1(" calling a GEDhook\n");
                ptr = skipWord( info );    /* Skip to any parameters */
                if ( !strncmp( info, "GEDhook1", 8 ) )
                    GEDhook1( ptr, tLine );
                else if ( !strncmp( info, "GEDhook2", 8 ) )
                    GEDhook2( ptr, tLine );
                else if ( !strncmp( info, "GEDhook3", 8 ) )
                    GEDhook3( ptr, tLine );
                else if ( !strncmp( info, "GEDhook4", 8 ) )
                    GEDhook4( ptr, tLine );
                else if ( !strncmp( info, "GEDhook5", 8 ) )
                    GEDhook5( ptr, tLine );
                else if ( !strncmp( info, "GEDhook6", 8 ) )
                    GEDhook6( ptr, tLine );
                else if ( !strncmp( info, "GEDhook7", 8 ) )
                    GEDhook7( ptr, tLine );
                else
                    ERR_EXIT("  Invalid GEDhook function ", 0 );
                /**  Now output the line  **/
               /*if ( *tLine )*/       /* This could create BAD gedcom, VISIT */
                if ( tLine[0] != ' ' || strlen(tLine) > 1 ) /*VISIT*/
                    outputLine( level, tag, tLine );
                }
        else        /* Output the templet line as is */
                {
                outputLine( level, tag, info );
                }

    return(SUCCESS);
    }

/**/
/****************************************************************************
*
*   NAME    outputLine
*
*   DESCRIPTION:
*       This routine will take level, tag, and line and write it to the
*       output GEDCOM file.
*
**************************************************************************/
static void outputLine( level, tag, line )
    int level;      /* Level of the GEDCOM line to output */
    byte *tag;      /* TAG of the GEDCOM line to output */
    byte *line;     /* Line to output */
    {
    int len;

        LOG3("    Outputing line =>", line, "<\n");
        /** Write out the Level Number **/
        len = strlen( levelStr[level] );
        if ( write( outFd, levelStr[level], len ) != len )
            ERR_EXIT(" Unable to write GEDCOM level number ", 0 );

        /* Write out the tag **/
        strcat( tag, " " );     /* Add space after the tag */
        len = strlen( tag );
        if ( write( outFd, tag, len ) != len )
            ERR_EXIT(" Unable to write GEDCOM Tag ", 0 );

        /* Write out the Line **/
        strcat( line, "\r");
        len = strlen( line );
        if ( write( outFd, line, len ) != len )
            ERR_EXIT(" Unable to write GEDCOM Line ", 0 );
    }
/**/
/****************************************************************************
*
*   NAME    getString
*
*   DESCRIPTION:
*       This routine will take the input position and length and read the
*       input record file for the desired info and then that info will
*       be output to the GEDCOM file by a call to outputLine();
*
*       After the line is read then the line will have any ending white spaces
*       remove.
*
*       This routine has the smarts to handle either ASCII of EBCDIC format.
*
**************************************************************************/
static void getString( pos, len, line )
    int pos;        /* Position in the record for this field */
    int len;        /* length of the field */
    byte *line;     /* area to copy the line */
    {
    byte *strPtr;           /* Pointes to the first of this field */

        strPtr = &recBuf[pos];

        /*  Get the Line  */
        strncpy( line, strPtr, len );

        *(line + len) = '\0';

        /* If in EBCDIC convert to ASCII */
        if ( format )   /* 0 = ASCII else EBCDIC */
            ebcToAscStr( line, len );

        /** Null terminate **/
        clipLine( line );
    LOG3("    getString >", line, "<\n");
    }

/**/
/****************************************************************************
*
*   NAME    checkForDitto
*
*   DESCRIPTION:
*       This routine will determine if the DITTO option is being used on the
*       current line. If it is then the line will be check to see if is has
*       a value.  If a value is present it will be output and the value
*       will be saved.  If no value the old stored value will be returned.
*
**************************************************************************/
static void checkForDitto( info, line )
    byte *info;     /* Templet line */
    byte *line;    /* Addresss of line Containing the current line */
    {
    int dittoNum;

        /** Determine the Ditto number **/   /** This can be done better **/
        if ( strstr( info, "DITTO5" ) )
            dittoNum = 5;
        else if ( strstr( info, "DITTO4" ) )
            dittoNum = 4;
        else if ( strstr( info, "DITTO3" ) )
            dittoNum = 3;
        else if ( strstr( info, "DITTO2" ) )
            dittoNum = 2;
        else if ( strstr( info, "DITTO1" ) )
            dittoNum = 1;
        else
            return;     /* No Ditto Option Used */

        if ( *line > ' ' )    /* You have a new value */
            {
            strcpy( dittoArray[dittoNum].str, line );
            }
        else    /* No Value, so use the old value */
            {
            strcpy( line, dittoArray[dittoNum].str );
            }

    LOG3(" DITTO line =", line, "..\n");
    }

/**/
/****************************************************************************
*
*   NAME    walkTree
*
*   DESCRIPTION:
*       This is a GREAT general purpose tree processing routine. It will visit
*       every node of the tree and those with a length it will call the
*       function passed in.  The function needs to accept the following
*       parameters:
*           int  level;  * current level of this node *
*           byte *line;  * pointer to this handles line *
*       The status of the function will be checked and as long as it is
*       SUCCESS(1) it will continue. Any other value will cause processing
*       to stop and that value will be returned.
*
*   RETURN VALUE:
*       The value of the passed in function.
*
**************************************************************************/
int walkTree( rootHandle, startLevel, forestFlag, function )
    NODE *rootHandle;   /* Root Node of tree to process */
    int startLevel;     /* The starting Level number */
    int forestFlag;     /* Indicates that a forest will be handled */
    int (*function)( );  /* Function to be called on every line */
    {
    NODE *handle;
    int level = startLevel;
    int rc;

        handle = rootHandle;
        while ( handle )
            {
            if ( handle->length )
                {
                if (( rc = (*function)( level, handle->line)) != SUCCESS )
                    return(rc);
                }
            while ( handle->child )
                {
                level++;
                handle = handle->child;
                if ( handle->length )
                    {
                    if (( rc = (*function)( level, handle->line)) != SUCCESS )
                        return(rc);
                    }
                }
            /* Un-nest handle by restoring parent */
            while ( (!handle->sibling) &&  handle != rootHandle )
                    {
                    handle = handle->parent;
                    level--;
                    }
            /* check for forests : a sibling of the input rootHandle */
            if ( handle == rootHandle )
                {
                if (forestFlag)
                    rootHandle = handle->sibling;
                else
                    break;
                }
            handle = handle->sibling;
            }
    return( SUCCESS );
    }


/**/
/****************************************************************************
*
*   NAME    GEDhook1    Korea War dead Military branch and component
*
*   DESCRIPTION:
*       This hook will expand the military branch and component into the
*       record.
*
**************************************************************************/
void GEDhook1( info, line )
    byte *info;
    byte *line;
    {

        switch (*(recBuf))
            {
            case 'A':
                switch (*(recBuf + 61))
                    {
                    case 'G':
                        strcpy( line, "Army National Guard" );
                        break;
                    case 'R':
                        strcpy( line, "U S Army" );
                        break;
                    case 'V':
                        strcpy( line, "U S Army Reserve" );
                        break;
                    case 'Y':
                        strcpy( line, "AUS" );
                        break;
                    default:
                        strcpy( line, "U S Army" );
                    }
                break;
            case 'N':
                switch (*(recBuf + 61))
                    {
                    case 'G':
                        strcpy( line, "NGUS" );
                        break;
                    case 'R':
                        strcpy( line, "U S Navy" );
                        break;
                    case 'V':
                        strcpy( line, "U S Navy Reserve" );
                        break;
                    case 'Y':
                        strcpy( line, "USNSS" );
                        break;
                    default:
                        strcpy( line, "U S Navy" );
                    }
                break;
            case 'M':
                switch (*(recBuf + 61))
                    {
                    case 'R':
                        strcpy( line, "U S Marine Corps" );
                        break;
                    case 'V':
                        strcpy( line, "U S Marine Corps Reserve" );
                        break;
                    case 'Y':
                        strcpy( line, "USMCSS" );
                        break;
                    default:
                        strcpy( line, "U S Marine Corps" );
                    }
                break;
            case 'F':
                switch (*(recBuf + 61))
                    {
                    case 'G':
                        strcpy( line, "Air Force National Guard" );
                        break;
                    case 'R':
                        strcpy( line, "U S Air Force" );
                        break;
                    case 'V':
                        strcpy( line, "U S Air Force Reserve" );
                        break;
                    case 'Y':
                        strcpy( line, "AFUS" );
                        break;
                    default:
                        strcpy( line, "U S Air Force" );
                    }
                break;
            case 'C':
                switch (*(recBuf + 61))
                    {
                    case 'R':
                        strcpy( line, "U S Coast Guard" );
                        break;
                    case 'V':
                        strcpy( line, "U S Coast Guard Reserve" );
                        break;
                    default:
                        strcpy( line, "U S Coast Guard" );
                    }
                break;
            default:
                strcpy( line, "Unknown" );
                break;
            }
    }

/**/
static byte *monArray[] = {"   ", "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

/****************************************************************************
*
*   NAME    GEDhook2        Korean War Dead
*
*   DESCRIPTION:
*       This hook will convert KR's date format to the GEDCOM date
*       format.  The format of the KR date is
*           MMDDYYY     example   0905906  ==  5 SEP 1906
*
**************************************************************************/
void GEDhook2( info, line )
    byte *info;     /* D=death date, B=birth date */
    byte *line;     /* Line to add the date to */
    {
    byte temp[ 8 ];
    int mon, day, year;

        if ( *info == 'D' )
            {
            getString( 57, 2, temp );       /* Get the Month */
            mon = atoi( temp );
            getString( 59, 2, temp );       /* Get the Day */
            day = atoi( temp );
            getString( 55, 2, temp );       /* Get the Year */
            year = atoi( temp );
            }
        else  /* Birth Date */
            {
            getString( 89, 2, temp );       /* Get the Month */
            mon = atoi( temp );
            getString( 91, 2, temp );       /* Get the Day */
            day = atoi( temp );
            getString( 87, 2, temp );       /* Get the Year */
            year = atoi( temp );
            }
        /**  First Output the day **/
        if ( day > 31 )
            {
            printf(" ERROR: day > than 31  day=%d curFilePos=%ld\n",
                        day, curFilePos );
            }
        else if ( day != 0 )
            {
            itoa( day, temp, 10 );
            strcpy( line, temp );
            strcat( line, " " );
            }
        /**  Now output the Month **/
        if ( mon < 0 || mon > 12 )
            {
            printf(" ERROR: Invalid Month = %d curFilePos=%ld\n",
                        mon, curFilePos );
            }
        else if ( mon != 0 )
           {   /* Month can be ZERO */
           if ( day != 0 )
               strcat( line, monArray[ mon ] );
           else
               strcpy( line, monArray[ mon ] );
           }
        /**  Now Output the Year **/
        if ( year != 0 )
           {
           itoa( year, temp, 10 );
           ( mon == 0 && day == 0 ) ? strcpy(line, "19") : strcat(line, " 19");
           strcat( line, temp );
           }
    }

/**/
/****************************************************************************
*
*   NAME    GEDhook3        Korean War Dead
*
*   DESCRIPTION:
*       This hook will determine the Cause of death
*
**************************************************************************/
void GEDhook3( info, line )
    byte *info;
    byte *line;
    {

        switch (*(recBuf + 5))
            {
            case '1':
                strcpy(line, "Hostile - Killed in Action - ");
                break;
            case '2':
                strcpy(line, "Hostile - Died of Wounds - ");
                break;
            case '3':
                strcpy(line, "Hostile - Died While Missing - ");
                break;
            case '4':
                strcpy(line, "Hostile - Died While Captured/Interned - ");
                break;
            default:
                break;
            }
        switch (*(recBuf + 93))
            {
            case 'A':
                strcat(line, "Aircraft Loss/Crash at Sea - ");
                break;
            case 'B':
                strcat(line, "Aircraft Loss/Crash Not at Sea - ");
                break;
            case 'C':
                strcat(line, "Vehicle Loss/Crash - ");
                break;
            case 'D':
                strcat(line, "Gunshot or Small Arms Fire - ");
                break;
            case 'E':
                strcat(line, "Artillery/Rocket - ");
                break;
            case 'F':
       strcat(line, "Explosive Device (Grenade, Mine, Booby Trap, etc.) - ");
                break;
            case 'G':
                strcat(line, "Multiple Fragmentation Wounds - ");
                break;
            case 'H':
                strcat(line, "Misadventure - ");
                break;
            case 'I':
                strcat(line, "Drowned/Suffocated - ");
                break;
            case 'J':
                strcat(line, "Burns - ");
                break;
            case 'L':
       strcat(line, "Illness/Disease (Other than Malaria & Hepatitis) - ");
                break;
            case 'M':
                strcat(line, "Malaria");
                break;
            case 'N':
                strcat(line, "Hepatitis");
                break;
            case 'O':
  strcat(line,
         "Heart Attack (Myocardial Infarction, Coronary Thrombosis, etc.) - ");
                break;
            case 'P':
                strcat(line, "Stroke (Cerebrovascular Accident) - ");
                break;
            case 'Q':
                strcat(line, "Suicide - ");
                break;
            case 'R':
                strcat(line, "Accidental Self Destruction - ");
                break;
            case 'S':
                strcat(line, "Intentional Homicide - ");
                break;
            case 'T':
                strcat(line, "Accidental Homicide - ");
                break;
            case 'U':
                strcat(line, "Other Accident - ");
                break;
            case 'V':
                strcat(line, "Other Causes - ");
                break;
            case 'Z':
                strcat(line, "Unknown or Not Reported - ");
                break;
            default:
                break;
            }
        switch (*(recBuf + 94))
            {
            case '1':
                strcat(line, "Fixed Wing Air Casualty - Pilot");
                break;
            case '2':
                strcat(line, "Fixed Wing Air Casualty - Other Aircrew");
                break;
            case '3':
                strcat(line, "Fixed Wing Air Casualty - Non-Aircrew");
                break;
            case '4':
                strcat(line, "Helicopter Air Casualty - Pilot");
                break;
            case '5':
                strcat(line, "Helicopter Air Casualty - Other Aircrew");
                break;
            case '6':
                strcat(line, "Helicopter Air Casualty - Non-Aircrew");
                break;
            case '7':
                strcat(line, "Ground Casualty");
                break;
            case '8':
                strcat(line, "Sea Casualty");
                break;
            case 'A':
                strcat(line, "At Sea");
                break;
            case 'B':
                strcat(line, "Over Ground");
                break;
            default:
                break;
            }
    }

/****************************************************************************
*
*   NAME    GEDhook4        Korean War Dead
*
*   DESCRIPTION:
*       This hook will expand KR to be Korea
*
**************************************************************************/
void GEDhook4( info, line )
    byte *info;
    byte *line;
    {
        if (*(recBuf + 1) == 'K' && *(recBuf + 2) == 'R')
            strcpy( line, "Korea" );
        else
            {
            *line = *(recBuf+ 1);
            *(line + 1) = *(recBuf + 2);
            *(line + 2) = '\0';
            }
    }

/**/
/****************************************************************************
*
*   NAME    strDecap            Moved from STR_STUF.c IGI code.
*
*   DESCRIPTION:
*       Leaves the first letter of a word/name/place to upper case and
*       converts the remaining letters to lower case.

*       Date    Who         Description of Change
*       ----    ----        ---------------------
*     4/19/1988 Scott P.    Added abbreviations to be in upper case.
*     5/11/1988 Scott P.    The first word after '(' is now in upper case.
*     5/26/1988 Scott P.    The first word after '_' is now in upper case.
*     2/06/1989 Scott P.    The first word after '-' is now in upper case.
**************************************************************************/
void strDecap( field )
    byte *field;
    {
        /* The first character better be the start of a word */
        while ( *field != '\0' )
            {
            if (*field == '(')
                field++;            /* Skip left parens */
            field++;        /* Leave the first character as is */
            /* Convert the other characters till a ',' or ' ' or '\0' */
            if ( *field == '.' )
                    {
                    field++;
                    }
            else
                while ( *field != ',' && *field > SPACE )   /* Null & SPACE */
                    {
                    if (*field == '_' || *field == '-')
                        {
                        field++;
                        break;
                        }
                    *field = tolower( *field );
                    field++;
                    }
            while ( *field == SPACE || *field == ',' )
                    field++;
            }
    }

/**/

/****************************************************************************
*
*   NAME    GEDhook5    Korean War Dead
*
*   DESCRIPTION:
*       change 0 to No and 1 to yes.
*
**************************************************************************/
void GEDhook5( info, line )
    byte *info;
    byte *line;
    {
        if (*(recBuf + 103) == '0')
            strcpy(line, "No");
        else
            strcpy(line, "Yes");
    }

static byte *homeState[] = { "Unknown",
 "Alabama",     "Alaska",       "Arizona",  "Arkansas",     "California",
 "Colorado",    "Connecticut",  "Delaware", "District of Colombia", "Florida",
 "Georgia",     "Hawaii",       "Idaho",    "Illinois",     "Indiana",
 "Iowa",        "Kansas",       "Kentucky", "Louisiana",    "Maine",
 "Maryland",    "Massachusetts","Michigan", "Minnesota",    "Mississippi",
 "Missouri",    "Montana",      "Nebraska", "Nevada",       "New Hampshire",
 "New Jersey",  "New Mexico",   "New York", "North Carolina","North Dakota",
 "Ohio",        "Oklahoma",     "Oregon",   "Pennsylvania",
 "Rhode Island","South Carolina","South Dakota","Tennessee","Texas",
 "Utah",        "Vermont",      "Virginia","Washington",
 "West Virginia","Wisconsin","Wyoming", "Puerto Rico", "Virgin Islands",
 "Guam", "Canal Zone", "Other", "America Samoa", "Not Reported"
 };


/****************************************************************************
*
*   NAME    GEDhook6    Korean War Dead
*
*   DESCRIPTION:
*       Expand Home of record State.
*
**************************************************************************/
void GEDhook6( info, line )
    byte *info;
    byte *line;
    {
        if (*(recBuf + 80) == 'P' || *(recBuf + 80) == 'R')
            strcpy(line, homeState[52]);
        else if (*(recBuf + 80) == 'V')
            strcpy(line, homeState[53]);
        else if (*(recBuf + 80) == 'G')
            strcpy(line, homeState[54]);
        else if (*(recBuf + 80) == 'C')
            strcpy(line, homeState[55]);
        else if (*(recBuf + 80) == 'X')
            strcpy(line, homeState[56]);
        else if (*(recBuf + 80) == 'S')
            strcpy(line, homeState[57]);
        else if (*(recBuf + 80) == 'Z')
            strcpy(line, homeState[58]);
        else if (atoi(recBuf + 80))
            strcpy(line, homeState[atoi(recBuf + 80)]);
        else
            *line = '\0';
    }

/****************************************************************************
*
*   NAME    GEDhook7    Korean War Dead
*
*   DESCRIPTION:
*       Expand Race.
*
**************************************************************************/
void GEDhook7( info, line )
    byte *info;
    byte *line;
    {
        if (*(recBuf + 95) == 'C')
            strcpy(line, "Caucasian");
        else if (*(recBuf + 95) == 'I')
            strcpy(line, "American Indian");
        else if (*(recBuf + 95) == 'L')
            strcpy(line, "Malayan");
        else if (*(recBuf + 95) == 'M')
            strcpy(line, "Mongolian");
        else if (*(recBuf + 95) == 'N')
            strcpy(line, "Negro");
        else if (*(recBuf + 95) == 'Z')
            strcpy(line, "Unknown or Not Reported");
        else
            strcpy(line, "Unknown or Not Reported");
    }
