/*  $Id$
 *  
 *  File	alloc.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Memory allocation
 *  Works with	GNU CC 2.4.5
 *		Borland C++ 3.1
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	18/10/93  (Created)
 *  		03/11/93  (Last modified)
 */ 


#include "cbuff.h"


/*----------------------------------------------
 *  Introduction
 *----------------------------------------------
 *
 *  Memory allocation routines.  This uses the standard C library
 *  functions unless __BORLANDC__ is defined.  The functions in
 *  this file are broken if size_t != unsigned long.
 *
 *  Note to developers:  Please forward the appropriate code for
 *  other compilers that have size_t != unsigned long.
 */


/*----------------------------------------------
 *  Definitions
 *----------------------------------------------*/

#ifdef __BORLANDC__
#include <alloc.h>
void *	farmalloc(unsigned long);
void	farfree(void *);
#endif


/*----------------------------------------------
 *  Public Functions
 *----------------------------------------------*/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@node alloc
@deftypefun {void *} alloc (unsigned long @var{n})
Allocates @var{n} bytes of memory and returns a pointer to the first byte.
@end deftypefun
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#ifdef __BORLANDC__
void *
alloc(unsigned long n)
{ return farmalloc(n);
}
#else
void *
alloc(unsigned long n)
{ return malloc(n);
}
#endif

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@node unalloc
@deftypefun void unalloc (void *@var{p})
Returns the memory previously allocated with @code{alloc}.
@end deftypefun
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#ifdef __BORLANDC__
void
unalloc(void *p)
{ farfree(p);
}
#else
void
unalloc(void *p)
{ free(p);
}
#endif


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@node allocCharp
@deftypefun {char *} allocCharp (char *@var{s})
Allocates memory for the @code{char *} contained in @var{s}, and then
copies the contents of @var{s} into the allocated memory.  A pointer to
the first byte of @var{s} is returned.  Note that the length of the
resulting @var{s} should not be modified in order for
@code{unallocCharp} to work.
@end deftypefun
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

char *
allocCharp(char *s)
{ char *t;

  t = alloc(strlen(s)+1);
  strcpy(t, s);
  return t;
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@node unallocCharp
@deftypefun void unallocCharp (char *@var{s})
Reclaims the memory of @var{s}, which was previously allocated by
@code{allocCharp}.
@end deftypefun
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

void
unallocCharp(char *s)
{ unalloc(s);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@node printMemoryAvailable
@deftypefun void printMemoryAvailable (FILE *@var{fd})
Prints a message on the given @var{fd} which tells the user how much
(internal) memory is still available.  This is useful on machines with
little memory (e.g. DOS).  If the environment does not support limited
memory (e.g. Unix) nothing is printed.
@end deftypefun
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

void
printMemoryAvailable(FILE *fd)
{
#ifdef __BORLANDC__
  unsigned long farcoreleft(void);

  fprintf(fd, "Memory still available %lu bytes\n", farcoreleft());
#endif
}
