/*  $Id$
 *  
 *  File	cbuff.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *		Horst Aurisch, aurisch@informatik.uni-bonn.de
 *  Purpose	Main program
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	08/06/93  (Created)
 *  		10/11/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"


/*------------------------------------------------------------
 *  Version information
 *------------------------------------------------------------*/

#define VERSION		"CBUFF 0.9.0"
#define VERSION_DATE	"November, 1993"
#define CVS_VERSION	"$Revision: 1.1.1.1 $"


/*------------------------------------------------------------
 *  Flags and global variables
 *------------------------------------------------------------*/

char *		NullString = "";

CBase		CurrentBase = NULL;


/*------------------------------------------------------------
 *  Argument passing
 *------------------------------------------------------------*/

void
setCurrentCBase(char *name, char *command, int argc, int arg)
{ if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  if (strcmp(name, "-") == 0)
  { if (CurrentBase == NULL)
    { fprintf(stderr, "Fatal: No current database\n");
      exit(1);
    }
    return;
  }
  if (CurrentBase)
    freeCBase(CurrentBase);
  if ((CurrentBase = newCBase(name, "r")) == NULL)
  { fprintf(stderr, "Fatal: Cannot open ChessBase file %s\n", name);
    exit(1);
  }
}


CBase
databaseArgument(char *name, char *command, int argc, int arg)
{ CBase cb;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  if ((cb = newCBase(name, "r")) == NULL)
  { fprintf(stderr, "Fatal: Cannot open ChessBase file %s\n", name);
    exit(1);
  }
  return cb;
}


CBase
createBaseArgument(char *name, char *command, int argc, int arg)
{ CBase cb;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  if ((cb = newCBase(name, "c")) == NULL)
  { reportError(stderr);
    exit(1);
  }
  return cb;
}


CBase
appendBaseArgument(char *name, char *command, int argc, int arg)
{ CBase cb;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  if ((cb = newCBase(name, "a")) == NULL)
  { reportError(stderr);
    exit(1);
  }
  return cb;
}


void
checkCurrentBase(CBase cb, char *command)
{ if (cb == NULL)
  { fprintf(stderr, "Fatal: No current database for %s\n", command);
    exit(1);
  }
}


long
longArgument(char *val, char *command, int argc, int arg)
{ long l;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  
  if ((l=atol(val)) < 0)
  { fprintf(stderr, "Warning: %s %s not a number\n", command, val);
    return 1;
  }
  return l;
}


int
intArgument(char *val, char *command, int argc, int arg)
{ int i;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  
  if ((i=atoi(val)) < 0)
  { fprintf(stderr, "Warning: %s %s not a number\n", command, val);
    return 1;
  }
  return i;
}


FILE *
fileArgument(char *val, char *command, int argc, int arg, char *args)
{ FILE *fd;

  if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  
  if ((fd=fopenCbuffFile(val, args)) == NULL)
  { fprintf(stderr, "Fatal: Cannot open file %s\n", val);
    return NULL;
  }
  return fd;
}


char *
stringArgument(char *val, char *command, int argc, int arg)
{ if (argc <= arg)
  { fprintf(stderr, "Fatal: Argument required for %s\n", command);
    exit(1);
  }
  
  return val;
}


/*------------------------------------------------------------
 *  Local functions
 *------------------------------------------------------------*/

void
versionCBUFF(FILE *fd)
{ fprintf(fd, "Welcome to ChessBase utilities file format (CBUFF).\n");
  fprintf(fd, "There is absolutely no warranty for CBUFF.\n");
  fprintf(fd, "%s %s, based on %s.\nCopyright (c) 1993 Anjo Anjewierden\n",
	  UTILITY_NAME, UTILITY_VERSION, VERSION);
}


void
helpCBUFF(FILE *fd)
{ versionCBUFF(fd);\
  fprintf(fd, "\n");
  fprintf(fd, "Generic options of all CBUFF utilities:\n");
  fprintf(fd, "-append db    Output database (for appending)\n");
  fprintf(fd, "-database db  Make database current\n");
  fprintf(fd, "-dump db      Output database (for creating)\n");
  fprintf(fd, "-from n       Only consider games from n\n");
  fprintf(fd, "-help         Prints help\n");
  fprintf(fd, "-language s   Prints piece names in language s\n");
  fprintf(fd, "-long         Long algebraic notation\n");
  fprintf(fd, "-output file  Specifies default output file\n");
  fprintf(fd, "-short        Short algebraic notation (default)\n");
  fprintf(fd, "-symbols file File maps chess symbols onto strings\n");
  fprintf(fd, "-to n         Only consider games to n\n");
  fprintf(fd, "-verbose      Prints additional data (mainly for debugging)\n");
  fprintf(fd, "-version      Prints version information\n");
  fprintf(fd, "\n");
}	


/*------------------------------------------------------------
 *  Support functions
 *------------------------------------------------------------*/

bool
strhead(char *s, char *head)
{ if (strncmp(s, head, strlen(head)) == 0)
    return TRUE;
  return FALSE;
}
