/*  $Id$
 *  
 *  File	error.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Error handling and reporting
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	10/10/93  (Created)
 *  		17/10/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"


int		errorCode;
CBase		errorCBase;
CbHeader	errorCBHeader;
CbGame		errorCBGame;
Game		errorGame;
long		errorGameNumber;

char		errorName[256];
int		errorInt;


/*------------------------------------------------------------
 *  Functions
 *------------------------------------------------------------*/

void
clearError()
{ errorCode = 0;
}


void
setError(int code)
{ errorCode = code;
}


void
setNameError(char *s)
{ strcpy(errorName, s);
}


void
setIntError(int i)
{ errorInt = i;
}


void
environmentError(CBase cb, Game game, long n)
{ errorCBase = cb;
  errorGame = game;
  errorGameNumber = n;
}


bool
foundError()
{ if (errorCode)
    return TRUE;
  return FALSE;
}


void
reportError(FILE *fd)
{ int code = errorCode;

  clearError();
  switch(code)
  { case ERR_INCORRECT_CHECKSUM:
      fprintf(fd, "\nGame %6ld: [%3d] Incorrect checksum (alien data)",
	      errorGameNumber, code);
      return;
    case ERR_COULD_NOT_CREATE_FILE:
      fprintf(fd, "\nFatal [%3d]: Could not create file (%s)",
	      code, errorName);
      exit(1);
      return;
    case ERR_COULD_NOT_OVERWRITE_FILE:
      fprintf(fd, "\nFatal [%3d]: Could not overwrite existing file (%s)",
	      code, errorName);
      exit(1);
      return;
    case ERR_COULD_NOT_OPEN_WRITE:
      fprintf(fd, "\nFatal [%3d]: Could not open file for writing (%s)",
	      code, errorName);
      exit(1);
      return;
    case ERR_COULD_NOT_OPEN_READ:
      fprintf(fd, "\nFatal [%3d]: Could not open file for reading (%s)",
	      code, errorName);
      exit(1);
      return;
    case ERR_GAME_NUMBER_OUT_OF_RANGE:
      fprintf(fd, "\nGame %6ld: [%3d] Game number out of range (%ld in base)",
	      errorGameNumber, code, errorCBase->noGames);
      return;
    case ERR_CANNOT_SEEK:
    case ERR_CANNOT_READ_HEADER:
    case ERR_CANNOT_READ_TEXT:
    case ERR_CANNOT_READ_MOVES:
    case ERR_CANNOT_READ_COMMENTS:
    case ERR_CANNOT_READ_POSITION:
    case ERR_CANNOT_READ_MOVE_NUMBER:
      fprintf(fd, "\nGame %6ld: [%3d] Could not extract game header (data error)",
	      errorGameNumber, code);
      return;
    case ERR_UNEXPECTED_EOF:
      fprintf(fd, "\nFatal [%3d]: Unexpected end-of-file",
	      code);
      exit(1);
      return;
    case ERR_ILLEGAL_RESULT:
      fprintf(fd, "\nGame %6ld: [%3d] Illegal result in game",
	      errorGameNumber, code);
      return;
    case ERR_VARIATION_SEEN:
      fprintf(fd, "\nGame %6ld: [%3d] Variation seen that should not be there",
	      errorGameNumber, code);
      return;
    case ERR_CANNOT_INTERPRET_MOVE:
      fprintf(fd, "\nGame %6ld: [%3d] Cannot interpret all moves of the game (data error)",
	      errorGameNumber, code);
      return;
    case ERR_MOVE_COUNT_INCORRECT:
      fprintf(fd, "\nGame %6ld: [%3d] Incorrect move count in game",
	      errorGameNumber, code);
      return;
    case ERR_COMMENT_NOT_TERMINATED:
      fprintf(fd, "\nGame %6ld: [%3d] Comment not properly terminated",
	      errorGameNumber, code);
      return;
    case ERR_FORMAT_ERROR_ANNOTATIONS:
      fprintf(fd, "\nGame %6ld: [%3d] Format error in annotations",
	      errorGameNumber, code);
      return;
    case ERR_UNKNOWN_MOVE_EVALUATION:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown move evalution",
	      errorGameNumber, code);
      return;
    case ERR_UNKNOWN_POSITION_EVALUATION:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown position evaluation",
	      errorGameNumber, code);
      return;
    case ERR_UNKNOWN_EXTRA_EVALUATION:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown additional evaluation",
	      errorGameNumber, code);
      return;
    case ERR_UNKNOWN_CHARACTER:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown character in name ``%s''",
	      errorGameNumber, code, errorName);
      return;
    case ERR_UNKNOWN_PIECE:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown piece (internal error)",
	      errorGameNumber, code);
      return;
    case ERR_UNKNOWN_SYMBOL:
      fprintf(fd, "\nGame %6ld: [%3d] Unknown symbol (ASCII octal %o)",
	      errorGameNumber, code, errorInt);
      return;
    default:
      fprintf(fd, "\n** Internal error: Incorrect error code (%d)",
	      code);
      return;
  }
}
