PROGRAM CountPagesAndLines;         {What the program does.                }
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.01  : 1993/12/26.  Now recognizes DOS wildcards.  DDA

------------------------------------------------------------------------------}

uses dos ;
VAR
     PagedFile    : Text;           {The actual file to dissect (examine). }
     ALine        : String;         {A line in the file.                   }
     FFCount,                       {Count of FormFeeds (), ASCII 12      }
     TotalLines,                    {Total lines in the file.              }
     LineCount    : Word;           {Total lines on each page.             }
     JustTotals   : Boolean;        {Indicator of how much info to write.  }


procedure showhelp ( errornum : byte );
const
     ProgData = 'FPALN- Free DOS utility: text file page & line counter.';
     ProgDat2 = 'V1.01: December 26, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

     Usage  = 'Usage: FPALN text_file [/t (file Totals only)]';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'you must specify -exactly- one filespec (wildcards are OK).';
      2 : message := 'too many parameters.';
      3 : message := 'non-numeric found in a date or time string!';
      4 : message := 'unable to open specified file.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

PROCEDURE WritePageStats;     {Called at end of every page to show subtotals.}
BEGIN                         {Do nothing if instructed to only show totals. }
     IF (NOT JustTotals) THEN             {Otherwise, go ahead.}
        WriteLn('Page: ',FFCount:7,' has: ',LineCount:5,' lines.');
END;

var
   dirinfo : searchrec ;
   ps1     : pathstr ;
   pdir    : dirstr ;
   pname   : namestr ;
   pext    : extstr ;

BEGIN
     JustTotals := (ParamStr(2) = '/t');           {Just show totals if   }
                                                   {  2nd parameter is /t.}

     PS1 := ParamStr(1);                           {PS1 gets command line.}
     WHILE PS1 = '' DO BEGIN
        Writeln('Text file to dissect:');          {   Recursive query.   }
        ReadLn(PS1);
     END;

     ps1 := ( fexpand ( PS1 ));

     fsplit ( ps1,pdir,pname,pext );
     findfirst ( ps1, archive, dirinfo );
     if ( doserror <> 0) then
          showhelp(1);

     while doserror = 0 do begin

       Assign(PagedFile,pdir+dirinfo.name);          {  Assign properly.    }
 {$I-} Reset(PagedFile); {$I+}                       { Check if file exists.}
       IF IOResult <> 0 THEN                         { If it                }
          showhelp (4);
       Writeln('Reading text file ',dirinfo.name:13,' ...');
       FFCount := 0;
       TotalLines := 0;                              {Initialize all counts.}
       LineCount := 0;
       WHILE NOT Eof(PagedFile) DO                   {Will read             }
       BEGIN                                         {     the entire file. }
            ReadLn(PagedFile,ALine);                 {Read a line.          }
            TotalLines := Succ(TotalLines);          {Increment counter.    }
            IF Pos('',ALine) <> 0 THEN              {If page break on line,}
            BEGIN                                    {increment page counter.}
               FFCount := Succ(FFCount);             {If page break in the  }
               IF Pos('',ALine) > 1 THEN            {   middle of line,    }
               BEGIN                                 {     the line would   }
                  TotalLines := Succ(TotalLines);    {       print over two }
                  LineCount := Succ(LineCount);      { lines, so increment  }
               END;                                  { line counters again. }
               WritePageStats; {A procedure, above.} {Write totals so far.  }
               LineCount := 0;                       {Reset counter for     }
            END;                                     {    next page.        }
            LineCount := Succ(LineCount);            {The line in buffer    }
       END;                                          { automatically counts.}
       IF (TotalLines <> 0) THEN                     {If no lines,          }
          FFCount := Succ(FFCount);                  {        then no pages!}
       WritePageStats;                               {Write totals so far.  }
       Write('Text file ',dirinfo.name:13,'  has: ',TotalLines:7,' lines on: ',FFCount:5);
       IF FFCount <> 1 THEN                    {If zero pages, OR multiple    }
          WriteLn(' pages.')                   {        pages, write "pages." }
       ELSE                                    {otherwise,                    }
          WriteLn(' page.');                   {        simply write "page."  }
       WriteLn;                          {These next lines write grand totals.}
       Close (PagedFile);                      {Close our file for neatness.  }
           findnext ( dirinfo );
     end; {while}
END.                                         {          Done!!!             }
