/*
  Windows Sockets FTP Application

  Written by: John A. Junod            Internet: <junodj@gordon-emh2.army.mil>
              267 Hillwood Street                <zj8549@trotter.usma.edu>
              Martinez, GA 30907     Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.

  MODULE: WS_CON.C  (most FTP functions)
*/

#include "ws_glob.h"
#include "ws_ftp.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <time.h>

extern int errno;

u_int uiTimeOut=30000;  // 30 second timeout??
/*
// send a message on the control socket, read and display the resulting
// message and return the result value
*/
int getreply(SOCKET ctrl_socket,LPSTR cmdstring)
{
  int iRetCode=0;

  iCode=0;
  if(strncmp(cmdstring,"PASS ",5)==0)
    DoAddLine("PASS xxxxxx");
  else
    DoAddLine(cmdstring);
  if(ctrl_socket==INVALID_SOCKET) {
    DoAddLine("Not connected");
  } else {
    if(SendPacket(ctrl_socket,cmdstring)!=-1)
      iRetCode=ReadDisplayLine(ctrl_socket);
  }
  return(iRetCode);  // 0 - 5
}

int command(SOCKET socket, char *fmt,...)
{
   va_list args;
   char szBuf[90];
   int  iRetCode;

   va_start(args,fmt);
   vsprintf(szBuf,fmt,args);
   va_end(args);
   return(getreply(socket,szBuf));
}

// return a string pointer to ON or OFF based on the flag
char *onoff(BOOL flag)
{
  if(flag) return("ON"); else return("OFF");
}

// process STAT
int DoSTAT(SOCKET ctrl_socket)
{
  if(bConnected)
    DoPrintf("Connected to %s.",rhostname);
  else
    DoAddLine("Not connected");
  DoPrintf("Socket number %04x",ctrl_socket);
  DoPrintf("Mode %s, Type %s, Form %s, Structure %s",
    szModeName,szTypeName,szFormName,szStructName);
  DoPrintf("Verbose %s, Bell %s, Prompting %s, Globbing %s",
    onoff(bVerbose),onoff(bBell),onoff(bInteractive),onoff(bDoGlob));
  DoPrintf("Store unique %s, Receive unique %s",
    onoff(bStorUniq),onoff(bRecvUniq));
  DoPrintf("Case %s, CR stripping %s",onoff(bMCase),onoff(bCRstrip));
  if(ntflag)
    DoPrintf("Ntrans: (in) %s (out) %s",ntin,ntout);
  else
    DoAddLine("Ntrans off");
  if(mapflag)
    DoPrintf("Nmap: (in) %s (out) %s",mapin,mapout);
  else
  DoAddLine("Nmap off");
  DoPrintf("Hash %s, Port %s",onoff(bHash),onoff(bSendPort));
  return(2);
}

// process CWD
int DoCWD(SOCKET ctrl_socket,LPSTR path)
{
  if(command(ctrl_socket,"CWD %s",path)==FTP_ERROR && iCode==500) {
    command(ctrl_socket,"XCWD %s",path);
  }
  return(iCode/100);
}

// proces PWD
int DoPWD(SOCKET ctrl_socket)
{
  if(command(ctrl_socket,"PWD")==FTP_ERROR && iCode==500) {
    command(ctrl_socket,"XPWD");
  }
  return(iCode/100);
}

// process MKD
int DoMKD(SOCKET ctrl_socket,LPSTR pathname)
{
  if(command(ctrl_socket,"MKD %s",pathname)==FTP_ERROR && iCode==500) {
    command(ctrl_socket,"XMKD %s",pathname);
  }
  return(iCode/100);
}

// process RMD
int DoRMD(SOCKET ctrl_socket,LPSTR pathname)
{
  if(command(ctrl_socket,"RMD %s",pathname)==FTP_ERROR && iCode==500)
    command(ctrl_socket,"XRMD %s",pathname);
  return(iCode/100);
}

// process user command
int DoQUOTE(SOCKET ctrl_socket,LPSTR string)
{
  if(strncmp(string,"LIST",4)==0 ||
     strncmp(string,"NLST",4)==0)
    DoDirList(ctrl_socket,string);
  else
    command(ctrl_socket,string);
  return(iCode/100);
}

// process chmod
int DoCHMOD(SOCKET ctrl_socket,LPSTR modes,LPSTR filename)
{
  return(command(ctrl_socket,"SITE CHMOD %s %s",modes,filename));
}

// initial connection
SOCKET DoConnect(char *host)
{
  int iLength,iRetCode;
  int iFlag=1;
  SOCKET ctrl_socket;

  if(bConnected) {
    DoAddLine("Already connected!");
    return(INVALID_SOCKET);
  }
  // let other routines know that we are busy
  bCmdInProgress++;
  // create a connected socket
  if((ctrl_socket=connectTCP(host,"ftp"))==INVALID_SOCKET) {
    DoAddLine("connection failed");
    bCmdInProgress--;
    return(INVALID_SOCKET);
  }
  // get information about local end of the connection
  iLength = sizeof (saCtrlAddr);
  if (getsockname(ctrl_socket,(struct sockaddr *)&saCtrlAddr, &iLength)
      ==SOCKET_ERROR)
  {
    DoAddLine("getsockname error");
    ReportWSError(WSAGetLastError());
    bCmdInProgress--;
    DoClose((SOCKET)ctrl_socket);
    return(INVALID_SOCKET);
  }
  // show remote end address
  DoPrintf("from %s port %u",
           inet_ntoa(saCtrlAddr.sin_addr),
           ntohs(saCtrlAddr.sin_port));
  // get initial message from remote end
  while((iRetCode=ReadDisplayLine(ctrl_socket))==FTP_PRELIM);
  // if it succeeded
  if(iRetCode==FTP_COMPLETE) {
    if (setsockopt(ctrl_socket, SOL_SOCKET, SO_OOBINLINE,
        (LPSTR)&iFlag, sizeof(iFlag))==SOCKET_ERROR)
    {
      DoAddLine("setsockopt error, but maybe its ok");
      ReportWSError(WSAGetLastError());
    }
    // have to reset this so "command" will work
    bCmdInProgress--;
    // send our userid
    if((iRetCode=command(ctrl_socket,"USER %s",userid))==FTP_CONTINUE)
    {
      // if the remote system requires a password, send it.
      iRetCode=command(ctrl_socket,"PASS %s",passwd);
    }
    // if we are successfully logged on,.....
    if(iRetCode!=FTP_COMPLETE)
    {
      DoAddLine("logon failure, so quitting");
      DoClose((SOCKET)ctrl_socket);
      return(INVALID_SOCKET);
    }
    bConnected=1;
  } else {
    DoPrintf("unk open msg \"%s\" %u",szMsgBuf,iCode);
    // allow other processes to work
    bCmdInProgress--;
    DoClose((SOCKET)ctrl_socket);
    return(INVALID_SOCKET);
  }
  return (ctrl_socket);
}

int DoDirList(SOCKET ctrl_socket,LPSTR szCMD)
{
  return(RetrieveFile(ctrl_socket,szCMD,szTmpFile,TYPE_A));
}

int SendFile(SOCKET ctrl_socket,LPSTR szCMD,LPSTR localfile,char stype)
{
  int iRetCode;
  int iLength;
  SOCKET data_socket;
  SOCKET listen_socket;

  iCode=0;
  // if we don't have a valid control socket, can't do anything
  if(ctrl_socket==INVALID_SOCKET) {
    DoAddLine("no ctrl_socket, ignored");
    return(0);
  }
  // if we are doing something, don't try to do this
  if(bCmdInProgress) {
    DoAddLine("command in process, ignored");
    return(0);
  }
  // if the requested type is not the same as the default type
  if(cType!=stype) {
    command(ctrl_socket,"TYPE %c",stype);
    cType=stype;
  }
  // create a listener socket, if it is successful
  if((listen_socket=(SOCKET)openFTPDataSocket((SOCKET)ctrl_socket,
    (struct sockaddr_in *)&saCtrlAddr))!=INVALID_SOCKET) {
    // send command to see the result of this all
    iRetCode=command((SOCKET)ctrl_socket,szCMD);
    // read the control channel (should return 1xx if it worked)
    if(iRetCode==FTP_PRELIM) {
      // wait for connection back to us on the listen socket
      SetTimer(hWndMain,10,5000,NULL);
      // get our data connection
      iLength=sizeof(dsin);
      data_socket=accept(listen_socket,(struct sockaddr far *)&dsin,
                         (int far *)&iLength);
      // turn off the timeout timer
      KillTimer(hWndMain,10);
      // if it failed, we have to quit this
      if(data_socket==INVALID_SOCKET) {
        DoAddLine("accept error");
        ReportWSError(WSAGetLastError());
        closesocket(listen_socket);
        iRetCode=0;
      } else {
        // we don't need the listener socket anymore
        closesocket(listen_socket);
        // inform user of the connection
        DoPrintf("accept from %s port %u",
          inet_ntoa(dsin.sin_addr),ntohs(dsin.sin_port));
        // copy the file
        iRetCode=SendMass(data_socket,localfile,stype==TYPE_I);
        // close the socket
        closesocket(data_socket);
        // read the close control message (should return 2xx)
        iRetCode=ReadDisplayLine(ctrl_socket);
      }
    }
  } else {
    DoPrintf("invalid return code from %s",szCMD);
    closesocket(listen_socket);
    iRetCode=0;
  }
  return(iRetCode);
}

int RetrieveFile(SOCKET ctrl_socket,LPSTR szCMD,LPSTR localfile,char rtype)
{
  int iRetCode;
  int iLength;
  SOCKET data_socket;
  SOCKET listen_socket;

  iCode=0;
  // if we don't have a valid control socket, can't do anything
  if(ctrl_socket==INVALID_SOCKET) {
    DoAddLine("no ctrl_socket, ignored");
    return(0);
  }
  // if we are doing something, don't try to do this
  if(bCmdInProgress) {
    DoAddLine("command in process, ignored");
    return(0);
  }
  // if the requested type is not the same as the default type
  if(cType!=rtype) {
    command(ctrl_socket,"TYPE %c",rtype);
    cType=rtype;
  }
  // create a listener socket, if it is successful
  if((listen_socket=(SOCKET)openFTPDataSocket((SOCKET)ctrl_socket,
    (struct sockaddr_in *)&saCtrlAddr))!=INVALID_SOCKET) {
    // send command to see the result of this all
    iRetCode=command((SOCKET)ctrl_socket,szCMD);
    // read the control channel (should return 1xx if it worked)
    if(iRetCode==FTP_PRELIM) {
      // wait for connection back to us on the listen socket
      SetTimer(hWndMain,10,5000,NULL);
      // get our data connection
      iLength=sizeof(dsin);
      data_socket=accept(listen_socket,(struct sockaddr far *)&dsin,
                         (int far *)&iLength);
      // turn off the timeout timer
      KillTimer(hWndMain,10);
      // if it failed, we have to quit this
      if(data_socket==INVALID_SOCKET) {
        DoAddLine("accept error");
        ReportWSError(WSAGetLastError());
        closesocket(listen_socket);
        //command(ctrl_socket,"TYPE %c",cType);
        iRetCode=0;
      } else {
        // we don't need the listener socket anymore
        closesocket(listen_socket);
        // inform user of the connection
        DoPrintf("accept from %s port %u",
          inet_ntoa(dsin.sin_addr),ntohs(dsin.sin_port));
        // copy the file
        iRetCode=ReadMass(data_socket,localfile,rtype==TYPE_I);
        // shut the data socket down
        if(shutdown(data_socket,2)!=0)
          ReportWSError(WSAGetLastError());
        // close the data socket
        closesocket(data_socket);
        // read the close control message (should return 2xx)
        iRetCode=ReadDisplayLine(ctrl_socket);
      }
    }
  } else {
    DoPrintf("invalid return code from %s",szCMD);
    closesocket(listen_socket);
    iRetCode=0;
  }
//  MessageBox(hWndMain,szMsgBuf,"end of receive",MB_OK);
  return(iRetCode);
}

// user close routine
SOCKET DoClose(SOCKET sockfd)
{
  if(sockfd!=INVALID_SOCKET) {
    if(WSAIsBlocking()) {
      DoAddLine("Cancelled blocking call");
      WSACancelBlockingCall();
    }
    if(shutdown(sockfd,2)==SOCKET_ERROR)
      ReportWSError(WSAGetLastError());
    if(closesocket(sockfd)==SOCKET_ERROR)
      ReportWSError(WSAGetLastError());
    else {
      sockfd=INVALID_SOCKET;
      DoAddLine("Socket closed");
      bConnected=0;
    }
  }
  return(sockfd);
}

int SendPacket(SOCKET sockfd,LPSTR msg)
{
  int i;

  if(sockfd==INVALID_SOCKET) return(-1);
  if(bCmdInProgress) {
    DoAddLine("command in progress, ignored");
    return (-1);
  }
  bCmdInProgress++;
  i=strlen(msg);
  strcpy(sendpack,msg);
  // append a CRLF to the end of outgoing messages
  sendpack[i++]='\r';
  sendpack[i++]='\n';
  sendpack[i]=0;  
  i=sendstr(sockfd,sendpack,i);
  bCmdInProgress--;
  return (i);
}

int iMultiLine=0;
// read a reply line back in from the ctrl_socket and return the
// value at the beginning of the first line.
//
int ReadDisplayLine(SOCKET sockfd)
{
  LPSTR szBuf;
  int iNumBytes;
  int iBytesRead;
  int iRetCode;
  int iContinue;
  char *s;
  char c;

  // can't do anything if we don't have a socket
  if(sockfd==INVALID_SOCKET) return(0);
  // let other routine know that we are doing something right now.
  bCmdInProgress++;
  // zero our receive buffer
  memset(szMsgBuf,0,4196);
  // count the lines in the response
  iMultiLine++;
  // initialize some variables
  szBuf=szMsgBuf; iBytesRead=0; iRetCode=0; iContinue=0;
  // set our timeout
  SetTimer(hWndMain,10,uiTimeOut,NULL);
  // this routine is a little better as it read 80 characters at a time
  // (if it works:-)  Here we PEEK at what is available, find the LF etc...
  while(iBytesRead<4000 && (iNumBytes=recv(sockfd,(LPSTR)szBuf,82,MSG_PEEK))>0)
  {
    // Trumpet WinSock Alpha 15 always returns the len (82) from a recv
    // with MSG_PEEK.  I suppose this is an error??? The spec doesn't say
    // that MSG_PEEK returns something different than normal.
    KillTimer(hWndMain,10);
    // must terminate the string so strchr doesn't go wild.
    szBuf[iNumBytes]=0;
    // find a LF in the input if it exists
    if((s=strchr(szBuf,'\n'))!=NULL) {
      // if what we now have contains a LF, only recv that much
      iNumBytes=s-szBuf+1;
      iNumBytes=recv(sockfd,(LPSTR)szBuf,iNumBytes,0);
    }
    else
      // otherwise read up to the full length of what the first recv saw.
      // Wonder what happens here if the second receive actually returns more
      // characters than the first receive and there was a LF in the extra data?   
      iNumBytes=recv(sockfd,(LPSTR)szBuf,iNumBytes,0);
    // again, terminate the string
    szBuf[iNumBytes]=0;
    // bump the receive buffer pointer
    szBuf+=iNumBytes;
    // count the bytes that we have read so far
    iBytesRead+=iNumBytes;
    // if the last character read was a LF, then stop.  NOTE: this is not really
    // in keeping with RFC 959 as the line MUST end with CRLF but I work with
    // a system (UNISYS 5000) that only returns a LF and no CR at the end of lines.
    if(*(szBuf-1)=='\n') break;
    // otherwise reset the timer and go read more characters
    SetTimer(hWndMain,10,uiTimeOut,NULL);
  }
  // if we are here, we have a line or an error or there was nothing to read
  KillTimer(hWndMain,10);
  // in any case terminate what we have
  *szBuf=0;
  // find the retcode at the beginning of the line
  c=szMsgBuf[3]; szMsgBuf[3]=0; iRetCode=atoi(szMsgBuf); szMsgBuf[3]=c;
  // if it wasn't a valid value or the 4th char was a hyphen
  if(iRetCode<100 || iRetCode>599 || c=='-')
    // then it is a continuation line
    iContinue=1;
  // send the line we read to our user/debug window
  DoAddLine((LPSTR)&szMsgBuf[0]);
  // we only want to set the real return code in certain situations
  if((iMultiLine==1 || iCode==0) && iRetCode>99 && iRetCode<600)
    iCode=iRetCode;
  // handle continuation lines
  if(iContinue==1 || (iCode>0 && iMultiLine>1 && iRetCode!=iCode))
    ReadDisplayLine(sockfd);
  // count back down our multiline reponses
  iMultiLine--;
  // allow other processes to run
  bCmdInProgress--;
  // return only the first char of return code
  if(iCode>99 && iCode<600)
    return (iCode/100);
  else return 0;
}


// based on WINTEL (ftp.c) and BSD (ftp.c)
SOCKET openFTPDataSocket(SOCKET ctrl_socket,struct sockaddr_in *ctrladdr)
{
    SOCKET data_socket;
    int iLength;
    int iRetCode;
    char *a,*p;
    int iFlag=1;

    // create a data socket
    if((data_socket=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP))==INVALID_SOCKET)
    {
        DoAddLine("socket create error");
        ReportWSError(WSAGetLastError());
        return ((SOCKET)SOCKET_ERROR);
    }
    // let system pick an unused port. we tell remote end with PORT cmd
    if(bSendPort)
      saCtrlAddr.sin_port=htons(0);
    else
      // otherwise we attempt to reuse our ctrl_socket
      if(setsockopt(data_socket,SOL_SOCKET,SO_REUSEADDR,
         (char *)&iFlag,sizeof(iFlag))==SOCKET_ERROR)
      {
        DoAddLine("setsockopt error");
        ReportWSError(WSAGetLastError());
        closesocket(data_socket);
        return((SOCKET)SOCKET_ERROR);
      }
    //  Bind name to socket
    if( bind((int)data_socket,(struct sockaddr far *)&saCtrlAddr,
             (int)sizeof(struct sockaddr))==SOCKET_ERROR)
      {
        DoAddLine("bind error");
        ReportWSError(WSAGetLastError());
        closesocket(data_socket);
        return ((SOCKET)SOCKET_ERROR);
    }
    // get the port name that we got for later transmission in PORT cmd
    iLength=sizeof(saCtrlAddr);
    if(getsockname(data_socket,(struct sockaddr *)&saCtrlAddr,&iLength)<0)
    {
      DoAddLine("getsockname error");
      ReportWSError(WSAGetLastError());
      closesocket(data_socket);
      return((SOCKET)SOCKET_ERROR);
    }
    // invoke listener
    if(listen(data_socket,1)!=0)
    {
      DoAddLine("listen error");
      ReportWSError(WSAGetLastError());
       closesocket(data_socket);
      return((SOCKET)SOCKET_ERROR);
    }

// inform remote end about our port that we created.
    if(bSendPort)
    {
      a = (char *)&saCtrlAddr.sin_addr;
      p = (char *)&saCtrlAddr.sin_port;
#define  UC(b)  (((int)b)&0xff)
      if((iRetCode=command(ctrl_socket,"PORT %d,%d,%d,%d,%d,%d",
          UC(a[0]), UC(a[1]), UC(a[2]), UC(a[3]),
          UC(p[0]), UC(p[1])))!=FTP_COMPLETE) {
        DoAddLine("remote end didn't understand our port command.");
        return((SOCKET)data_socket);
      }
    }
    DoPrintf("listener started on port %u",ntohs(saCtrlAddr.sin_port));
    return((SOCKET)data_socket);
}

// send a file through the data socket
int SendMass(SOCKET sockfd,LPSTR filename,BOOL binaryflag)
{
  int  iNumBytes;
  int  iRetCode;
  int  iFileHandle;
  long lBytesWritten;
  time_t ttStart;
  time_t ttStop;

  iRetCode=0;
  // if we don't have a socket, return an error  
  if(sockfd==INVALID_SOCKET || !(bConnected)) return 0;
  // turn on a flag so other routines know we have a command in progress
  bCmdInProgress++;
  // initialize some vars
  lBytesWritten=0l; iRetCode=0; 
  // at the moment we are ignoring the fact that the local destination file
  // may not open correctly.
  if((iFileHandle=_lopen(filename,READ))== -1) {
    DoPrintf("failed to open file %s (%u)",filename,errno);
  } else {
    // get the start time
    ttStart=time(NULL);
    // loop to send output to remote end
    while((iNumBytes=_lread(iFileHandle,szMsgBuf,4000))>0)
    {
      // this forces binary mode at the moment
      iRetCode=sendstr(sockfd,szMsgBuf,iNumBytes);
      // count the characters that we received
      lBytesWritten+=iNumBytes;
    }
    // get the finish time
    ttStop=time(NULL);
    // if the output file is open, close it
    _lclose(iFileHandle);
    // show the user how we did
    DoPrintf("Transmitted %ld characters in %ld seconds, transfer %s",
      lBytesWritten,(long)ttStop-ttStart,
      (iFileHandle==-1)?"failed":"succeeded");
    iRetCode=TRUE;
  }
  // turn off our command in progress flag
  bCmdInProgress--;

  return (iRetCode);
}

// read information from the data socket into a file.  
int ReadMass(SOCKET sockfd,LPSTR filename,BOOL binaryflag)
{
  int  iNumBytes;
  int  iRetCode;
  int  iFileHandle;
  long lBytesRead;
  time_t ttStart;
  time_t ttStop;

  // if we don't have a socket, return an error  
  if(sockfd==INVALID_SOCKET || !(bConnected)) return 0;
  // turn on a flag so other routines know we have a command in progress
  bCmdInProgress++;
  // initialize some vars
  lBytesRead=0l; iRetCode=0; 
  // at the moment we are ignoring the fact that the local destination file
  // may not open correctly.
  if((iFileHandle=_lcreat(filename,0))== -1)
    DoPrintf("failed to open file %s (%u)",filename,errno);
  // get the start time
  ttStart=time(NULL);
  // kill any blocking calls that take longer than 10 seconds to return
  SetTimer(hWndMain,10,uiTimeOut,NULL);
  // loop to receive input from remote end
  while((iNumBytes=recv(sockfd,(LPSTR)szMsgBuf,4000,0))>0)
  {
    // turn timer off as we had a successful return
    KillTimer(hWndMain,10);
    // write what we received if the file is open
    if(iFileHandle!= -1)
      _lwrite(iFileHandle,szMsgBuf,iNumBytes);
    // count the characters that we received
    lBytesRead+=iNumBytes;
    // turn the timer back on as we will try to read more
    SetTimer(hWndMain,10,uiTimeOut,NULL);
  }
  // turn the timer off if it happens to be on (if the recv returned 0)
  KillTimer(hWndMain,10);
  // get the finish time
  ttStop=time(NULL);
  // if the output file is open, close it
  if(iFileHandle != -1)  _lclose(iFileHandle);
  // if we had a recv error, let us know about it
  if(iNumBytes==SOCKET_ERROR)
  {
    ReportWSError(WSAGetLastError());
    if(lBytesRead==0l)
    {
      bCmdInProgress--;
      return(FALSE);
    }
  }
  // show the user how we did
  DoPrintf("Received %ld characters in %ld seconds, transfer %s",
    lBytesRead,(long)ttStop-ttStart,
    (iFileHandle==-1)?"failed":"succeeded");
  // turn off our command in progress flag
  bCmdInProgress--;

  return (TRUE);
}

