/*
  Windows Sockets FTP Application

  Written by: John A. Junod            Internet: <junodj@gordon-emh2.army.mil>
              267 Hillwood Street                <zj8549@trotter.usma.edu>
              Martinez, GA 30907     Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.

  MODULE: WS_PAINT.C  (main window (debug) display routines)
*/

#include "ws_glob.h"
#include "ws_ftp.h"

#include <stdio.h>
#include <stdarg.h>

int nLineHeight=5;
int nScreenRows=10;

void ReleaseDisplayMem()
{
  int i;
  for(i=0;i<ptrhGMem;i++)
    GlobalFree(hGMem[i]);
  ptrhGMem=0;
}

void DoAddLine(LPSTR szString)
{
  GLOBALHANDLE hGlobalMemory;
  LPSTR lpGlobalMemory;
  int i;
  RECT rect;

  i=_fstrlen(szString);
  hGlobalMemory=GlobalAlloc(GMEM_MOVEABLE,i);
  lpGlobalMemory=GlobalLock(hGlobalMemory);
  lstrcpy(lpGlobalMemory,szString);
  GlobalUnlock(hGlobalMemory);
  if(ptrhGMem<90) {
    hGMem[ptrhGMem++]=hGlobalMemory;
  } else {
    GlobalFree(hGMem[0]);
    for(i=0;i<90;i++)
      hGMem[i]=hGMem[i+1];
    hGMem[ptrhGMem-1]=hGlobalMemory;
  }
  GetClientRect(hWndMain,&rect);
  rect.top=min(0,(ptrhGMem-sVPos-1))*nLineHeight;

  if(ptrhGMem > (sVPos+nScreenRows))
    PostMessage(hWndMain,WM_VSCROLL,SB_LINEDOWN,0L);
  else
    InvalidateRect(hWndMain,&rect,TRUE);

  UpdateWindow(hWndMain);
}

void DoPrintf(char *msg,...)
{
   va_list args;
   static char szBuf[256];

   va_start(args,msg);
   vsprintf(szBuf,msg,args);
   DoAddLine(szBuf);
   va_end(args);
}

void DoPaint(HWND hWnd)
{
  HDC         hDC;   // handle for the display device
  PAINTSTRUCT ps;    // holds PAINT information
  int         nRc;
  int         i;
  LPSTR       lpMem;

  RECT rRect;
  TEXTMETRIC tm;

  memset(&ps, 0x00, sizeof(PAINTSTRUCT));
  hDC = BeginPaint(hWnd, &ps);
  // Included as the background is not a pure color
  SetBkMode(hDC, TRANSPARENT);
  GetTextMetrics(hDC,&tm);
  nLineHeight=tm.tmHeight+tm.tmExternalLeading;
  GetClientRect(hWnd,&rRect);
  nScreenRows=rRect.bottom/nLineHeight;
  if(nScreenRows >= ptrhGMem)
      ShowScrollBar(hWnd,SB_VERT,FALSE);
  else
      ShowScrollBar(hWnd,SB_VERT,TRUE);
  for(i=0;(i+sVPos)<ptrhGMem;i++) {
    lpMem=GlobalLock(hGMem[i+sVPos]);
    if(lpMem!=NULL) TextOut(hDC,20,i*nLineHeight,lpMem,lstrlen(lpMem));
    GlobalUnlock(hGMem[i+sVPos]);
  }
  // Inform Windows painting is complete
  EndPaint(hWnd, &ps);
}

int GetLocalInfo()
{
  int nRc;
  struct hostent *hostptr;
  char *ptr;
  struct in_addr *iptr;

  DoPrintf("Description: %s",(LPSTR)WSAData.szDescription);
/*
  DoPrintf("System Status: %s", (LPSTR)WSAData.szSystemStatus);
  DoPrintf("Version: %04x %04x %d %d",
        (WORD)WSAData.wVersion,(WORD)WSAData.wHighVersion,
        (int)WSAData.iMaxSockets,(int)WSAData.iMaxUdpDg);
*/
  strcpy(szMsgBuf,"local hostname: ");
  if((nRc=gethostname((LPSTR)lhostname, // &szMsgBuf[strlen(szMsgBuf)],
             MAXHOSTNAMELEN))==SOCKET_ERROR)
    ReturnWSError(WSAGetLastError(),&szMsgBuf[strlen(szMsgBuf)]);
  else
    strcpy(&szMsgBuf[strlen(szMsgBuf)],lhostname);
  DoAddLine(szMsgBuf);

  if(!nRc)
  {
    if((hostptr=gethostbyname(lhostname))==NULL) {
      ReturnWSError(WSAGetLastError(),szMsgBuf);
      DoAddLine(szMsgBuf);
    } else {
/*
      DoPrintf("official name: %s",hostptr->h_name);
      while ( (ptr = *(hostptr->h_aliases)) != NULL) {
        DoPrintf("alias: %s",ptr);
        hostptr->h_aliases++;
      }
*/
      while ( (iptr = (struct in_addr *) *(hostptr->h_addr_list)) != NULL) {
        DoPrintf("address: %s",inet_ntoa(*iptr));
        hostptr->h_addr_list++;
      }
    }
  }
  return(TRUE);
}
