ECHO OFF

REM CAPGNZBU.BAT - backup Capital Gainz data files
REM Simple batch file to backup Capital Gainz data files.
REM The data files can be restored with CAPGNZRS.BAT.
REM Single parameter - letter of drive (A or B) to copy files to.

REM Note that Portfolio Histories are NOT backed up.

ECHO Any existing data files on drive %1 will be removed before backup.
PAUSE Hit any key to backup from current drive to drive %1 (CNTL-C to abort) 

IF "%1" == "a" GOTO BACKUPA
IF "%1" == "A" GOTO BACKUPA
IF "%1" == "a:" GOTO BACKUPA
IF "%1" == "A:" GOTO BACKUPA

IF "%1" == "b" GOTO BACKUPB
IF "%1" == "B" GOTO BACKUPB
IF "%1" == "b:" GOTO BACKUPB
IF "%1" == "B:" GOTO BACKUPB

ECHO Backup Failed - Can only backup to Drive A or B.
GOTO END

:BACKUPA
REM Delete any exiting data files.
IF EXIST A:*.DAT DEL A:*.DAT
IF EXIST A:*.K01 DEL A:*.K01

REM If you run out of disk space, you can replace the COPY commands
REM below with commands that use a data compressor, such as PKZIP:
REM  PKZIP -U A:CGDATA.ZIP *.DAT *.K01

COPY *.DAT A:
COPY *.K01 A:
GOTO ENDOK

:BACKUPB
REM Delete any exiting data files.
IF EXIST B:*.DAT DEL B:*.DAT
IF EXIST B:*.K01 DEL B:*.K01

REM If you run out of disk space, you can replace the COPY commands
REM below with commands that use a data compressor, such as PKZIP:
REM  PKZIP -U B:CGDATA.ZIP *.DAT *.K01

COPY *.DAT B:
COPY *.K01 B:
GOTO ENDOK

:ENDOK
PAUSE Backup Succeeded !  Hit any key to continue.

:END
