#include <dos.h>
#include <conio.h>

#define BUZZ 48
#define DDELAY 1500
#define SDELAY 134
#define ADJFACTOR 3.5
#define MAXDIGITS 7
#define NOTE1 2000
#define NOTE2 500
#define NOTE3 1200
#define NOTE4 200
#define INTERVAL 10
#define REPEATS 160

void dialtone();
void number( int );
void dial();
void warble();


/**************************************************************************/
/*                        SOUND EFFECTS (Dialing)                         */
/**************************************************************************/
void dial()
{
   register t;
   const int P[ MAXDIGITS ] = { 750, 1150, 550, 1127, 920, 799, 760 };

      dialtone();

      for( t = 0; t < MAXDIGITS; t++ )
	  number( P[t] );
}

void number( int freq )
{

       sound( freq );
       delay( SDELAY );
       nosound();
       delay( SDELAY / ADJFACTOR );
       return;

}



void dialtone()
{
      sound( BUZZ );
      delay( DDELAY );
      nosound();

      return;
}



void warble()
{
   int delay1 = 0;

      while ( delay1++ < REPEATS )
         {
         sound( NOTE1 );
         delay( INTERVAL );

         sound( NOTE2 );
         delay( INTERVAL );

         sound( NOTE3 );
         delay( INTERVAL );

         sound ( NOTE4 );
         delay( 2 * INTERVAL );
         }
      nosound();
}

