static char *description[] = {			
 "Ŀ",
 "         LOCATE by Terry E. Crandall, 1993.    Version 1.0             ",
 "                                                                       ",
 "   LOCATE is FreeWare.  If you find it useful, or have any comments,   ",
 "   send me a note to either Compuserve [76620,521], or 1101 Lake Heron ",
 "   Drive, #1C, Annapolis, Maryland, 21403.  I would love to hear from  ",
 "   you.                                                                ",
 "Ĵ",
 "Usage:              LOCATE [options] [filespec]                        ",
 "                                                                       ",
 "    OPTIONS are specified with a slash (/), followed by a symbol,     ",
 "     and optionally followed by arguments pertaining to the option.    ",
 "                                                                       ",
 "    Multiple options MUST be separated by white space, i.e.,          ",
 "     '/R/ES' implies '/ES' is an argument of '/R'.  Correct is         ",
 "     '/R /ES'.                                                         ",
 "                                                                       ",
 "    If arguments contain spaces or any symbols that have special      ",
 "     meaning to MSDOS, e.g., '<' or '|', then the argument (or the     ",
 "     switch and its argument) must be enclosed within quotes.          ",
 "                                                                       ",
 "     For example,        /F<<<< $f >>>>          will not work         ",
 "                         /F\042<<<< $f >>>>\042        will work             ",
 "                         \042/F<<<< $f >>>>\042        will also work        ",
 "                                                                       ",
 "    Quotes (\042) may be included inside an argument by prefixing them   ",
 "     by a backslash: \\\042                                                ",
 "                                                                       ",
 "    FILESPEC defaults to *.* if not given.  Do not include a drive    ",
 "     specification...LOCATE only works on the current drive, or        ",
 "     multiple drives (see /M switch).                                  ",
 "Ĵ",
 "NOTATION USED IN ARGUMENTS COLUMN:                                     ",
 "                                                                       ",
 "    the  symbol indicates that the argument is one of several        ",
 "     choices that cannot be used with each other, i.e., only one       ",
 "     of the arguments can be present.                                  ",
 "                                                                       ",
 "    the  symbol indicates that the argument is the default argument  ",
 "     if its switch is given without any arguments.                     ",
 "                                                                       ",
 "                                                                       ",
 "Opt      Arguments                 Description and Examples            ",
 "Ĵ",
 "/?   [/switch...]     Display some or all of help                     ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /?                       display entire help ",
 "                        /? /F /S     display help for /F and /S only ",
 "Ĵ",
 "/A   attribute[-]...  Locate only files with specified attribute, or  ",
 "                      [-] without specified attribute.                ",
 "                        See also /E and /V switches.                 ",
 "                     Ĵ",
 "         R            Read-only                                       ",
 "         H            Hidden                                          ",
 "         S            System                                          ",
 "         L            Label                                           ",
 "         D            Directory                                       ",
 "         A            Archive                                         ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /AH                 choose only hidden files ",
 "                        /AHD-L   choose hidden, exclude directories, ",
 "                                                    and choose labels ",
 "Ĵ",
 "/A   [mmddyy] [hhmm]  Locate only files dated AFTER date or date/time ",
 "                        See also /B and /D switches. 7                ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /A060191 1720     after 5:20pm, June 1, 1991 ",
 "                        /A0900                       after 9am TODAY ",
 "Ĵ",
 "/B   [mmddyy] [hhmm]  Locate only files dated BEFORE date or date/time",
 "                        See also /A and /D switches.                 ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /B112787          before November 27th, 1987 ",
 "                        /A010190 /B010191         only files in 1990 ",
 "Ĵ",
 "/C   # columns        Split listing into '#' columns.                 ",
 "                        See also /I and /L switches.                 ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /C2                      display two columns ",
 "Ĵ",
 "/D   # days           Locate only files dated within number of days   ",
 "                        See also /A and /B switches.                 ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /D2              files dated since yesterday ",
 "                        /D            files dated today; same as /D1 ",
 "Ĵ",
 "/E    option          Exclude from Recursive Search.                  ",
 "                     Ĵ",
 "         C           Exclude current working directory               ",
 "         R            Exclude ROOT directory                          ",
 "         S            Exclude subdirectories of ROOT                  ",
 "                     Ĵ",
 "                      The difference between /ES and /AD- is that no  ",
 "                      <files> inside directories will be processed for",
 "                      sub-directories with /ES, but only descendants  ",
 "                      that are sub-directory <FILES> in the chain are ",
 "                      processed for /AD-.                             ",
 "                     Ĵ",
 "                      $d     Day of file          (mon, tue, .., sun) ",
 "                      #d     Day of file             (01, 02, .., 31) ",
 "                      $e     Extension of file                  () ",
 "                      $f     Name of file              (.) ",
 "                      #f     abbrev for $p\\$f         (see $p and $f) ",
 "                      $k     Size of file in kilobytes       (K) ",
 "                      #k     ALLOCATED size of file          (K) ",
 "                      $m     Month of file        (jan, feb, .., dec) ",
 "                      #m     Month of file           (01, 02, .., 12) ",
 "                      $p     Disk and path of directory   (:\\path..) ",
 "                             If '\\' directory, then              (:) ",
 "                      #p     Path of directory             (\\path..) ",
 "                      $s     Size of file in bytes        () ",
 "                      #s     ALLOCATED size of file       () ",
 "                      $t     Time of file                  (HH:MM:SS) ",
 "                      #t     Time of file                     (HH:MM) ",
 "                      #u     Upper (PARENT) directory      () ",
 "                      $y     Year of file      (1980, 1981, .., 1999) ",
 "                      #y     Year of file            (80, 81, .., 99) ",
 "                      $=n    Skip to column 'n', e.g., $=30 or $=100  ",
 "                      $$     The symbol $                             ",
 "                      $#     The symbol #                             ",
 "                     Ĵ",
 "                        See also /A, /R and /V switches.             ",
 "Ĵ",
 "/F   format-string    Specifies format of listing line for each file  ",
 "                        The listed output pertaining to each file is ",
 "                         the text in 'format-string', with the tokens ",
 "                         below being replaced by the value(s) for the ",
 "                         file                                         ",
 "                        See also /X switch.                          ",
 "                     Ĵ",
 "                      $a     Attributes of file              (RHSVDA) ",
 "                      #a     Attributes of file                (0x) ",
 "                      $b     Basename of file              () ",
 "                      $c     Size, in MSDOS clusters         () ",
 "                      $d     Day of file          (mon, tue, .., sun) ",
 "                      #d     Day of file             (01, 02, .., 31) ",
 "                      $e     Extension of file                  () ",
 "                      $f     Name of file              (.) ",
 "                      #f     abbrev for $p\\$f         (see $p and $f) ",
 "                      $k     Size of file in kilobytes       (K) ",
 "                      #k     ALLOCATED size of file          (K) ",
 "                      $m     Month of file        (jan, feb, .., dec) ",
 "                      #m     Month of file           (01, 02, .., 12) ",
 "                      $p     Disk and path of directory   (:\\path..) ",
 "                             If '\\' directory, then              (:) ",
 "                      #p     Path of directory             (\\path..) ",
 "                      $s     Size of file in bytes        () ",
 "                      #s     ALLOCATED size of file       () ",
 "                      $t     Time of file                  (HH:MM:SS) ",
 "                      #t     Time of file                     (HH:MM) ",
 "                      #u     Upper (PARENT) directory      () ",
 "                      $y     Year of file      (1980, 1981, .., 1999) ",
 "                      #y     Year of file            (80, 81, .., 99) ",
 "                      $=n    Skip to column 'n', e.g., $=30 or $=100  ",
 "                      $$     The symbol $                             ",
 "                      $#     The symbol #                             ",
 "                     Ĵ",
 "                        Token replacements are in all lowercase or   ",
 "                         all uppercase if the token is in lowercase   ",
 "                         or upper case, respectively.                 ",
 "                        All size tokens are replaced with '<DIR>'    ",
 "                         if directory entry is a subdirectory.        ",
 "                        Attribute tokens ($a, #a) are replaced by    ",
 "                         text: (R)ead-only (H)idden (S)ystem, (L)abel ",
 "                         (D)irectory (A)rchive ... or the hexadecimal ",
 "                         sum of the attribute bits, where (R)=0x01    ",
 "                         (H)=0x02 (S)=0x04 (L)=0x08 (D)=0x10 (A)=0x20,",
 "                         respectively.                                ",
 "                        The default format-string is:,               ",
 "                              \042$p\\$f$=40$s  $d $m #d, $t $y\042          ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /F\042$f $p$=35#s$s #m/#d/#y #t$=67$f\042          ",
 "Ĵ",
 "/G                    GO TO Directory (CHDIR) of matching file        ",
 "                        See also /Q switch.                          ",
 "Ĵ",
 "/H                    Include switches in effect at start of listing  ",
 "Ĵ",
 "/H    filename        Display heading lines contained in 'filename'   ",
 "                      at the beginning of each page of the listing.   ",
 "                        See also /L switch.                          ",
 "Ĵ",
 "/I     # spaces       Indentation for each column                     ",
 "                        See also /C switch.                          ",
 "Ĵ",
 "/L     # lines        Number of lines, including any user heading, to ",
 "                      constitute a page break.                        ",
 "                        See also /P switch.                          ",
 "Ĵ",
 "/M     option         Search Multiple Drives.                         ",
 "                        If /M switch is not given, then only current ",
 "                         drive will be searched.                      ",
 "                     Ĵ",
 "         A           Search all drives                               ",
 "         F            Include all Floppy Drives                       ",
 "         J            Include all JOIN'ed drives                      ",
 "         H           Include all Hard Drives                         ",
 "         N            Include all Network Drives                      ",
 "         S            Include all SUBST'ed drives                     ",
 "                     Ĵ",
 "                        Sequence of search is always in ascending,   ",
 "                         drive letter order.                          ",
 "                        Any drive failures will be skipped; it is    ",
 "                         okay to specify the A or F option and have   ",
 "                         one or more diskette drives empty...LOCATE   ",
 "                         will exclude them.  Therefore, make sure any ",
 "                         floppy is ready, or it will be bypassed with ",
 "                         no warning or error message.                 ",
 "                        /MA will bypass JOIN'ed and SUBST'ed drives. ",
 "Ĵ",
 "/P    [# lines]       Pause after every '# lines'                     ",
 "                        If '# lines' is not specified, then:         ",
 "                           If /L switch is present, its value will   ",
 "                            be used.                                  ",
 "                           If /L switch not present, 20 will be used ",
 "                        If output is redirected to a file or device, ",
 "                         or if the /H switch is specified, then this  ",
 "                         option is ignored                            ",
 "Ĵ",
 "/Q                    Query (Y or N) before each BATCH attempt or GO  ",
 "                      TO Directory attempt                            ",
 "                        See also /G and /X switches.                 ",
 "Ĵ",
 "/R  directory-name    Specify ROOT directory of operations.  LOCATE   ",
 "                      will then only operate in and under this ROOT.  ",
 "                        If /R switch is not given, the top directory ",
 "                         (\\) is the ROOT.                             ",
 "                        If directory-name is not specified, then the ",
 "                         current directory will be the ROOT.          ",
 "                        See also /E switch.                          ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /R..                root is parent directory ",
 "                        /R\\any\\where     root is a distant directory ",
 "                        /Runder      root is subdirectory of current ",
 "Ĵ",
 "/S     # bytes       Discriminate files by size.                     ",
 "                        If a positive file size is given, then only  ",
 "                         files that are greater than or equal to that ",
 "                         size will be processed.                      ",
 "                        If a negative file size is given, then only  ",
 "                         files that are smaller than that size will   ",
 "                         be processed.                                ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /S+100000              files  100,000 bytes ",
 "                        /S-512                     files < 512 bytes ",
 "Ĵ",
 "/S    sort-order      Selects sort order of each directory            ",
 "                     Ĵ",
 "         D           Sort by Date and Time                           ",
 "         E           Sort by File Extension                          ",
 "         N          Sort by File Name and Extension                 ",
 "         S           Sort by File Size                               ",
 "                     Ĵ",
 "                        Files can be sorted by ascending or descend- ",
 "                         ing order, by specifying 'sort-order' as a   ",
 "                         uppercase or lowercase letter, respectively. ",
 "                        Note: if multiple columns are selected (see  ",
 "                         /C switch), LOCATE will not compensate for   ",
 "                         the resulting disarray, and will output in   ",
 "                         horizontal, not vertical, progression.       ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /SN                             sort by name ",
 "                        /Ss                  sort by decreasing size ",
 "Ĵ",
 "/V    option          Verbosity Control                               ",
 "                        If /V switch is not given, no directories    ",
 "                         will be reported.                            ",
 "                     Ĵ",
 "        A            Report all directories that are visited         ",
 "        D           Report each directory containing reported files ",
 "        N             Do not include DIRS in file portion of listing  ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /VA            watch where LOCATE is looking ",
 "                        /VDN       show each directory and its files ",
 "Ĵ",
 "/X  command-string    Batches MSDOS command for each file located     ",
 "                        The actual command line batched to MSDOS is  ",
 "                         the text in 'command-string', with the tokens",
 "                         described for /F switch being replaced.      ",
 "                         file                                         ",
 "                        Token replacements are in all lowercase or   ",
 "                         all uppercase if the token is in lowercase   ",
 "                         or upper case, respectively.                 ",
 "                        See also /F and /Q switches.                 ",
 "                     ´",
 "                      EXAMPLES ص",
 "                     ϵ",
 "                        /X\042copy $f a:\042 /Q                            ",
 "                        /X\042edit $f\042                                  ",
 "                        locate %1 /oN /x\042locate $f /ec /f\\\042$$p\\$$f$$=",
 "                               40$$s  $$d $$m #d, $$t $$y\\\042\042         ",
 "",
 0L,
};
/*----------------------------------------------------------------
compile and link instructions:

 tcc -mc -K -X -d- -Tt -Tmx -wrvl -wsig -wcln -wpin -wtsv
     -wpro -wnod -wamb -waus -weff -wpia -wamp -wdef -wpar -wstv
     -wuse -wrng locate

(COMPACT memory model must be used if directories of humongous size
are to be handled)
-----------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dir.h>
#include <dos.h>
#include <bios.h>
#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>

#define OR	: case

struct subdir
{
	int qty;
	struct ffblk *file;
};

typedef int (*SORT_FUNC)(const void *obj1, const void *obj2);
static SORT_FUNC sortRoutine;

static int homeDisk, recent=0, formatChanged=0, past, indent=0;
static int sizeMode=0, batchMode=0, query=0, nLines=0, lineNum=999;
static int beforeMode=0, afterMode=0, heading=0, headQty=0, dirs=1;
static int attr=255, column=99, nColumns=1, sort=0, errorOccurred;
static int verbose=0, gotoMode=0, pause=0;
static int floppy=0, hard=0, network=0;
static int excludeHome=0, excludeRoot=0, excludeSubs=0, excludeRootOption=0;
static long lowSize, cluster;
static struct tm look, days;
static time_t t, today, before, after;
static char *batch, *command, *homeBase, *line;
static char *root = "\\";
static char *template = "*.*";
static char *format = "$p\\$f$=40$s  $d $m #d, $t $y";
static char **headText;
static char *more = "Press any key for MORE...";

#define NETWORK     (1 << 15)
#define PHYSICAL    (1 << 14)
#define JOIN        (1 << 13)
#define SUBST       (1 << 12)

typedef struct dpb
{
	char drive;
	char unit;
	unsigned bytesPerSector;
	char sectorsPerCluster;       // plus 1
	char shift;                   // for sectors per cluster
	unsigned bootSectors;          
	char copiesFat;
	unsigned maxRootDir;
	unsigned firstDataSector;
	unsigned highestCluster;
	union
	{
		struct
		{
			unsigned char sectorsPerFat;
			unsigned firstDirSector;
			void far *deviceDriver;
			char mediaDescriptor;
			char accessFlag;
			struct dpb far *next;
			unsigned long reserved;
		} dos3;
		struct
		{
			unsigned sectorsPerFat;       // WORD, not BYTE!
			unsigned firstDirSector;
			void far *deviceDriver;
			char mediaDescriptor;
			char accessFlag;
			struct dpb far *next;
			unsigned long reserved;
		} dos4;
	} vers;
} DPB;

typedef struct
{
	char currentPath[67];  // current path
	unsigned flags;		// NETWORK, PHYSICAL, JOIN, SUBST
	DPB far *dpb;		// pointer to Drive Parameter Block
	union
	{
		struct
		{
			unsigned startCluster; // root: 0000; never accessed: FFFFh
			unsigned long unknown;
		} LOCAL;        // if (! (cds[drive].flags & NETWORK))
		struct
		{
			unsigned long redirIFS;
			unsigned parameter;
		} NET;		// if (cds[drive].flags & NETWORK)
	} u;
	unsigned backslashOffset;	// offset in currentPath of '\'
					// DOS4 fields for IFS
					// 7 extra bytes...
} DEVDIR;

#pragma inline
DEVDIR far *currdir(unsigned drive)
{
	static char far *dir = NULL;
	static int status = -1;
	static unsigned currdirSize;
	static char lastdrv;

	if (status < 0)
	{
		unsigned drvOfs, lastdrvOfs;

		// curr dir struct not available in DOS 1.x or 2.x
		if (!(status = (_osmajor < 3) ? 0 : 1))
			return(NULL);

		// compute offset of curr dir struct and LASTDRIVE in DOS
	        // list of lists, depending on DOS version
		drvOfs = (_osmajor == 3 && _osminor == 0) ? 0x17 : 0x16;
		lastdrvOfs = (_osmajor == 3 && _osminor == 0) ? 0x1b : 0x21;

		asm	push	si
		asm	mov	ah,52h
		asm	int	21h
		asm	mov	si, lastdrvOfs
		asm	mov	ah, byte ptr es:[bx+si]
		asm	mov	lastdrv, ah
		asm	mov	si, drvOfs
		asm	les	bx, es:[bx+si]
		asm	mov	word ptr dir+2, es
		asm	mov	word ptr dir, bx
		asm	pop	si

		if (dir == (char far *) -1L)
			status = 0;

		currdirSize = (_osmajor >= 4) ? 0x58 : 0x51;

	}

	if (!status || (drive >= lastdrv))
		return(NULL);

	return((DEVDIR far *)(dir + (drive * currdirSize)));
}

static int query_process(char *name)
{
	int c;
	char dir[68];

	getcwd(dir, 63);
	if (strlen(dir) < 4)
		dir[2] = '\0';
	putchar('\n');
	while (1)
	{
		printf("%s\\%s ? [y/n] ", dir, name);
		c = getche();
		putchar('\n');
		c = tolower(c);
		if (c == 'y' || c == 'n')
			break;
	}
	return(c != 'n');
}

static void parse_date(char *ptr, time_t *clock)
{
	long d;
        short t;
	struct tm w;

	w = *(localtime(&today));
	for (t=0; isdigit(ptr[t]); ++t)
	{
		// do nothing
	}
	if (t > 4)
	{
		d = atol(ptr);
		w.tm_year = (int)(d % 100);
		w.tm_mon =  (int)(d / 10000L) - 1;
		w.tm_mday = (int)((d - (long)(w.tm_mon+1)*10000L) / 100L);
		ptr += t;
	}
	while (*ptr == ' ')
		++ptr;
	for (t=0; isdigit(ptr[t]); ++t)
	{
		// do nothing
	}
	if (t)
	{
		t = atoi(ptr);
		w.tm_hour = t / 100;
		w.tm_min = t % 100;
	}
	else
	{
		w.tm_hour = 0;
		w.tm_min = 0;
	}
	w.tm_sec = 0;
	*clock = mktime(&w);
}

static void create_format(char *fmtIn, char *fmtOut, struct ffblk *file)
{
	int copy=0, n;
	char *date, *fmt;
	char drive[8], dir[80], base[16], ext[8];

	fnsplit(file->ff_name, drive, dir, base, ext);
	date = ctime(&t);
	fmt = fmtOut;
	while (*fmtIn)
	{
		switch (*fmtIn)
		{
		   case '$':
			switch (*(++fmtIn))
			{
			   case 'a' OR 'A':
			   {
				int n, no = fmtIn[1]=='-';

				strcpy(fmtOut, "RHSLDA");
				for (n=0; fmtOut[n]; ++n)
				{
					if (no)
					{
						if (!(file->ff_attrib&(1<<n)))
							continue;
					}
					else
					{
						if (file->ff_attrib & (1<<n))
							continue;
					}
					fmtOut[n] = 0x20;
				}
				break;
			   }
			   case 'b' OR 'B':
				sprintf(fmtOut, "%-3s", base);
				break;
			   case 'c' OR 'C':
				if (file->ff_attrib & 0x10)
				{
					strcpy(fmtOut, " <DIR>");
					break;
				}
				sprintf(fmtOut, "%6ld", (file->ff_fsize +
						cluster-1) / cluster);
				break;
			   case 'd' OR 'D':
				memcpy(fmtOut, date, 3);
				fmtOut[3] = '\0';
				break;
			   case 'e' OR 'E':
				sprintf(fmtOut, "%-3s", ext);
				break;
			   case 'f' OR 'F':
				sprintf(fmtOut, "%-12s", file->ff_name);
				break;
			   case 'k' OR 'K':
				if (file->ff_attrib & 0x10)
				{
					strcpy(fmtOut, "  <DIR>");
					break;
				}
				{
			     	ldiv_t rat = ldiv(file->ff_fsize, 1024L);
				cprintf(fmtOut, "%5ld.%1dk", rat.quot,
					(int)((rat.rem * 10L) / 1024));
				}
				break;
			   case 'm' OR 'M':
				memcpy(fmtOut, date+4, 3);
				fmtOut[3] = '\0';
				break;
			   case 'p' OR 'P':
				getcwd(fmtOut, 63);
				if (strlen(fmtOut) < 4)
					fmtOut[2] = '\0';
				break;
			   case 's' OR 'S':
				if (file->ff_attrib & 0x10)
				{
					strcpy(fmtOut, "   <DIR>");
					break;
				}
				sprintf(fmtOut, "%8ld", file->ff_fsize);
				break;
			   case 't' OR 'T':
				memcpy(fmtOut, date+11, 8);
				fmtOut[8] = '\0';
				break;
			   case 'y' OR 'Y':
				memcpy(fmtOut, date+20, 4);
				fmtOut[4] = '\0';
				break;
			   case '=':
			   {
			     	short int n;
				n = atoi(++fmtIn) - (int)(fmtOut - fmt);
				while (n-- > 0)
				{
					*fmtOut++ = ' ';
				}
				for (n=0; isdigit(fmtIn[n]); ++n)
				{
					// do nothing
				}
				fmtIn += n - (copy=1);
				break;
			   }
			   default:
			       	*fmtOut++ = *fmtIn;
				copy = 1;
				break;
			   }
			   break;
		   case '#':
			switch (*(++fmtIn))
			{
			   case 'a' OR 'A':
				sprintf(fmtOut, "0x%02x", file->ff_attrib);
				break;
			   case 'd' OR 'D':
				memcpy(fmtOut, date+8, 2);
				fmtOut[2] = '\0';
				break;
			   case 'f' OR 'F':
				getcwd(fmtOut, 63);
				if (strlen(fmtOut) < 4)
					fmtOut[2] = '\0';
				sprintf(fmtOut+strlen(fmtOut),
						"\\%-12s", file->ff_name);
				break;
			   case 'k' OR 'K':
				if (file->ff_attrib & 0x10)
				{
					strcpy(fmtOut, "  <DIR>");
					break;
				}
				{
			     	ldiv_t rat = ldiv(((file->ff_fsize +
						cluster-1) / cluster) *
						cluster, 1024L);
				sprintf(fmtOut, "%5ld.%1dk", rat.quot,
					(int)((rat.rem * 10L) / 1024));
				}
				break;
			   case 'm' OR 'M':
				sprintf(fmtOut, "%02d", look.tm_mon);
				break;
			   case 'p' OR 'P':
				getcwd(fmtOut, 63);
				for (n=strlen(fmtOut); n>-1; n--)
				{
					if (fmtOut[n]=='\\'||fmtOut[n]=='/')
						break;
				}
				memcpy(fmtOut+n, fmtOut, n);
				break;
			   case 's' OR 'S':
				if (file->ff_attrib & 0x10)
				{
					strcpy(fmtOut, "   <DIR>");
					break;
				}
				sprintf(fmtOut, "%8ld", ((file->ff_fsize +
						cluster-1) / cluster) *
						cluster);
				break;
			   case 't' OR 'T':
				memcpy(fmtOut, date+11, 5);
				fmtOut[5] = '\0';
				break;
			   case 'u' OR 'U':
			   {
			   	char work[80];

				getcwd(work, 70);
			   	for (n=strlen(work); n>-1; --n)
				{
					if (work[n]=='\\' || work[n]=='/')
						break;
				}
				strcpy(fmtOut, work+n);
				break;
			   }
			   case 'y' OR 'Y':
				memcpy(fmtOut, date+22, 2);
				fmtOut[2] = '\0';
				break;
			   default:
			       	*fmtOut++ = *fmtIn;
				copy = 1;
				break;
			}
			break;
		   default:
		       	*fmtOut++ = *fmtIn;
			copy = 1;
			break;
		}
		if (!copy)
		{
			if (isupper(*fmtIn))
				strupr(fmtOut);
			else
				strlwr(fmtOut);
			fmtOut += strlen(fmtOut);
		}
		else
		{
			copy = 0;
		}
		++fmtIn;
	}
	*fmtOut = '\0';
}

static int sort_by_date(struct ffblk *file1, struct ffblk *file2)
{
	if (file1->ff_fdate == file2->ff_fdate)
		return((int)(file1->ff_ftime - file2->ff_ftime) * sort);
	return((int)(file1->ff_fdate - file2->ff_fdate) * sort);
}

static int sort_by_ext(struct ffblk *file1, struct ffblk *file2)
{
	char drive[8], dir[80], base[16], ext1[8], ext2[8];
	fnsplit(file1->ff_name, drive, dir, base, ext1);
	fnsplit(file2->ff_name, drive, dir, base, ext2);
	return(strcmp(ext1, ext2) * sort);
}

static int sort_by_name(struct ffblk *file1, struct ffblk *file2)
{
	return(strcmp(file1->ff_name, file2->ff_name) * sort);
}

static int sort_by_size(struct ffblk *file1, struct ffblk *file2)
{
	return((int)(file1->ff_fsize - file2->ff_fsize) * sort);
}

static void get_heading(char *fileName)
{ 
     	FILE *file;
  
  	if (!(file=fopen(fileName, "rt")))
	{
  		printf("Could not open heading file %s\n", fileName);
  		exit(7);
	}
	// first, find out how many lines there are
	while (fgets(line, 511, file))
		++headQty;
	rewind(file);
	headText = (char **)malloc(headQty * sizeof(char*));
	headQty = 0;
	while (fgets(line, 511, file))
		headText[headQty++] = strdup(line);
	fclose(file);
}

static void check_abort(void)
{
	int c;

	if (!kbhit())
		return;
	while (kbhit())
		c = getch();
	printf("\nPaused...ESC=end...any other key=continue");
	c = getch();
	printf("\r                                         \r");
	if (c != 0x1b)
		return;
	setdisk(homeDisk);
	chdir(homeBase);
	exit(9);
}

static void check_page_break(void)
{
	int n;

	if (++column >= nColumns)
	{
		putchar('\n');
		column = 0;
	 	if (nLines && (++lineNum > nLines))
		{
			putchar('\f');
			for (lineNum=0; lineNum<headQty; ++lineNum)
				printf("%s", headText[lineNum]);
		}
		else
		{
			if (pause && (++lineNum > pause))
			{
				printf(more);
			 	if (getch()==0x1b)
					exit(3);
				putchar('\r');
				lineNum = 0;
			}
		}
	}
	for (n=0; n<indent; ++n)
		putchar(' ');
}

static int directory(char *template, int att, struct subdir *info)
{
	struct
	{
		struct ffblk dir;
		char safety[128];
	} data;

	int qty=0, status = findfirst(template, &data.dir, 0xff);

	while (!status)
	{
		if (data.dir.ff_name[0] != '.' && ((att==0xff) ||
				(data.dir.ff_attrib & att)))
		{
		  	++qty;
		}
		status = findnext(&data.dir);
	}
	if (!(info->qty=qty))
		return(0);
	info->file = (struct ffblk *)malloc(sizeof(struct ffblk) * qty);
	qty = 0;
	status = findfirst(template, &data.dir, 0xff);
	while (!status)
	{
		if (data.dir.ff_name[0] != '.' && ((att==0xff) ||
				(data.dir.ff_attrib & att)))
		{
		  	info->file[qty++] = data.dir;
		}
		status = findnext(&data.dir);
	}
	if (sort)
	{
		qsort(info->file,info->qty,sizeof(struct ffblk),sortRoutine);
	}
	return(info->qty);
}

static void process_file(struct ffblk *file)
{					
	if (!dirs && (file->ff_attrib & 0x10))
		return;
	switch (sizeMode)
	{
	   case 1:
		if (file->ff_fsize < lowSize)
			return;
		break;
	   case 2:
	 	if (file->ff_fsize >= lowSize)
			return;
		break;
	}
	look.tm_year = 80 + ((file->ff_fdate >> 9) & 0x7f);
	look.tm_mon = ((file->ff_fdate >> 5) & 0x0f) - 1;
	look.tm_mday = file->ff_fdate & 0x1f;
	look.tm_hour = (file->ff_ftime >> 11) & 0x1f;
	look.tm_min = (file->ff_ftime >> 5) & 0x3f;
	look.tm_sec = (file->ff_ftime & 0x1f) * 2;
	t = mktime(&look);
	if (recent && (t < after))
		return;
	if (afterMode && (t < after))
		return;
	if (beforeMode && (t > before))
		return;
	if ((verbose==2) && (column>98))
	{
		check_page_break();
		getcwd(line, 63);
		printf("Directory %s", line);
		column=99;
	}
	check_page_break();
	create_format(format, line, file);
	printf("%s", line);
	if (gotoMode)
	{
		if (!query || query_process(file->ff_name))
			exit(5);
	}
	if (batchMode)
	{
		char dir[70];

		if (query && !query_process(file->ff_name))
			return;
		check_page_break();
		create_format(batch, command, file);
		getcwd(dir, 68);
		system(command);
		chdir(dir);
	}
}

static void search_drive(int level)
{
	int qty;
	char *home;
	struct subdir dir;
	struct ffblk *file;

	getcwd(line, 63);
	if (!excludeRoot && !(excludeHome && !strcmp(homeBase, line)))
	{
		if (verbose==1)
		{
			check_page_break();
			printf("Directory %s\n", line);
		}
		qty = directory(template, attr, &dir);
		for (file = dir.file; dir.qty--; ++file)
		{
			check_abort();
			process_file(file);
		}
		column = 99;
		if (qty)
			free(dir.file);
	}
	excludeRoot = 0;
	if (!excludeSubs)
	{
		if (directory("*.*", 0x10, &dir))
		{
			home = malloc(64);
			for (file = dir.file; dir.qty--; ++file)
			{
				check_abort();
				getcwd(home, 63);
				if (chdir(file->ff_name))
					continue;
				search_drive(level+1);
				chdir(home);
			}
			free(home);
			free(dir.file);
		}
	}
	if (level == 1)
		chdir(homeBase);
}

static int error_handler(void)
{
	errorOccurred = 1;
	hardretn(0);
	hardresume(0);
	return(0);
}

void process_drive(int drive)
{
	static struct fatinfo fat;

	errorOccurred = 0;
	setdisk(drive);
	if (errorOccurred)
		return;
	getfat(drive+1, &fat);
	getcwd(homeBase, 63);
	cluster = (long)((int)fat.fi_sclus * fat.fi_bysec);
	chdir(root);
	lineNum = (pause && !nLines) ? 0 : 999;
	column = 99;
	excludeRoot = excludeRootOption;
	search_drive(1);
}

static void help(int argc, char **argv)
{
	int n, s=-1, x, qty, inHelp;
	char helpWanted[26];
	char *bottom;

	memset(helpWanted, 0, qty=sizeof(helpWanted));
 	for (n = 1; n < argc; ++n)
	{
		if (argv[n][0] != '/')
			continue;
		x = toupper(argv[n][1])-'A';
		if (x > -1 && x < 26)
		{
			helpWanted[x] = 1;
			if (s < 0)
				s = x;
		}
	}
	argv = description;
	n = 0;
	if (s > -1)
	{
		while (*argv)
		{
			if (argv[0][0] == 192)
			{
				bottom = *argv;
				break;
			}
			++argv;
		}
		argv = description;
		for (n=0; *argv; ++argv, ++n)
		{
			puts(*argv);
			if (argv[0][0] == 195)
				break;
		}
	}
	for (inHelp=0; *argv; ++argv)
	{
 		if (s < 0)
			puts(*argv);
		else
		{
			if (!inHelp && argv[0][1] != '/')
				continue;
			if (!inHelp && (argv[0][2]-'A') != s)
				continue;
			if (inHelp && argv[0][1]=='/' && (argv[0][2]-'A')!=s)
			{
				inHelp = 0;
				while (++s < qty)
				{
					if (helpWanted[s])
						break;
				}
				if (s >= qty)
				{
					puts(bottom);
					return;
				}
				--argv;
				continue;
			}
			if (!inHelp)
			{
				inHelp = 1;
			}
			puts(*argv);
		}
		if (stdout->flags & _F_TERM)
		{
			if (++n > 18)
			{
				printf(more);
			 	if (getch()==0x1b)
					exit(3);
				putchar('\r');
				n = 0;
			}
		}
	}
}

int main(int argc, char **argv)
{
	int n, attrSet, drive, lastDrive;
	char *arg, *sw;
	unsigned char far *floppyFlag = (unsigned char far *)0x504L;

 	line = malloc(1024);
 	today = time(NULL);
 	for (n = 1; n < argc; ++n)
	{
		sw = argv[n];
		switch (sw[0])
		{
		   case '/':
			arg = sw+2;
			switch (sw[1])
			{
			   case 'a' OR 'A':
				if (!*arg && (argv[n+1][0] != '/'))
				{
					arg = argv[++n];
				}
				if (isdigit(*arg))
				{
					afterMode = 1;
					parse_date(arg, &after);
					break;
				}
				attr = 0;
				while (*arg)
				{
					switch (*arg++)
					{
					   case 'r' OR 'R':
						attrSet = FA_RDONLY;
						break;
					   case 'h' OR 'H':
						attrSet = FA_HIDDEN;
						break;
					   case 's' OR 'S':
						attrSet = FA_SYSTEM;
						break;
					   case 'l' OR 'L':
						attrSet = FA_LABEL;
						break;
					   case 'd' OR 'D':
						attrSet = FA_DIREC;
						break;
					   case 'a' OR 'A':
						attrSet = FA_ARCH;
						break;
					}
					if (*arg == '-')
					{
						attr = attr & (~attrSet);
						++arg;
					}
					else
					{
						attr |= attrSet;
					}
				}
				break;
			   case 'b' OR 'B':
				if (!*arg && (argv[n+1][0] != '/'))
				{
					arg = argv[++n];
				}
				beforeMode = 1;
				parse_date(arg, &before);
				break;
			   case 'c' OR 'C':
				nColumns = atoi(arg);
				break;
			   case 'd' OR 'D':
				recent = 1;
				days = *localtime(&today);
				if ((past = atoi(arg)) < 1)
					past = 1;
				days.tm_mday -= (past-1);
				days.tm_hour = 0;
				days.tm_min = 0;
				days.tm_sec = 0;
 				after = mktime(&days);
				break;
			   case 'e' OR 'E':
				if (!*arg)
				{
					excludeHome = 1;
					break;
				}
				while (*arg)
				{
					switch (*arg++)
					{
					   case 'r' OR 'R':
						excludeRootOption = 1;
						break;
					   case 's' OR 'S':
						excludeSubs = 1;
						break;
					   case 'c' OR 'C':
						excludeHome = 1;
						break;
					}
				}
				break;
			   case 'f' OR 'F':
				if (!*arg && (argv[n+1][0] != '/'))
				{
					arg = argv[++n];
				}
				formatChanged = 1;
				format = malloc(256);
				strcpy(format, arg);
				break;
			   case 'g' OR 'G':
				gotoMode = 1;
				break;
			   case 'h' OR 'H':
				heading = 1;
				if (*arg)
					get_heading(arg);
				break;
			   case 'i' OR 'I':
				indent = atoi(arg);
				break;
			   case 'l' OR 'L':
				nLines = atoi(arg);
				break;
			   case 'm' OR 'M':
			   {
				hard = 1;
				while (*arg)
				{
					switch (*arg++)
					{
					   case 'f' OR 'F':
						floppy = 1;
						break;
					   case 'n' OR 'N':
						network = 1;
						break;
					   case 'a' OR 'A':
						floppy = 1;
						network = 1;
						break;
					}
				}
				break;
			   }
			   case 'p' OR 'P':
				if (!(stdout->flags & _F_TERM))
					break;
				if (*arg)
					pause = atoi(arg);
				else
					pause = -1;
				break;
			   case 'q' OR 'Q':
				query = 1;
				break;
			   case 'r' OR 'R':
				if (!*arg)
					arg = ".";
				root = arg;
				break;
			   case 's' OR 'S':
				switch (*arg)
				{
				   case '+' OR '-':
					sizeMode = 1;
					if ((lowSize = atol(arg))<1)
					{
						sizeMode = 2;
						lowSize = labs(lowSize);
					}
					break;
				   case 'd' OR 'D':
					sortRoutine = (SORT_FUNC)sort_by_date;
					break;
				   case 'e' OR 'E':
					sortRoutine = (SORT_FUNC)sort_by_ext;
					break;
				   case 'n' OR 'N':
					sortRoutine = (SORT_FUNC)sort_by_name;
					break;
				   case 's' OR 'S':
					sortRoutine = (SORT_FUNC)sort_by_size;
					break;
				   default:
					printf("Invalid /S option:  %s\n",
								arg);
					puts("Use /? for help");
					exit(1);
				}
				if ((*arg != '+') && (*arg != '-'))
					sort = isupper(*arg) ? 1 : -1;
				break;
			   case 'v' OR 'V':
				if (!*arg)
				{
					verbose = 2;
					break;
				}
				while (*arg)
				{
					switch (*arg++)
					{
					   case 'a' OR 'A':
						verbose = 1;
						break;
					   case 'd' OR 'D':
						verbose = 2;
						break;
					   case 'n' OR 'N':
						dirs = 0;
						break;
					}
				}
				break;
			   case 'x' OR 'X':
				if (!*arg && (argv[n+1][0] != '/'))
				{
					arg = argv[++n];
				}
				batchMode = 1;
				batch = malloc(256);
				command = batch + 128;
				strcpy(batch, arg);
				break;
			   case '?':
			   	help(argc, argv);
		 		exit(2);
			   default:
				printf("Invalid option:  %s\n", sw);
				puts("Use /? for help");
				exit(1);
			}
			break;
		   default:
			template = sw;
			break;
		}
	}
	if (pause < 0)
		pause = nLines ? nLines : 20;
	if (!headQty)
		nLines = 0;
	if (heading && !headQty)
	{
		if (afterMode)
			printf("/A: Files after %s", ctime(&after));
		if (beforeMode)
			printf("/B: Files before %s", ctime(&before));
		if (nColumns > 1)
			printf("/C: List %d columns\n", nColumns);
		if (recent)
			printf("/D: Files %d days old\n", past);
		if (formatChanged)
			printf("/F: Format: %s\n", format);
		if (nLines)
			printf("/L: %s lines per page\n", nLines);
		if (strcmp(root, "\\"))
			printf("/R: Root Directory is %s\n", root);
		switch (sizeMode)
		{
		   case 1:
			printf("/S: Files at least %ld bytes in size\n",
					lowSize);
			break;
		   case 2:
			printf("/S: Files less than %ld bytes in size\n",
					lowSize);
			break;
		}
		if (attr != 0xff)
			printf("/A: Attributes: 0x%02x\n", attr);
		if (batchMode)
			printf("/X: Batch specified is: %s\n", batch);
	}
	harderr(error_handler);
	homeBase = malloc(64);
	lastDrive = setdisk(homeDisk=getdisk());
    	for (drive=0; drive<lastDrive; ++drive)
	{
		int status;
		DEVDIR far *dir;

		if (drive == homeDisk)
		{
			process_drive(drive);
			continue;
		}
		if ((drive>1 && !hard))
			continue;
		if (drive<2 && !floppy)
			continue;
		if (drive > 1)
		{
			if (((dir = currdir(drive)) != NULL) &&
					dir->flags && !(dir->flags & JOIN) &&
					!(dir->flags & SUBST) &&
					!((dir->flags & NETWORK) && !network))
				process_drive(drive);
			continue;
		}
		status = biosdisk(4, drive, 0, 0, 1, 1, line);
		if (!status || status==0x06)
			process_drive(drive);
	}
	setdisk(homeDisk);
	chdir(homeBase);
	return(0);
}
