/* 0-byte.c */

/*
    DESCRIPTION:
    Accepts a DIR listing from Standard Input, and produces a 0-byte
    length file for each file listed in the DIR listing.

    Subidirectories are ignored.

    USAGE:

	DIR \target\subdirectory | 0-BYTE > capture.cap

    The 0-byte-length files will be created in the current subdirectory.
    0-byte will not overwrite existing files. Check CAPTURE.CAP for
    the names of duplicate files found.

    dap@kandy.com  11/26/93
*/

/*
    HISTORY:
    If you find a bug, report it. Otherwise it probably won't get fixed.

    11/27/93 v1.1 Sets date and time of 0-byte file to reflect date
	     and time of original file.
    11/26/93 v1.0 Initial release. First (and hopefully last) version.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <errno.h>

main()
{
  unsigned  dos_handle;
  unsigned  mo, da, yr, hr, mn;
  unsigned  dat, tim;
  char      *k;
  char      buf[512];

  fprintf(stderr, "0-BYTE v1.1 <dap@kandy.com>\n");
  fprintf(stderr, "Last compiled on %s at %s\n\n", __DATE__, __TIME__);

  while((fgets(buf, 511, stdin))!=NULL)
  {
    if((strstr(buf, "<DIR>"))!=NULL)
      continue;

    if(*buf==' ' || *buf=='\n')
      continue;

    mo=(unsigned)atoi(buf+23);
    da=(unsigned)atoi(buf+26);
    yr=(unsigned)(atoi(buf+29)-80);
    dat = (yr << 9) | (mo << 5) | da;

    hr=(unsigned)atoi(buf+33);
    if(*(buf+38)=='p')
      hr+=12;
    mn=(unsigned)atoi(buf+36);
    tim = (hr << 11) | (mn << 5);

    *(buf+12)='\0';

    k=strchr(buf, ' ');
    *k='.';

    k++;
    while(*k==' ')
      strcpy(k, k+1);

    if((k=strchr(buf, ' '))!=NULL)
      *k='\0';

    if(!strcmp(buf, "...") || !strcmp(buf, ".."))
      continue;

    if(_dos_creatnew(buf, 0, &dos_handle))
    {
      if(errno==EACCES)
	fprintf(stderr, "ERROR: %c%c%c%s: %s\n", (char)7, (char)7, (char)7,
		buf, "Permission denied");
      else if(errno==EEXIST)
      {
	fputc(7, stderr);
	printf("%s EXISTS and will not be overwritten!\n", buf);
      }
      else if(errno==EMFILE)
	fprintf(stderr, "ERROR: %c%c%c%s: %s\n", (char)7, (char)7, (char)7,
		buf, "Too many open files");
      else if(errno==ENOENT)
	fprintf(stderr, "ERROR: %c%c%c%s: %s\n", (char)7, (char)7, (char)7,
		buf, "No such file or directory");
      else
	fprintf(stderr, "ERROR: %c%c%c%s: %s\n", (char)7, (char)7, (char)7,
		buf, "Unknown error");
    }
    else
    {
      _dos_setftime(dos_handle, dat, tim);
      printf("%s\n", buf);
      _dos_close(dos_handle);
    }
  }
  exit(0);
}
