/***************************************************************************

                                  joy_tst

                             by Brian Koetting

***************************************************************************/

#include <proto/intuition.h>
#include <stdio.h>

struct IntuitionBase *IntuitionBase;

/*	This is the value of the IDCMP_RAWKEY code value that means:
	"This is a joystick event, brought to you courtesy of JoyRide"
*/

#define JOY_CODE 0x7F

/**************************************************************************/

/*	This routine shows how to determine the status of the joystick.
	Note that basically all you have to do is check the presence
	of each applicable bit of the qualifier UWORD.
	See JoyRide.Doc for details.

	Next, I simply draw a square to indicate the direction chosen.
*/

void draw_joy_status(struct RastPort *rp, UWORD status)
{
	static UWORD old_status = 0;

	/*	By performing an Exclusive-OR with the previous status,
		I get only the bits that have changed.
	*/
	old_status ^= status;

	if(old_status & IEQUALIFIER_LEFTBUTTON) RectFill(rp,90,40,110,60);
	if(old_status & IEQUALIFIER_RSHIFT) RectFill(rp,115,40,135,60);
	if(old_status & IEQUALIFIER_LSHIFT) RectFill(rp,65,40,85,60);
	if(old_status & IEQUALIFIER_RALT) RectFill(rp,90,65,110,85);
	if(old_status & IEQUALIFIER_LALT) RectFill(rp,90,15,110,35);

	old_status = status; /* save previous status for next time. */

	return;
}

/**************************************************************************/

/*	In the main function, we'll just open a simple window,
	and hang around waiting for either a joystick event or
	a signal that the user wants to quit (either closewindow or escape)

	Note that we do _NO_ opening of the gameport.device, or anything
	else to otherwise setup the joystick port.
*/

void main(void)
{
	struct Window *wndw;
	struct IntuiMessage *imsg;
	struct RastPort *rp;
	ULONG iclass;
	UWORD icode, iqual;
	BOOL go = TRUE;

	IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",0);
	if(wndw = OpenWindowTags(NULL,
		WA_Left, 50,
		WA_Top, 50,
		WA_Width, 200,
		WA_Height, 100,
		WA_IDCMP,IDCMP_RAWKEY|IDCMP_CLOSEWINDOW,
		WA_Flags,WFLG_SMART_REFRESH|WFLG_ACTIVATE|
			WFLG_DRAGBAR|WFLG_CLOSEGADGET|WFLG_DEPTHGADGET,
		WA_Title,"JoyRide Test",
		TAG_DONE)
	) {

		rp = wndw->RPort;
		SetDrMd(rp,COMPLEMENT);

		while(go) {
			Wait(1<<wndw->UserPort->mp_SigBit);

			while(imsg = (struct IntuiMessage *)GetMsg(wndw->UserPort)) {
				iclass = imsg->Class;
				icode = imsg->Code;
				iqual = imsg->Qualifier;
				ReplyMsg(imsg);

				switch(iclass) {
				case IDCMP_CLOSEWINDOW:
					go = FALSE;
					break;
				case IDCMP_RAWKEY:
					if(icode == JOY_CODE) {
		/* Here it is!  A joystick event! */
						draw_joy_status(rp,iqual);
					}
					else if(icode == 0x45) go = FALSE;
					break;
				}
			}
		}
		CloseWindow(wndw);
	}
	CloseLibrary((struct Library *)IntuitionBase);
	return;
}

/**************************************************************************/
