FACT SHEET:      WIDE-FIELD AND PLANETARY CAMERA-II



      When astronomers open their great mountaintop observatories
to the heavens, their powerful telescopes serve as time machines
to uncover events as they happened hundreds, thousands, millions
or billions of years in the past.  Peering back through space and
time on a clear, dark night, large telescopes can resolve distant
galaxies at the edge of the observable universe -- revealing them
as they would have appeared long ago, when the universe was much
younger than it is now.

      Even on the summits of remote mountains where the air is
clear and the night skies are free from the glare of city lights,
slight density variations in the overlying ocean of air cause
light rays to bend, resulting in the blurring of images that
often interferes with telescopic observations.  The great joy in
an astronomer's life is the rare night of good "seeing," when the
air is calm and the stars appear steady and sharp.  Even then,
absorption by the constituents of the atmosphere blocks radiation
from reaching the ground, except in narrow spectral windows at
visible and near infrared wavelengths.

      Visionary astronomers had long dreamed of operating
telescopes above the obscuring and turbulent layers of Earth's
atmosphere.  With the historic launch of NASA's Edwin P. Hubble
Space Telescope, carrying the Wide-Field and Planetary Camera
among its retinue of scientific instruments, astronomers of today
are seeing these dreams become a reality. 

      Using the Hubble Space Telescope, astronomers are already
gaining new insights into the nature of galaxies -- the building
blocks of the universe -- and into the major constituents of our
own Milky Way galaxy, where stars and star-forming clouds of gas
and dust lie.  Newly observable Cepheid variable stars are
helping to measure cosmic distances with greater accuracy than
ever before.  Astronomers are able to see and measure uncharted
regions of the ultraviolet spectrum, where many quasar emissions
and telltale signatures of intergalactic hydrogen gas lie hidden
from ground-based observation.

      Closer to home, many of the remarkable features of our own
planetary system are visible in new detail.  For instance, the
gaseous giants Jupiter and Saturn and their corresponding
satellites, photographed at close range during the flybys of the
Voyager spacecraft in the 1970s and 1980s, are observable in fine
detail using the orbiting Hubble Space Telescope. 


THE WIDE-FIELD AND PLANETARY CAMERA

      The first-generation Wide-Field and Planetary Camera (WFPC-
I), launched on April 24, 1990, is one of five scientific data-
gathering instruments onboard the Hubble Space Telescope (HST). 
Designed and built by the California Institute of Technology's
Jet Propulsion Laboratory under contract to NASA, the camera
occupies the prime location at the center of the telescope's
focal plane and provides key imaging capability for both
planetary and deep-sky objects, such as star clusters and
galaxies.  

      By the time WFPC-I was launched, a second-generation
replacement instrument, the Wide-Field and Planetary Camera-II
(WFPC-II) was in the early stages of construction.

      Two months after the launch, scientists detected a flaw --
an error of curvature termed spherical aberration -- in the
telescope's 2.4-meter-diameter (94.5-inch) primary mirror. 
Subsequent studies of star images returned by the telescope
showed that the surface of the mirror was too flat by an amount
equal to about 1/50th the width of a human hair.  With the flaw,
only about 12 percent of the light is brought into focus within a
circle with a diameter of 0.2 arc second rather than the
originally specified 70 percent of the light.  (An arc second is
an angular measure equaling 1/3,600th of a degree.)

      As a result, light is spread out over a much larger area in
a fuzzy halo rather than being focused into a sharp, pointed
image.  For compact bright objects, computer image processing has
been successful in restoring to a considerable extent the
telescope's intended image sharpness or resolution.  However, for
diffuse objects, very faint compact objects and objects located
in crowded star fields, computer processing is not effective. 
Consequently, these objects cannot be satisfactorily studied by
WFPC-I.

      During the first Hubble Space Telescope servicing mission,
planned for December 1993 aboard the space shuttle Endeavour,
WFPC-I will be replaced by the recently completed second-
generation instrument, WFPC-II.

      The original purpose of WFPC-II was to provide a backup for
WFPC-I, which had been designed and built in the late 1970s and
early 1980s.  Several design changes had been made to enhance
WFPC-II's overall imaging capability.  They included the use of
newly available, low-noise charge-coupled device (CCD) light
detectors, an upgraded set of spectral filters and a flat-field
photometric calibration system. 

      Because of the flaw in HST's primary mirror, the task to be
undertaken by WFPC-II grew to include the correction of the
blurred incoming light by means of modifications that could be
built into WFPC-II's relay optics.  To enable these modifications
to work correctly and reliably in orbit, WFPC-II was further
modified to include mechanisms to permit remote control alignment
of its corrective optical system relative to the telescope.  This
is achieved by means of an articulated pickoff mirror and three
articulated fold mirrors within the instrument. 

      With these modifications, WFPC-II is expected to fully
restore the originally planned imaging capability of the HST
within a field of view covered by the three wide-field camera
channels and one planetary camera channel in WFPC-II.  The
ability to obtain crisp images from the near infrared to the far
ultraviolet promises to revitalize the HST science community,
whose diverse interests range from observations of nearby planets
to studies of the most distant objects in the observable
universe.


THE HUBBLE SPACE TELESCOPE

      The Hubble Space Telescope was launched and deployed into
orbit 600 kilometers (330 nautical miles or 370 statute miles)
above Earth's surface from NASA's space shuttle Discovery on
April 24, 1990.  The telescope orbits Earth once every 95
minutes.

      For a planned 15 years until 2005, the telescope and its
imaging instruments, including WFPC-I and WFPC-II, will study
objects ranging from asteroids, comets and planets within our
solar system to galaxies and quasars at the farthest and oldest
reaches of the universe.

      In conjunction with the space telescope, WFPC-II provides
images which are sharper and more steady than any attainable from
Earth's surface at visible wavelengths, and provides access to
ultraviolet wavelengths which are completely inaccessible to
ground-based observatories.  

      For distant galaxies, WFPC-II's sharp and steady images will
stand out more clearly from the background, allowing astronomers
to study detailed structures and populations of stars at much
greater distances than possible from the Earth.  Our knowledge of
such details will be extended by a factor of seven deeper in
space and farther back in time.

      The space telescope is 13.1 meters (43 feet) long and 4.3
meters (14 feet) in diameter and about the size of a railroad
tank car.  It weighs 12,000 kilograms (26,000 pounds), about as
much as eight automobiles.

      Light from distant space objects enters the telescope's tube
at one end and strikes the primary mirror 2.4 meters (94.5
inches) in diameter.  The light reflected by the mirror then
converges toward the secondary mirror, located 4.9 meters (16
feet) in front of the primary mirror.  The secondary mirror is
only 30 centimeters (12 inches) in diameter.  From there, the
beam of light narrows further and intensifies, passing through a
60-centimeter (24-inch) hole in the center of the primary mirror.

      The light is then measured by one of the science
instruments.  While four of the telescope's five instruments are
mounted directly behind and perpendicular to the focal plane,
WFPC-II is mounted radially in the telescope, and light from the
focal plane is deflected into the camera by a pickoff mirror.  In
all, the science instruments include:

      -- The Wide-Field and Planetary Camera, which provides
photometric imaging over a wide field of view from the far
ultraviolet to the near infrared;

      -- The Faint Object Camera, designed for higher spatial
resolution over a relatively small field of view, primarily in
the ultraviolet;

      -- The Faint Object Spectrograph, which examines the
ultraviolet and visible spectra of distant objects in order to
study their chemistry;

      -- The Goddard High Resolution Spectrograph, providing the
sharpest discrimination of spectra in the ultraviolet;

      -- The High Speed Photometer, which measures the brightness
of sources and rapid changes in their brightness over time.

      The science instruments generate data in digital form, which
are transmitted to the ground via NASA's Tracking and Data Relay
Satellite System (TDRSS).  The data are then converted into
pictures and other usable forms.

      Electrical power for the space telescope is provided by two
arrays of 48,000 solar cells positioned like a pair of wings on
either side of the telescope's main tube.  Power is stored in six
batteries so that operations are continuous, even when the
telescope is in Earth's shadow.

      The space telescope's pointing control system is responsible
for moving the telescope and pointing it at the celestial object
selected for study.  The system is made up of gyroscopes,
momentum wheels, magnetic torquers and star trackers, which can
keep the telescope pointed to within 7/1000ths (0.007) of an arc
second -- the equivalent of locking onto a dime in San Francisco
from Los Angeles (or in Washington, D.C., from Boston) more than
650 kilometers (400 miles) away.

      Other support systems include the space telescope's main
computer, which controls the overall spacecraft; high-gain
antennas, which receive ground commands and transmit data back to
Earth; a thermal control system using thermal blankets and a
network of tiny heaters to keep the telescope within an
acceptable temperature range; and a safing system, designed to
control the telescope to protect it from damage in the event of
serious computer problems or loss of communication with ground-
controllers.


HST PERFORMANCE REPORT AND NEW OPTICAL REQUIREMENTS

      The space telescope's optical system was designed to
concentrate 70 percent of the light in a star image inside a
circle 0.2 arc second in diameter.  The flaw in the telescope's
primary mirror caused a significant degradation in this
performance, allowing only 12 percent of the light to fall within
such a circle.  

      The remainder of the light is spread over a larger region in
the focal plane, causing a blurred rather than sharply focused
image to arrive at all of the science instruments.  Images that
require a great deal of clarity and detail, such as binary stars
orbiting each other at close range, or star clusters containing
thousands of individual stars enveloped by dust or luminous gas,
suffer from the loss of spatial resolution.

      The second-generation Wide-Field and Planetary Camera had
been under construction for four years when the aberration in the
primary mirror was discovered.  In order to recover from the
space telescope's defect as quickly as possible, the schedule to
complete WFPC-II was accelerated, and a requirement was added
that the camera's internal optical system be redesigned to
compensate for HST's spherical aberration.

      This was accomplished by altering the mirrors in WFPC-II's
relay optics in such a way as to introduce exactly the opposite
spherical aberration into the relays.  The new shape in the
optics would cancel the aberration of the telescope's primary
mirror.

      The corrected imaging performance of the Hubble Space
Telescope would also require 10 times more precise alignment of
its optical components than was necessary with the first Wide-
Field and Planetary Camera.  Miniature images of HST's primary
mirror formed within WFPC-II would have to be centered to within
less than 0.1 millimeter (0.004 inch) on the dime-sized secondary
mirrors of the relay cameras.  If not, another aberration -- coma
-- would be introduced, quickly defeating the purpose of the
corrective optical design.

      To assure accurate alignment, WFPC-II includes four new
alignment mechanisms that can be controlled from the ground.  The
previously fixed pickoff mirror and three of four fixed "fold"
mirrors in WFPC-I were replaced in WFPC-II by articulated,
adjustable mirrors than can be tipped and tilted to assure that
the light beam from the telescope falls precisely on the centers
of the relay secondary mirrors after the instrument is launched
and installed in the orbiting HST.


WFPC-II SCIENCE OBJECTIVES

      During its lifetime, the Hubble Space Telescope will see
distant galaxies and quasars, the stars and stellar systems of
our Milky Way galaxy and the constituents of our own solar
system, including planets with their accompanying satellites,
asteroids and comets.  Perhaps HST will detect planetary systems
around other stars.

      While solar system studies by WFPC-II will uncover treasures
of new information, the real gold mine for celestial prospectors
is expected to lie in distant fields.

      The WFPC-II project exerted unprecedented efforts to
eliminate contamination to maximize the sensitivity of the
instrument to light in the far ultraviolet regions of the
spectrum.  WFPC-II is especially sensitive to wavelengths around
1216 angstroms, the wavelength of the strongest emission line
(Lyman-alpha) of atomic hydrogen.  Since ultraviolet imaging from
ground-based telescopes is prevented by atmospheric absorption,
WFPC-II will be uniquely capable of observing in this
scientifically fascinating region.

      Astronomers have set for themselves three major tasks in the
field of cosmology, the study of the origin and evolution of the
universe:  to refine and extend the scale of cosmic distances; to
understand how galaxies evolved from the earliest times to the
present; and to test fundamental theories of the expanding
universe.

      Astronomical distances are measured by a variety of
carefully devised methods, all of which depend upon a knowledge
of the distance from Earth to the sun.  Distances to the nearest
stars are established by direct triangulation as Earth moves in
its orbit around the sun.  These stars are then used to calibrate
still greater distances from brightness measurements of stars in
clusters. 

      The great achievement enabling astronomers to measure the
distances between galaxies was the discovery by Henrietta Leavett
early in this century that certain highly luminous variable stars
-- Cepheids -- have a definite relation between the period of
their light variation and their absolute luminosity.  Thus, the
apparent brightness of Cepheids detected in a relatively nearby
galaxy can be used to estimate the distance to that galaxy.

      The most distant galaxies are much too far away to allow
individual stars -- even Cepheids -- to be seen.  Their distances
can only be estimated in terms of the general expansion of the
universe; the velocity of recession (or red shift of spectral
lines) increases with increasing distance.

      But in that method lies a seed of doubt:  We reside in an
immense cluster of galaxies, whose mutual gravitational
attraction may alter their motions, or the apparent universal
expansion inferred from them.  Extrapolated to yet larger samples
of the universe, small effects from this cause could build up to
significant error.

      How do astronomers hope to surmount this problem?  The
straightforward answer is to obtain even better, more precise
measurements.  WFPC-II will be able to measure stars in distant
galaxies 100 times fainter than the 5-meter (200-inch) Hale
Telescope atop Palomar Mountain near San Diego, Calif.  The
capability will enable astronomers to detect and measure Cepheid
variables in galaxies that, until now, have been too distant to
calibrate.  By so doing, measurements of the distances to local
galaxies will, for the first time, be tied to the scale of
distances to great clusters of galaxies outside the local group.

      The WFPC-II supports many other investigations across a
diverse range of astronomical topics.  Objectives established by
the WFPC-II science team are:

      -- To calibrate the cosmic distance scale to within an error
of not more than 10 percent;

      -- To investigate the evolution of distant and local
galaxies;

      -- To study populations of stars in distant galaxies and
crowded fields;

      -- To examine the detailed structure and surroundings of
distant sources such as quasars;

      -- To observe cloud motions and identify compositions of
planetary atmospheres in our solar system.


THE SECOND-GENERATION WIDE-FIELD AND PLANETARY CAMERA (WFPC-II)

      The WFPC-II instrument comprises four camera systems:  three
wide-field cameras having one magnification, and one planetary
camera having a magnification of about 2.2 times greater.

      The wide-field cameras provide the greatest sensitivity for
the discovery of faint objects.  They have a focal ratio of
f/12.9, a field of view of 2.67 arc minutes on a side, and a
resolution of 0.1 arc second per picture element, or pixel.  (An
arc minute is an angular measure equaling 1/60th of a degree.)

      The planetary camera facilitates high-resolution studies of
individual objects such as planets, galaxies and stellar systems. 
This camera has a focal ratio of f/28.3, a field of view of 34.2
arc seconds (0.57 arc minutes) on a side, and a resolution of
0.046 arc second per pixel.  This resolution would allow the
camera to resolve a baseball-sized object from a distance of
about 400 kilometers (250 miles).

      When light comes to a focus within the camera, it is
transformed into electrical signals by solid-state imaging
sensors, called charge-coupled devices (CCDs).  All four WFPC-II
camera systems are equipped with new, highly improved CCD
detector arrays, each containing 640,000 pixels arranged in 800
rows and 800 columns.  Transmitted back to Earth and recombined
as a mosaic, the image produced by the four CCDs contains 2.56
million pixels.

      The cameras are sensitive to light at wavelengths ranging
from ultraviolet to the near infrared (1,200 to 10,000
angstroms).  Forty-eight different color filters mounted on 12
filter wheels can be deployed selectively in front of the
cameras.  The filter set includes wide-band ultraviolet filters
that transmit light only shortward of 2,000 angstroms.  Exposure
times are controlled by an electrically operated shutter. 
Shutter speeds can be varied from 110 milliseconds (about 1/10th
second) to 28 hours.

      On Earth the WFPC-II instrument weighs 281 kilograms (619
pounds).  In orbit, it consumes an average of 200 watts of
electrical power.  A system consisting of a radiator, heat pipes
and thermoelectric coolers keeps the CCDs at selected constant
temperatures of between -22 degrees and -90 degrees Celsius (-8
and -130 degrees Fahrenheit).  The cold operating temperatures
are needed to keep the background signal in the CCDs at a
minimum.


THE HUBBLE SPACE TELESCOPE SERVICING MISSION

      STS-61 is the first of a series of planned Hubble Space
Telescope servicing missions.  It is tentatively scheduled for
launch at 4:57 a.m. Eastern Standard Time on Dec. 1, 1993.  The
mission was originally designed to replace major components of
the space telescope and its science instruments as improved
technologies became available.  Because of several problems that
have occurred since the telescope was launched, the first mission
will be largely one of repair and maintenance.

      The principal goals of STS-61 are to correct for the primary
mirror's spherical aberration by removing WFPC-I and installing
WFPC-II, and removing the High Speed Photometer and installing in
its place the Corrective Optics Space Telescope Axial Replacement
(COSTAR), which will focus light entering the remaining three
axial instruments.

      Also planned for STS-61 is replacement of the telescope's
solar arrays to stabilize the vibration that occurs each time the
telescope crosses from daylight into the cold darkness of Earth's
shadow.  The STS-61 astronauts will also replace several
gyroscope units and computers, and make repairs to the High
Resolution Spectrometer.


ORGANIZATIONS AND PERSONNEL

      Larry Simmons at the Jet Propulsion Laboratory is the WFPC-
II program manager.  Dr. John Trauger at JPL is the WFPC-II
principal investigator.

      Overall management of the Hubble Space Telescope project is
the responsibility of NASA's Goddard Space Flight Center in
Greenbelt, Md.  NASA's Marshall Space Flight Center in
Huntsville, Ala., was responsible for telescope development and
launch.  The Space Telescope Science Institute at Johns Hopkins
University in Baltimore, Md., is operated by Associated
Universities for Research in Astronomy Inc. under contract to
NASA's Goddard Space Flight Center.

      The optical telescope assembly of HST was fabricated by the
Perkin-Elmer Corporation (now Hughes Danbury Optical Systems
Inc.) in Danbury, Conn.  The telescope was integrated by Lockheed
Missiles and Space Corporation in Sunnyvale, Calif.

      The European Space Agency provided the space telescope's
solar arrays and the Faint Object Camera.  Other instrument
sources are: the Faint Object Spectrograph, built by Martin
Marietta Astronautics for the University of California at San
Diego; the High Resolution Spectrograph, built by Ball Aerospace
Corp., Boulder, Colo., for Goddard Space Flight Center; and the
High Speed Photometer, built by the University of Wisconsin at
Madison, which will be replaced by COSTAR.

      WFPC-II was designed and built by the California Institute
of Technology's Jet Propulsion Laboratory for NASA's Office of
Space Science, Washington, D.C.

                           #####

11-2-93 DEA
