'* ************************************************************* *
'* demo3.bas For QuickBASIC - Demonstrates how to set palettes   *
'*                                                               *
'* Use the RM to create palette tables.                          *
'* ************************************************************* *

DEFINT A-Z
DECLARE SUB SETRGB (C%, r%, g%, b%)
DECLARE SUB DRAWBARS ()
DECLARE SUB WAITFORKEY ()

SCREEN 12

DRAWBARS
WAITFORKEY

FOR i = 0 TO 15
   READ r, g, b
   SETRGB i, r, g, b
NEXT

LOCATE 20, 40
PRINT "NEW PALETTE"

WAITFORKEY

' BASIC Palette Source, 16 Colors (RGB)

DATA &H00,&H00,&H00,&H3F,&H15,&H15,&H3F,&H18,&H18,&H3F,&H1B,&H1B
DATA &H3F,&H1E,&H1E,&H3F,&H21,&H21,&H3F,&H24,&H24,&H3F,&H27,&H27
DATA &H3F,&H2A,&H2A,&H3F,&H2D,&H2D,&H3F,&H30,&H30,&H3F,&H33,&H33
DATA &H3F,&H36,&H36,&H3F,&H39,&H39,&H3F,&H3C,&H3C,&H3F,&H3F,&H3F

SUB DRAWBARS STATIC
 numcolors = 16
 barwidth = 640 / numcolors
 barheight = 480 / 2
 FOR i = 0 TO 15 STEP 1
    LINE (i * barwidth, 0)-(i * barwidth + barwidth, barheight), i, BF
 NEXT i
END SUB

DEFSNG A-Z
SUB SETRGB (C%, r%, g%, b%) STATIC
  PALETTE C%, 65536 * b% + 256 * g% + r%
END SUB

DEFINT A-Z
SUB WAITFORKEY STATIC
  DO
  LOOP WHILE INKEY$ = ""
END SUB

