; Copyright 1993 DATAWARE
; P.O. Box 64211, Lubbock, TX 79464-4211
;
; This program displays a graphic image (star) on the screen.
;
; The image was produced within STAMP PAD by using the diskette function
; (located on the cut and paste menu). The diskette function saves a
; marked area to a text file in the STAMPPAD directory called ASCII.TXT.
; The file is in the proper format to include it in an assembly language
; program. Each pixel is represented with its equivalent hexadecimal number
; preceded by "db". The procedures included in this sample program will
; display images saved with the diskette function in STAMP PAD.
;
; If you want to display other images using this program, save a file
; using the diskette function in STAMP PAD. Then insert the text from the
; file, ASCII.TXT in the data segment after the label, "stamp_pad".
; The "equ" values also need to be adjusted to specify the size of the image
; and the starting position.
;
; This program was written using MASM 6.0. The compiled version, SAMPLE.EXE
; is also included in the STAMPPAD directory.
;
; *****************************************
; PROGRAM BEGINS HERE
; *****************************************
;
TITLE sample.asm
;
;
.DOSSEG
.MODEL LARGE

; MACROS are located here


; Macro used when displaying text on the screen.
; To use this macro, type "print" and then the label of the text to be
; displayed (located in the data segment). For an example,
; see the label, "message" in the data segment.

    print   MACRO   text	    ; macro to print a line of text at cursor location
	    mov     ah,2	    ; DOS function to set cursor position
	    mov     bh,0	    ; page zero when in graphics mode
	    mov     dh,24	    ; row (Y coordinate)
	    mov     dl,10	    ; column (X coordinate)
	    int     10h 	    ; call BIOS
	    lea     dx,text	    ; gets address of text
	    mov     ah,9	    ; and uses DOS function 9 to print it
	    int     21h
	    call    wait_key	    ;procedure to wait for a key stroke
	    ENDM

; Macro to test for a VGA board
    is_vga  MACRO
	    mov     ax,1a00H	    ; function to determine if VGA ah=1aH al=00
	    int     10h 	    ; call bios
	    cmp     al,1aH	    ; only VGA cards return 1ah in al
	    je	    @F		    ; if VGA continue
	    print   not_vga	    ; if not VGA quit
	    jmp     exit
	    @@:
	    ENDM

; EQU statements are located here except for the EQU statements
; associated with the graphic image.

    VIDEO_SEG	    EQU 0A000H	    ; VGA video segment
    GMODE	    EQU    13H	    ; VGA 320x200, 256 color mode
    DEFAULT_VIDEO   EQU     3	    ; default video mode 80x25 text
    BACK_GROUND     EQU  0000H	    ; color used to clear screen (COLOR-4)

; -----------------------------------------------
.STACK

; -----------------------------------------------
.DATA
; -------------------------------------------------------------------------
; The EQU statements (stamp_pad_x, etc.) determine the location and size of
; the graphic image saved as ASCII.TXT. "stamp_pad_x" and "stamp_pad_y"
; define the upper left hand corner of the graphic image (in pixels) and
; "stamp_pad_x_1" and "stamp_pad_y_1" define the length and height in the
; x-direction in the y-direction respectively.

; -------------------------------------------------------------------------
; location and size of the graphic image
	stamp_pad_x	equ 151	; starting column in pixels
	stamp_pad_y	equ  93	; starting row in pixels
	stamp_pad_x_l	equ  14	; length in pixels
	stamp_pad_y_l	equ  14	; height in pixels

; -------------------------------------------------------------------------
; This is the file, ASCII.TXT with a label called "stamp_pad". If you want to
; display other images using this program, save a file using the
; diskette function in STAMP PAD. Then delete the text following
; the label, "stamp_pad" and replace it with the text from ASCII.TXT.
; The "equ" values (above) also need to be adjusted to specify the size of
; the image and the starting position.

stamp_pad  db 00h,00h,00h,00h,00h,00h,2Ch,2Ch,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
db 2Ch,2Ch,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,00h,00h,00h
db 00h,00h,00h,00h,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,00h,00h,00h,00h,00h,2Ch,2Ch,2Ch,2Ch
db 2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,00h,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch
db 2Ch,2Ch,2Ch,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,00h,00h,00h,00h
db 00h,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,00h,00h,00h,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch
db 2Ch,2Ch,2Ch,00h,00h,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,00h,00h
db 00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,2Ch,00h,00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch
db 00h,00h,2Ch,2Ch,2Ch,2Ch,2Ch,00h,00h,2Ch,2Ch,2Ch,00h,00h,00h,00h,00h,00h,2Ch,2Ch
db 2Ch,00h,2Ch,2Ch,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,2Ch,2Ch


; Additional data used by the display procedures

not_vga 	    db "Requires a VGA card.  Press any key.$"	; error message
message		    db "PRESS ANY KEY TO EXIT$"			; message
color_back_ground   dw 0    ; back ground color for clear_screen
number_of_rows	    dw 0    ; number of rows in graphic image being drawn
number_of_cols	    dw 0    ; number of columns in graphic image being drawn
count_rows	    dw 0    ; counter in draw_screen
start_pos	    dw 0    ; starting position moved to DI, sum row, col math

; -----------------------------------------------
.CODE
.STARTUP
    start:
	mov	ax,@data
	mov	ds,ax	    ; initialize data segment

; test for VGA card
	is_vga		    ; macro for testing for VGA card

; set to VGA graphics mode 320 x 200 -- 256 colors
	mov	ah,0	    ; set video mode function
	mov	al,GMODE    ; mode to be set
	int	10h	    ; call DOS to set video mode

; clear the screen first
	mov	color_back_ground,BACK_GROUND  ; color for clear_screen to use
	call	clear_screen		       ; clear screen to back ground color

; draw the graphic image on the screen
	call	d_stamp_pad ; function to display the graphic image

; message to continue
	print message	    ; macro for displaying text

; reset video
	mov	ah,0		  ; set video mode function
	mov	al,DEFAULT_VIDEO  ; default text mode
	int	10h		  ; call DOS to reset video mode

exit:

.EXIT
; *****************************************
; PROCEDURES
; *****************************************

; -----------------------------------------
; "draw_screen" draws the graphic image that is stored in data segment.
; It assumes DS points to the data segment that contains
; the graphic image.	BX will contain the address of graphic image.
; This procedure will set ES to the video segment for the destination.

draw_screen proc
    mov     di,start_pos	 ; offset in video segment
    mov     ax,VIDEO_SEG	 ; ES gets video segment
    mov     es,ax
    mov     count_rows,0	 ; row counter initialize
next_row:
    mov     cx,number_of_cols	 ; counter for loop-number of columns to be printed
next_char:
    mov     al,ds:[bx]		 ; the byte pointed to by BX is moved to AL
    mov     es:[di],al		 ; AL to video segment
    inc     di			 ; move screen pointer 1 byte to right
    inc     bx			 ; data pointer moved 1 byte
    loop    next_char		 ; loop until CX is zero
    inc     count_rows		 ; advances to next row
    mov     cx,count_rows
    cmp     cx,number_of_rows	 ; see if done enough rows
    je	    exit_set_up 	 ; if equal done
    mov     dx,320		 ; width of screen
    sub     dx,number_of_cols	 ; minus width of the graphic image
    add     di,dx		 ; added to DI is the next row
    jmp     next_row		 ; print another row
exit_set_up:			 ; when complete exit here
    ret

draw_screen endp

; -------------------------------------------------------------------
; "d_stamp_pad" passes the graphic image information to draw_screen to
; actually draw the graphic image. First the offset in the video segment
; is calculated using the X and Y coordinates and passed to draw_screen
; with a variable (start_pos).	Then the length and height are passed
; to draw_screen through variables also.  The address of the actual
; data is passed via the BX register.

d_stamp_pad proc
    mov     cx,stamp_pad_x	 ; column value for the graphic image
    mov     dx,stamp_pad_y	 ; row value for the graphic image
    call    calc_start		 ; calculate starting position
    lea     bx,stamp_pad	 ; address of the graphic image is loaded in BX
    mov     ax,stamp_pad_y_l	 ; length of the graphic image
    mov     number_of_rows,ax	 ; goes into variable
    mov     ax,stamp_pad_x_l	 ; same for height value
    mov     number_of_cols,ax
    call    draw_screen 	 ; draw it on the screen
    ret

d_stamp_pad endp

; -----------------------------------------
; "clear_screen " clears the screen by writing a word (double byte) to
; the video segment which is set in ES

clear_screen proc USES ax cx di es
    mov     ax,VIDEO_SEG	 ; put video segment in ES via AX
    mov     es,ax		 ; destination segment
    mov     cx,32000		 ; number of words in video segment
    mov     ax,color_back_ground ; color to fill background
    mov     di,0		 ; offset in video segment advanced by STOSW
    rep stosw			 ; write the value in AX the number of times in CX
    ret

clear_screen endp

; -------------------------------------------------------------------
; "calc_start" calculates the upper left hand corner
; of the graphic image using row and column values of the graphic image.
; The row and column should be stored:	CX=column position, DX=row position.
; The offset is returned in the "start_pos" variable.

calc_start proc  USES AX BX CX DX
    mov     ax,dx		 ; row (dx) times 320 gives pixel position of row
    mov     bx,320		 ; load bx with pixels per row value
    mul     bx			 ; multiply (bx * ax) result in ax
    add	    ax,cx		 ; add column to result to finish pixel positioning
    mov     start_pos,ax	 ; put pixel position in start_pos
				 ; for use with draw_screen
    ret

calc_start endp

; -----------------------------------------
; "wait_key" uses DOS int 21h to wait for a key press.

wait_key proc
    mov     ah,7		 ; function number
    int     21h 		 ; call DOS
    ret

wait_key endp
; -----------------------------------------

; *****************************************
END
