// CPiece class definition
//////////////////////////////////////////////////////////////////////////////
#ifndef __PIECE_H
#define __PIECE_H

#define CPIECE_UNIT 50

class CPiece : public CObject
{
public:
  CPiece(void);
  CPiece(int,int,int,int);
  ~CPiece(void);
  void draw(CDC*);
  CSize  GetSize(void);    //Gets logical size
  CPoint GetPos(void);     //Gets logical position
  void   SetPos(const CPoint&);
  void   SetPos(int x, int y);
  BOOL PtInPiece(CPoint&); //See in an actual point is within this piece
  void SetMoveLimits(int,int,int,int);
  void Move(CPoint&);
  void Stop(CPoint&);
  CRect rectPiece(void);
  int GetUnitSizeX(void) {return CPIECE_UNIT;};
  int GetUnitSizeY(void) {return CPIECE_UNIT;};

private:
  //State vars
  CSize  m_szActSize;  //Actual size
  CPoint m_ptActPos;   //Actual position
  CSize  m_szLogSize;  //Logical size
  CPoint m_ptLogPos;   //Logical position

  //Motion vars
  int    m_nUpLim;         //Limits of motion inlogical units
  int    m_nDownLim;
  int    m_nLeftLim;
  int    m_nRightLim;
  BOOL   m_bInMotion;      //True if piece is being moved
  BOOL   m_bHoriz;         //Motion is horizontal
  BOOL   m_bVert;          //Motion is verticle
  int    m_nMouseUpLim;    //Limits, within which I'll follow the mouse
  int    m_nMouseRightLim;
  int    m_nMouseDownLim;
  int    m_nMouseLeftLim;
  CPoint m_ptMouseOrg;     //The position of the mouse at LBUTTONDOWN
  CPoint m_ptMouseLast;    //The position of the mouse at the last move msg

  //Helper vars
  int m_xHiliteWidth;      //The width of the hilight on the pieces
  int m_yHiliteWidth;
};

#endif
