#
# Makefile for vh browser -- MSDOS/{Borland|Turbo}C
#
# Set your system type and I/O facilities
# -DUNIX   	-- The OS is UNIX
# -DATT		-- The OS is AT&T UNIX (System III, System V)
# -DMSDOS  	-- The OS is MSDOS
# -DCURSES 	-- curses(3) character-oriented screen handling
# -DATTMOUSE	-- AT&T 6386 /dev/mouse
# -DPOPUP	-- text entry via Mac-like dialogue boxes.
# -DCONST	-- your C has `const'
#
# -DFFGETS      -- faster fgets (Borland/Turbo C only for now)
#
# If you're using Borland Turbo-C under MS-DOS, see TurboMake
#
SYSTYPE=-DMSDOS -DSCROLLBAR -DMOUSE

!if !$d(MODEL)
MODEL=l
!endif

!if !$d(C)
# could be bcc or bccx for Borland C; tcc for Turbo C
C=bcc
!endif

!if $d(ZTC)
CC=ztc -m$(MODEL)i
CFLAGS= -c -g -b -o $(SYSTYPE)
LDFLAGS= -g
!else
CC=$(C) -m$(MODEL) $(X)
CFLAGS= -c -v -Z -O $(SYSTYPE)
LDFLAGS= -v -M
!endif

.c.obj:
	$(CC) $(CFLAGS) $<

jargon: vh
	copy vh.exe jargon.exe

vh: vh.exe

vh.exe: vh.obj browse.obj screen.obj
	$(CC) $(LDFLAGS) vh.obj browse.obj screen.obj

vh.obj: vh.c vh.h
browse.obj: browse.c vh.h screen.h
screen.obj: screen.c screen.h
