EXTPROC CEnvi
/*************************************************************************
 *** KeyPush.cmd - Quick interface to pass KeyPush commands directly.  ***
 *** ver.1         This program temporarily activates the window, does ***
 ***               its stuff, then restores window.                    ***
 *************************************************************************/

#include <PMdll.lib>
#include <WinTools.lib>

main(argc,argv)
{
   if ( argc < 3  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") )
      Instructions();
   else {
      // Append all of the input into a long string
      Code = "";
      for ( i = 2; i < argc; i++ ) {
         strcat(Code," ");
         strcat(Code,argv[i]);
      }

      // save the currently active window to be restored
      RemememberActiveWindow = GetActiveWindow();

      // Set the active window to First argument
      if ( stricmp("NULL",argv[1])  &&  !SetActiveWindow(argv[1]) ) {
         printf("Unrecognized Window Title \"%s\"\n\a",argv[1]);
         exit(EXIT_FAILURE);
      }

      ExecuteKeyPushCode(Code);

      // Restore currently active window
      if ( stricmp("NULL",argv[1]) )
         SetActiveWindow(RemememberActiveWindow);
   }
}


ExecuteKeyPushCode(CodeString)
{
   system("CEnvi \"#include \'KeyPush.lib\'%s \"",CodeString);
}

Instructions()
{
   printf("\n")
   printf("   KeyPush - Quick commands to the KeyPush.lib functions\n")
   printf("\n")
   printf("   SYNTAX: KeyPush WinTitle KeyPushCode...\n")
   printf("\n")
   printf("   Where: WinTitle - Name of a window; use NULL for currently active window\n")
   printf("                     If not NULL then switches to this window for commands.\n")
   printf("          KeyPushCode - Any code from the KeyPush.lib library.  Read\n")
   printf("                        KeyPush.lib for all the functions and codes.\n")
   printf("                        Strings must be enclosed in SINGLE QUOTES (\')\n");
   printf("\n")
   printf("   Example: This examples selects the second from smallest DOS font\n")
   printf("     KeyPush \"DOS Window\" KeyStroke(VK_ALT); KeyStroke('F');\n")
   printf("     KeyStroke(VK_HOME); KeyStroke(VK_DOWN); KeyStroke(VK_ENTER);\n")
   printf("\n")
   printf("   Example: This examples mimics all the keystrokes to lockup screen\n")
   printf("     KeyPush \"Desktop\" KeyStroke(VK_CTRL,'\\\\');\n")
   printf("     KeyStroke(VK_SHIFT,VK_F10); KeyStroke('L');\n")
   printf("\n")
   printf("   Example: These two examples write \"doggy\" to the E.EXE editor\n")
   printf("     KeyPush E.EXE KeyStroke(\'doggy\');\n")
   printf("     KeyPush E.EXE SpeedKeys(\'doggy\');\n")
}

