EXTPROC CENVI
/***********************************************************
 *** NekoSavr.cmd - screen saver using keyboard routines ***
 *** ver.1                                               ***
 ***********************************************************/

main(argc,argv)
{
   // test that the input looks valid
   if ( argc != 2
     || !isdigit(argv[1][0])
     || (QuietInterval = atoi(argv[1])) < 1 )
      ShowInstructions();
   else {
      // kill the resident Neko screen saver it it;s already running
      system("kill \"%s\"",WindowTitle);
      suspend(2000);
      // install the resident version of this program
      system("start \"%s\" /N /B /WIN /MIN CEnvi #include '%s,,,/*RESIDENT*/' Forever(%d)",
             WindowTitle,argv[0],60 * QuietInterval);

      // hide the resident version of this program
      suspend(5000);
      system("WinSet \"%s\" HIDE",WindowTitle);
      printf("Cat & Mouse games will begin after %d minutes of keyboard and\n"
             "mouse inactivity.\n",QuietInterval);
   }
}

ShowInstructions()
{
   printf("\a\n");
   printf("NekoSavr.cmd - Cat & Mouse Screen Saver. Run NEKO.EXE if there is no\n");
   printf("               keyboard keys or mouse keys pressed. End NEKO.EXE when\n");
   printf("               keys pressed again.\n");
   printf("\n");
   printf("SYNTAX: NekoSavr Interval\n");
   printf("\n");
   printf("Where:   Interval - How many minutes of no keyboard or mouse-button activity\n");
   printf("                    before the Cat & Mouse screen saver begins\n");
   printf("\n");
   printf("Example: NekoSavr 5      - Start neko after 5 minutes of inactivity\n");
   printf("         NekoSavr 1      - Start neko after 1 minute of inactivity\n");
   printf("\n");
}


/*RESIDENT*/
// All code below this is part of the resident program

#include <KeyPush.lib>

WindowTitle = "Neko Screen Saver";

#define  START_WAIT_INTERVAL  4000  // set for how often to check the table for changes
                                    // in milliseconds while waiting to start screen saver
#define  END_WAIT_INTERVAL    750   // interval to wait while waiting to end screen saver

#define  KEYBOARD_TABLE_SIZE  256

Forever(QuietInterval)
   // wait until QuietInterval seconds has elapsed with no apparent keyboard
   // activity.
{
   while(TRUE) {
      WaitForInactivity(QuietInterval); // wait for period of inactivity
      StartProgram();                   // start program, and get handle
      WaitForActivity();      // wait for a keyboard or mouse press
      EndProgram();
   }
}

WaitForInactivity(QuietInterval) // check every once in a while, and return after a
{                                // long period of inactivity
   // check at every interval and set keyboard if it is not already set
   PrevTable = GetGlobalKeyboardTable();
   PrevPos = PointerPosition();
   EndTime = time() + QuietInterval;
   // stay in this block until period of inactivity has occurred
   do {
      suspend(START_WAIT_INTERVAL); // wait a while
      CurrentTable = GetGlobalKeyboardTable();
      CurrentPos = PointerPosition();
      if ( memcmp(CurrentTable,PrevTable,KEYBOARD_TABLE_SIZE)
        || CurrentPos != PrevPos ) {
         // table has changed; reset EndTime and remember table
         EndTime = time() + QuietInterval;
         PrevTable = CurrentTable;
         PrevPos = CurrentPos;
      }
   } while ( time() < EndTime );
}

WaitForActivity() // check every once in a while, and return after a
{                 // change in the keyboard or mouse
   PreviousTable = GetGlobalKeyboardTable();
   PrevPos = PointerPosition();
   while( !memcmp(PreviousTable,GetGlobalKeyboardTable(),KEYBOARD_TABLE_SIZE)
       && PrevPos == PointerPosition() ) {
      printf("\nwaiting for change");
      suspend(END_WAIT_INTERVAL);
   }
}


StartProgram()
{
   // start NEKO running
   system("start /B /PM NEKO.EXE");
   suspend(3000);

   // pass keystrokes to NEKO to make desktop go away
   KeyStroke(VK_ENTER);
   suspend(5000);
   KeyStroke(VK_ENTER);
   suspend(1500);
}


EndProgram()
{
   KeyStroke(VK_ALT);
   KeyStroke(VK_ALT,VK_F4);
}


ForceRandomChange = 0; // if can't read table then pretend that it has changed

GetGlobalKeyboardTable()
{
   #define HWND_DESKTOP                     1
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   KeyTable[KEYBOARD_TABLE_SIZE-1] = '\0'; // pre-allocate a 256 byte buffer
   if !DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
                   HWND_DESKTOP,KeyTable,FALSE) {
      // could not read global key table, and so pretend it has changed
      KeyTable[0] = (ForceRandomChange ^= 1);
   }
   return(KeyTable);
}

PointerPosition() // return current cursor position in screen coordinates
{                 // structure elements returned are .col and .row
   #define ORD_WIN32QUERYPOINTERPOS 823
   BLObSize(pointer,4 * 2);
   DynamicLink("PMWIN",ORD_WIN32QUERYPOINTERPOS,BIT32,CDECL,
               HWND_DESKTOP,pointer);
   position.col = BLObGet(pointer,0,SWORD16);
   position.row = BLObGet(pointer,4,SWORD16);
   return(position);
}


