;;; emx-keys.el --- key bindings for emx

;; Copyright (C) 1992, 1993 Eberhard Mattes

;; Author: Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
;; Keywords: emx

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Code:

(require 'emx-funcs)
(provide 'emx-keys)

(autoload 'switch-to-other-buffer "lucid" "\
Switch to the previous buffer." t nil)

(global-unset-key [0])

(define-key global-map [f2] 'switch-to-other-buffer)
(global-set-key [f3]       'emx-search-forward)
(global-set-key [f4]       'emx-search-backward)
(global-set-key [f5]       'emx-fill-paragraph)
(global-set-key [f6]       'other-window)
(global-set-key [f11]      'call-last-kbd-macro)
(global-set-key [f12]      'set-mark-command)
;(global-set-key [left]     (list global-map 'left))  ; backward-char
;(global-set-key [right]    (list global-map 'right)) ; forward-char
;(global-set-key [up]       (list global-map 'up))    ; previous-line
;(global-set-key [down]     (list global-map 'down))  ; next-line
(global-set-key [pageup]   'scroll-down)
(global-set-key [pagedown] 'scroll-up)
(global-set-key [center]   'goto-line)
(global-set-key [home]     'beginning-of-line)
(global-set-key [end]      'end-of-line)
(global-set-key [insert]   'overwrite-mode)
(global-set-key [delete]   (list global-map 'deletechar)) ; delete-char
(global-set-key [S-f1]     'describe-key)
(global-set-key [S-f3]     'next-error)
(global-set-key [S-f11]    'expand-abbrev)
(global-set-key [?\C-2]    'set-mark-command)
(global-set-key [C-space]  'set-mark-command)
(global-set-key [C-left]   'emx-backward-to-word)
(global-set-key [C-right]  'emx-forward-to-word)
(global-set-key [C-up]     'emx-scroll-line-down)
(global-set-key [C-down]   'emx-scroll-line-up)
(global-set-key [C-home]   'emx-kill-left-line)
(global-set-key [C-end]    'kill-line)
(global-set-key [C-pageup]   'emx-beginning-of-buffer)
(global-set-key [C-pagedown] 'emx-end-of-buffer)
(global-set-key [C-delete] 'emx-kill-word)
(global-set-key [?\A-b]    'gdb-break)
(global-set-key [?\A-f]    'find-file)
(global-set-key [?\A-g]    'goto-line)
(global-set-key [?\A-o]    'open-rectangle)
(global-set-key [A-space]  'scroll-other-window)
(global-set-key [A-BS]     'undo)
(global-set-key [A-left]   'scroll-right)
(global-set-key [A-right]  'scroll-left)
(global-set-key [A-up]     'backward-paragraph)
(global-set-key [A-down]   'forward-paragraph)
(global-set-key [A-pageup]   'backward-page)     ; useful for Tree Dired
(global-set-key [A-pagedown] 'forward-page)      ; useful for Tree Dired

(global-set-key [f9 ?a]    'emx-add-number)
(global-set-key [f9 ?c]    'compile)
(global-set-key [f9 ?d]    'emx-dup-line)
(global-set-key [f9 ?D]    'emx-toggle-debug-on-error)
(global-set-key [f9 ?g]    'goto-line)
(global-set-key [f9 ?h]    'electric-command-history)
(global-set-key [f9 ?i]    'emx-toggle-case-fold-search)
(global-set-key [f9 ?j]    'just-one-space)
(global-set-key [f9 ?l]    'emx-copy-line-as-kill)
(global-set-key [f9 ?m]    'emx-match-paren)
(global-set-key [f9 ?o]    'emx-copy-region)
(global-set-key [f9 ?t]    'emx-toggle-truncate-lines)
(global-set-key [f9 ?v]    'emx-buffer-file-name)
(global-set-key [f9 ?w]    'what-line)
(global-set-key [f9 ?y]    'emx-yank-line)
(global-set-key [f9 ?\t]   'indent-relative)

;;
;; f9: Use "word" around or before point as argument
;;
(global-set-key [f9 f2]     'emx-find-file-at-point)
(global-set-key [f9 f3]     'emx-search-forward-at-point)
(global-set-key [f9 f4]     'emx-search-backward-at-point)

;;
;; S-f9: Use region as argument
;;
(global-set-key [S-f9 f2]   'emx-find-file-region)
(global-set-key [S-f9 f3]   'emx-search-forward-region)
(global-set-key [S-f9 f4]   'emx-search-backward-region)

(defun emx-gud-keys ()
  "Define keys for gdb mode."
  (define-key global-map [f5] 'gud-cont)
  (define-key global-map [f8] 'gud-step)
  (define-key global-map [f10] 'gud-next)
  (define-key global-map [s-f8] 'gud-stepi)
  (define-key global-map [f7]
    (lookup-key global-map gud-key-prefix)))

(add-hook 'gud-mode-hook 'emx-gud-keys t)

;;; emx-keys.el ends here
