/*********************************************************************
  FX80.cmd
 *********************************************************************

   This is the ENGLISH VERSION of FX80.cmd

   This is a REXX-Script which can print ASCII-Files in 2 columns, small
   font on an Epson FX80 or compatible.

  Supported Printoptions:
    SCR -- Screen, 10 Lines per Page, 30 Characters per column
    FXS -- FX80, 150 Lines per Page, 79 Characters per column, small font
    FXE -- FX80, only 1 column-Spaltig, Font: Elite

  You may have to disable the OS/2 print spooler to use this utility.

 *********************************************************************

  This script is FREEWARE. Usage and Patching for e.g. another printer
  etc. is allowed, as long as this comment is not modified, and my name and
  adress is not cut from this file..

  If you make major modifications you wish to share, please email me a
  copy (which a corresponding comment).

  My address:  Ralf Grohmann, Winterlinger Weg 8, 70567 Stuttgart, Germany
    or email:   ralf@ubka.uni-karlsruhe.de

   (c) Ralf Grohmann 8/93, 1/94
 ******************************************************************** */
ARG DATEI MODE opt1 opt2

say '**** ASCII-File - Printer V 1.0                    (c) 1993 Ralf Grohmann ****'

IF mode<>'FXS' & mode <>'FXE' & mode<>'SCR' then do
    call help
    EXIT
    END
IF datei='/h' | datei='/?' | datei='-?' | datei='-h' then do
    call help
    EXIT
    END

IF lines(datei)=0 then do
    say 'Error: File <' datei '> not found!'
    EXIT
    END

/* Parse Options */
pagepause=no
test=no
opt1=left(opt1,2)
opt2=left(opt2,2)
if opt1='/P' | opt2='/P' then pagepause=yes
if opt1='/T' | opt2='/T' then test=yes



/****  Printer-Parms: *****
  initstring : Initialisation-String for the Output-printer (binary Chars)
  sep:         Separator (between the comumns, width 2)
  cret:        Newline (to start a new line)
  ffeed:       FormFeed (send at the end of each page)
  pglen:       Pagelength
  maxzl:       Columnwidth
  pageno:      Starting pagenumber
  protocol:    yes|no (should a Status-Display be generated?)
  dest:        Output-Destination, 'prn:' or 'stdout:' or ...
  dotrans:     yes|no (Should a Character - Transposition (for german Umlauts) be done?
  columns:     Number of columns, 1 or 2
*/

IF MODE='FXS' THEN DO
/*****  EPSON FX80+ small-mode ********
   Printer Reset, small font, no border.
     ESC @        Reset
     ESC 6        allow Chars > 127
     ESC (15)     Schmalschrift
     ESC M        Elite
     ESC 3 (15)   15/216 inch line spacing
     ESC S 0      Superscript
     ESC Q (160)  right margin
*/
initstring='@6M3S0Q'
sep='  '
cret = D2C(13) D2C(10)
ffeed = D2C(12)
pglen=150
maxzl=79
pageno=1
protocol=YES
dest='prn:'
dotrans=yes
columns=2
END

IF MODE='FXE' THEN DO
/*****  EPSON FX80+ Elite, 1 column ********
   Printer reset,, Elite, left margin 5.
     ESC @        Reset
     ESC 6        allow Chars > 127
     ESC M        Elite
     ESC l (5)    Linker Rand 5
     ESC 0        Zeilenabstand 1/8 Zoll
*/
initstring='@6Ml0'
sep=''
cret = D2C(13) D2C(10)
ffeed = D2C(12)
/* 85 Lines are used for 12" paper */
pglen=85
maxzl=90
pageno=1
protocol=YES
dest='prn:'
dotrans=yes
columns=1
END

/***** Preview to Screen ******/
IF mode='SCR' THEN DO
initstring='';
sep='  '
cret = D2C(13) || D2C(10);
ffeed = '************---- NEXT PAGE -----****************'
pglen=10
maxzl=38
pageno=1
protocol=no
dest='stdout:'
dotrans=no
columns=2
END


/* HeaderString */
if columns=2 then do
hstr='Printing File  <' right(datei,min(length(datei),30)) '> at ' DATE(E)
hstr=left(hstr,maxzl*2-10) '  Page: '
hstr2=right('',maxzl*2+length(sep),'-')
end
else do
hstr='Printing File  <' right(datei,min(length(datei),30)) '> at ' DATE(E)
hstr=left(hstr,maxzl-12) '  Page: '
hstr2=right('',maxzl,'-')
end

/* Drucker initialisieren */
r=out(initstring);

/***** EINLESEN **********/
i=1
side=0
aktzl=0
DO WHILE lines(datei)
  instring=LINEIN(datei)
  if length(instring)>maxzl then
       in.i.side=LEFT(instring,maxzl-1) || '>'
  else in.i.side=LEFT(instring,maxzl)
  aktzl=aktzl+1
  i=i+1
  IF i=pglen+1 & side=0 THEN DO
          side=1
          if columns=1 then DO
            CALL printside
            side=0
            DROP in.
            END
          i=1
          END
  IF i=pglen+1 & side=1 THEN DO
          CALL printside
          side=0
          i=1
          DROP in.
          END
END /* DO WHILE LINES */

/* DEBUG: SAY 'xxxx' i side columns */
if i >= 1 THEN DO
          CALL printside
          DROP in.
          END

if test=no then SAY 'File ' datei ' printed (' aktzl ' Lines, ' pageno-1' Page(s) ).'
 else SAY 'File ' datei ' tested (' aktzl ' Lines, ' pageno-1' Page(s) ).'
r=out('')
EXIT


/*********************************************************************/
/* Prozedur um eine Seite zu drucken */
/* printside: PROCEDURE EXPOSE pglen in. sep cret */
printside:
/* DEBUG say '***** i= ' i ' side= ' side */

IF protocol=yes THEN say 'Now printing page ' pageno
r=out(hstr || format(pageno,3) || cret || hstr2 )
pageno=pageno+1
if columns=2 then DO pr_t = 1 TO pglen BY 1
  DROP temp
  IF side=0 & i > pr_t THEN temp=in.pr_t.0 || sep
  IF side=0 & i <= pr_t THEN leave
  IF side=1 & i > pr_t THEN temp=in.pr_t.0 || sep || in.pr_t.1
  IF side=1 & i <= pr_t THEN temp=in.pr_t.0 || sep
  r=out(temp)
 END
ELSE DO pr_t = 1 TO pglen BY 1
 if pr_t < i then r=out(in.pr_t.0)
 END
r=out(ffeed)
if pagepause=yes then do
   say 'Return for next page'
   parse pull arg
   end
RETURN

/*********************************************************************/
/* Prozedur zum Ausdrucken
   Ruft evtl. vorher die Zeichenumsetzungsroutine auf */
out:
PARSE ARG string

if dotrans=yes then outstring = deutsch(string) || cret
   else outstring = string || cret
if test=no then do
    res=CHAROUT(dest , outstring )
    if res <> 0 THEN
        SAY 'Error! ' res ' Characters could not be output!'
    END
RETURN 0

/*********************************************************************/
/* Setze alle Spezialzeichen um */
/* Recode all special Chars */

deutsch: PROCEDURE
parse arg str
/* Syntax Translate(str, to, from) */
str=TRANSLATE(str,'{','')
str=TRANSLATE(str,'|','')
str=TRANSLATE(str,'}','')
str=TRANSLATE(str,'[','')
str=TRANSLATE(str,'\','')
str=TRANSLATE(str,']','')
str=TRANSLATE(str,'~','')
RETURN str

/*********************************************************************/
/* Hilfe-Ausgabe */
help: PROCEDURE
SAY
SAY 'Usage: fx80 <Name-of-file-to-be-printed> <mode> [opts]'
SAY
SAY 'mode: FXS|FXE|SCR  (Destination)'
SAY '       FXS - Small Font, 2 columns'
SAY '       FXE - 1 column, Elite-Font'
SAY '       SCR - Testoutput to stdout'
SAY 'opts:  /Test - Don''t do the actual output, but test file.'
SAY '       /Pagepause  - Wait after each page printed?'
RETURN
